/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.AddColumnFilter;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.CalculatorColumnSupplement;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.PermutedColumnSupplement;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.vo.ResolverException;
import uk.ac.starlink.vo.ResolverInfo;

public class ResolverFilter
extends BasicFilter {
    public ResolverFilter() {
        super("addresolve", "<col-id-objname> <col-name-ra> <col-name-dec>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Performs name resolution on the string-valued column", "<code>&lt;col-id-objname&gt;</code> and appends two new columns", "<code>&lt;col-name-ra&gt;</code> and", "<code>&lt;col-name-dec&gt;</code>", "containing the resolved Right Ascension and Declination", "in degrees.", "</p>", ResolverFilter.explainSyntax(new String[]{"col-id-objname"}), "<p>UCDs are added to the new columns in a way which tries to", "be consistent with any UCDs already existing in the table.", "</p>", "<p>Since this filter works by interrogating a remote service,", "it will obviously be slow.", "The current implementation is experimental;", "it may be replaced in a future release", "by some way of doing the same thing (perhaps a new STILTS task)", "which is able to work more efficiently by dispatching multiple", "concurrent requests.", "</p>", "<p>This is currently implemented using the Simbad service", "operated by", "<webref url='http://cdsweb.u-strasbg.fr/'>CDS</webref>.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String objId = null;
        String raName = null;
        String decName = null;
        while (argIt.hasNext() && (objId == null || raName == null || decName == null)) {
            String arg = argIt.next();
            if (objId == null) {
                argIt.remove();
                objId = arg;
                continue;
            }
            if (raName == null) {
                argIt.remove();
                raName = arg;
                continue;
            }
            if (decName != null) continue;
            argIt.remove();
            decName = arg;
        }
        if (objId != null && raName != null && decName != null) {
            final SesameResolver resolver = new SesameResolver();
            final String objId0 = objId;
            final String raName0 = raName;
            final String decName0 = decName;
            return new ProcessingStep(){

                @Override
                public StarTable wrap(StarTable base) throws IOException {
                    int iNameCol = new ColumnIdentifier(base).getColumnIndex(objId0);
                    PermutedColumnSupplement inNameSup = new PermutedColumnSupplement(base, new int[]{iNameCol});
                    ResolverSupplement outCoordsSup = new ResolverSupplement(inNameSup, resolver, raName0, decName0, Tables.getColumnInfos((StarTable)base), 100000);
                    AddColumnsTable out = new AddColumnsTable(base, outCoordsSup);
                    int ncol = out.getColumnCount();
                    AddColumnFilter.checkDuplicatedName((StarTable)out, ncol - 2);
                    AddColumnFilter.checkDuplicatedName((StarTable)out, ncol - 1);
                    return out;
                }
            };
        }
        throw new ArgException("Bad " + this.getName() + " specification");
    }

    private static class SesameResolver
    extends Resolver {
        SesameResolver() {
            super("Sesame");
        }

        @Override
        public double[] resolve(String objName) {
            try {
                ResolverInfo info = ResolverInfo.resolve((String)objName);
                return new double[]{info.getRaDegrees(), info.getDecDegrees()};
            }
            catch (ResolverException e) {
                return null;
            }
        }
    }

    private static abstract class Resolver {
        private final String serviceName_;

        protected Resolver(String serviceName) {
            this.serviceName_ = serviceName;
        }

        public String getServiceName() {
            return this.serviceName_;
        }

        public abstract double[] resolve(String var1);
    }

    private static class ResolverSupplement
    extends CalculatorColumnSupplement {
        private final Resolver resolver_;
        private final Map<String, Pair> cache_;

        ResolverSupplement(ColumnSupplement nameSup, Resolver resolver, String raName, String decName, ColumnInfo[] baseColInfos, final int cacheSize) throws IOException {
            super(nameSup, ResolverSupplement.createColumnInfos(raName, decName, resolver, baseColInfos));
            this.resolver_ = resolver;
            HashMap cache = cacheSize >= 0 ? new LinkedHashMap<String, Pair>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, Pair> eldest) {
                    return this.size() > cacheSize;
                }
            } : new HashMap();
            this.cache_ = Collections.synchronizedMap(cache);
        }

        @Override
        protected Object[] calculate(Object[] inValues) {
            String objName;
            Object item = inValues[0];
            if (item instanceof String && (objName = (String)item).trim().length() > 0) {
                Pair p;
                if (!this.cache_.containsKey(objName)) {
                    double[] radec = this.resolver_.resolve(objName);
                    p = radec == null || Double.isNaN(radec[0]) || Double.isNaN(radec[1]) ? null : new Pair(radec[0], radec[1]);
                    this.cache_.put(objName, p);
                }
                if ((p = this.cache_.get(objName)) != null) {
                    return new Object[]{p.ra_, p.dec_};
                }
            }
            return new Object[2];
        }

        private static ColumnInfo[] createColumnInfos(String raName, String decName, Resolver resolver, ColumnInfo[] baseColInfos) {
            String decUcd;
            String raUcd;
            boolean is1plus;
            String serviceName = resolver.getServiceName();
            ColumnInfo raInfo = new ColumnInfo(raName, Double.class, "Resolved Right Ascension as determined by " + serviceName);
            ColumnInfo decInfo = new ColumnInfo(decName, Double.class, "Resolved Declination as determined by " + serviceName);
            raInfo.setUnitString("deg");
            decInfo.setUnitString("deg");
            boolean hasRa = false;
            boolean hasDec = false;
            int like1 = 0;
            int like1plus = 0;
            Pattern raRegex = Pattern.compile("^pos.eq.ra.*", 2);
            Pattern decRegex = Pattern.compile("^pos.eq.dec.*", 2);
            for (int icol = 0; icol < baseColInfos.length; ++icol) {
                String ucd = baseColInfos[icol].getUCD();
                if (ucd == null) continue;
                hasRa = hasRa || raRegex.matcher(ucd).matches();
                hasDec = hasDec || decRegex.matcher(ucd).matches();
                int leng = ucd.length();
                for (int i = 0; i < leng; ++i) {
                    char c = ucd.charAt(i);
                    if (c == '_') {
                        ++like1;
                        continue;
                    }
                    if (c != '.') continue;
                    ++like1plus;
                }
            }
            boolean bl = is1plus = like1plus >= like1;
            if (hasRa || hasDec) {
                raUcd = is1plus ? "pos.eq.ra" : "POS_EQ_RA";
                decUcd = is1plus ? "pos.eq.dec" : "POS_EQ_DEC";
            } else {
                raUcd = is1plus ? "pos.eq.ra;meta.main" : "POS_EQ_RA_MAIN";
                decUcd = is1plus ? "pos.eq.dec;meta.main" : "POS_EQ_DEC_MAIN";
            }
            raInfo.setUCD(raUcd);
            decInfo.setUCD(decUcd);
            return new ColumnInfo[]{raInfo, decInfo};
        }

        private static class Pair {
            final double ra_;
            final double dec_;

            Pair(double ra, double dec) {
                this.ra_ = ra;
                this.dec_ = dec;
            }
        }
    }
}

