/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.SequentialRowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class SequentialViewFilter
extends BasicFilter
implements ProcessingStep {
    public SequentialViewFilter() {
        super("seqview", null);
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Ensures that steps downstream see the table", "as sequential access.", "Any attempts at random access will fail.", "Only useful for debugging.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) {
        return this;
    }

    @Override
    public StarTable wrap(StarTable base) throws IOException {
        return new WrapperStarTable(base){

            public boolean isRandom() {
                return false;
            }

            public long getRowCount() {
                return -1L;
            }

            public RowSplittable getRowSplittable() throws IOException {
                return new SequentialRowSplittable((StarTable)this);
            }
        };
    }
}

