/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;

public class SetParameterFilter
extends BasicFilter {
    public SetParameterFilter() {
        super("setparam", "[-type byte|short|int|long|float|double|boolean|string]\n[-desc <descrip>] [-unit <units>] [-ucd <ucd>]\n[-utype <utype>] [-xtype <xtype>]\n<pname> <pexpr>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Sets a named parameter in the table to a given value.", "The parameter named <code>&lt;pname&gt;</code> is set", "to the value <code>&lt;pexpr&gt;</code>,", "which may be a literal value or an expression involving", "mathematical operations and other parameter names", "(using the <code>param$&lt;name&gt;</code> syntax).", "By default, the data type of the parameter is determined", "by the type of the supplied expression,", "but this can be overridden using the <code>-type</code> flag.", "The parameter description, units, UCD, Utype and Xtype attributes", "may optionally be set using the other flags.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        String ptype = null;
        String pname = null;
        String pexpr = null;
        String pdesc = null;
        String pucd = null;
        String putype = null;
        String pxtype = null;
        String punits = null;
        while (argIt.hasNext()) {
            String arg = argIt.next();
            if ("-type".equals(arg) && ptype == null && argIt.hasNext()) {
                argIt.remove();
                ptype = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-desc") && pdesc == null && argIt.hasNext()) {
                argIt.remove();
                pdesc = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-ucd") && pucd == null && argIt.hasNext()) {
                argIt.remove();
                pucd = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-utype") && putype == null && argIt.hasNext()) {
                argIt.remove();
                putype = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-xtype") && pxtype == null && argIt.hasNext()) {
                argIt.remove();
                pxtype = argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-unit") && punits == null && argIt.hasNext()) {
                argIt.remove();
                punits = argIt.next();
                argIt.remove();
                continue;
            }
            if (pname == null) {
                pname = arg;
                argIt.remove();
                continue;
            }
            if (pexpr != null) continue;
            pexpr = arg;
            argIt.remove();
        }
        if (pname == null) {
            throw new ArgException("No parameter name specified");
        }
        if (pexpr == null) {
            throw new ArgException("No parameter value specified");
        }
        final String name = pname;
        final String expr = pexpr;
        final String type = ptype;
        final String descrip = pdesc;
        final String ucd = pucd;
        final String utype = putype;
        final String xtype = pxtype;
        final String units = punits;
        final Class<?> clazz = type == null ? null : SetParameterFilter.getClass(type);
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) throws IOException {
                Object value = SetParameterFilter.evaluate(expr, base, clazz, type);
                base.setParameter(SetParameterFilter.createDescribedValue(name, value, descrip, ucd, utype, xtype, units, clazz));
                return base;
            }
        };
    }

    private static Class<?> getClass(String type) throws ArgException {
        if ("byte".equals(type = type.toLowerCase().trim())) {
            return Byte.TYPE;
        }
        if ("short".equals(type)) {
            return Short.TYPE;
        }
        if ("int".equals(type)) {
            return Integer.TYPE;
        }
        if ("long".equals(type)) {
            return Long.TYPE;
        }
        if ("float".equals(type)) {
            return Float.TYPE;
        }
        if ("double".equals(type)) {
            return Double.TYPE;
        }
        if ("string".equals(type)) {
            return String.class;
        }
        throw new ArgException("Unknown parameter type \"" + type + "\"");
    }

    public static Object evaluate(String expr, StarTable table, Class<?> clazz, String type) throws IOException {
        Object value;
        CompiledExpression compex;
        String qexpr = "\"" + expr + "\"";
        String cexpr = clazz == null ? expr : "(" + clazz.getCanonicalName() + ") (" + expr + ")";
        JELRowReader rdr = JELUtils.createDatalessRowReader(table);
        Library lib = JELUtils.getLibrary(rdr);
        try {
            compex = Evaluator.compile(cexpr, lib, clazz);
        }
        catch (CompilationException e) {
            if (clazz == null || clazz.equals(String.class)) {
                return expr;
            }
            String msg = "Bad expression " + qexpr + " for type " + (type == null ? clazz.getName() : type) + ": " + e.getMessage();
            throw (IOException)new IOException(msg).initCause(e);
        }
        try {
            value = rdr.evaluate(compex);
        }
        catch (Throwable e) {
            if (clazz == null || clazz.equals(String.class)) {
                return expr;
            }
            String msg = "Evaluation error for " + qexpr + ": " + e.getMessage();
            throw (IOException)new IOException(msg).initCause(e);
        }
        if (clazz == null && (value instanceof Short || value instanceof Byte)) {
            return ((Number)value).intValue();
        }
        return value;
    }

    private static DescribedValue createDescribedValue(String name, Object value, String descrip, String ucd, String utype, String xtype, String units, Class<?> clazz) throws IOException {
        Class<?> pclazz = clazz == null ? value.getClass() : JELUtils.getWrapperType(clazz);
        DefaultValueInfo info = new DefaultValueInfo(name, pclazz, descrip);
        if (ucd != null && ucd.trim().length() > 0) {
            info.setUCD(ucd);
        }
        if (utype != null && utype.trim().length() > 0) {
            info.setUtype(utype);
        }
        if (xtype != null && xtype.trim().length() > 0) {
            info.setXtype(xtype);
        }
        if (units != null && units.trim().length() > 0) {
            info.setUnitString(units);
        }
        return new DescribedValue((ValueInfo)info, value);
    }
}

