/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class ShuffleFilter
extends BasicFilter {
    public ShuffleFilter() {
        super("shuffle", "[-seed <int>]");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Randomly permutes the rows of the input table.", "The random seed can optionally be specified.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        Random rnd = null;
        while (argIt.hasNext()) {
            long lseed;
            String arg = argIt.next();
            if (!arg.equals("-seed") || !argIt.hasNext() || rnd != null) continue;
            argIt.remove();
            String seedTxt = argIt.next();
            argIt.remove();
            try {
                lseed = Long.parseLong(seedTxt);
            }
            catch (NumberFormatException e) {
                throw new ArgException("Seed \"" + seedTxt + "\" not numeric");
            }
            rnd = new Random(lseed);
        }
        if (rnd == null) {
            rnd = new Random();
        }
        return new ShuffleStep(rnd);
    }

    private static class ShuffleStep
    implements ProcessingStep {
        private final Random rnd_;

        ShuffleStep(Random rnd) {
            this.rnd_ = rnd;
        }

        @Override
        public StarTable wrap(StarTable table) throws IOException {
            int i;
            long lnrow = (table = Tables.randomTable((StarTable)table)).getRowCount();
            if (lnrow > Integer.MAX_VALUE) {
                throw new IOException("Sorry, can't shuffle tables with >2^31 rows");
            }
            int nrow = (int)lnrow;
            long[] rowMap = new long[nrow];
            for (i = 0; i < nrow; ++i) {
                rowMap[i] = i;
            }
            for (i = nrow - 1; i > 0; --i) {
                int iswap = this.rnd_.nextInt(i);
                long t = rowMap[iswap];
                rowMap[iswap] = rowMap[i];
                rowMap[i] = t;
            }
            return new RowPermutedStarTable(table, rowMap);
        }
    }
}

