/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.GKQuantiler;
import uk.ac.starlink.ttools.filter.MetadataFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.Quantiler;
import uk.ac.starlink.ttools.filter.SortQuantiler;
import uk.ac.starlink.ttools.filter.TableStats;
import uk.ac.starlink.ttools.filter.UnivariateStats;
import uk.ac.starlink.ttools.filter.ValueInfoMapGroupTable;
import uk.ac.starlink.util.MapGroup;

public class StatsFilter
extends BasicFilter {
    private static final ValueInfo NGOOD_INFO = new DefaultValueInfo("NGood", Number.class, "Number of non-blank cells");
    private static final ValueInfo NBAD_INFO = new DefaultValueInfo("NBad", Number.class, "Number of blank cells");
    private static final ValueInfo MEAN_INFO = new DefaultValueInfo("Mean", Float.class, "Average");
    private static final ValueInfo POPSD_INFO = new DefaultValueInfo("StDev", Float.class, "Population Standard deviation");
    private static final ValueInfo POPVAR_INFO = new DefaultValueInfo("Variance", Float.class, "Population Variance");
    private static final ValueInfo SAMPSD_INFO = new DefaultValueInfo("SampStDev", Float.class, "Sample Standard Deviation");
    private static final ValueInfo SAMPVAR_INFO = new DefaultValueInfo("SampVariance", Float.class, "Sample Variance");
    private static final ValueInfo MAD_INFO = new DefaultValueInfo("MedAbsDev", Float.class, "Median Absolute Deviation");
    private static final ValueInfo SMAD_INFO = new DefaultValueInfo("ScMedAbsDev", Float.class, "Median Absolute Deviation * 1.4826");
    private static final ValueInfo SKEW_INFO = new DefaultValueInfo("Skew", Float.class, "Gamma 1 skewness measure");
    private static final ValueInfo KURT_INFO = new DefaultValueInfo("Kurtosis", Float.class, "Gamma 2 peakedness measure");
    private static final ValueInfo MIN_INFO = new DefaultValueInfo("Minimum", Comparable.class, "Numeric minimum");
    private static final ValueInfo MAX_INFO = new DefaultValueInfo("Maximum", Comparable.class, "Numeric maximum");
    private static final ValueInfo SUM_INFO = new DefaultValueInfo("Sum", Double.class, "Sum of values");
    private static final ValueInfo MINPOS_INFO = new DefaultValueInfo("MinPos", Long.class, "Row index of numeric minimum");
    private static final ValueInfo MAXPOS_INFO = new DefaultValueInfo("MaxPos", Long.class, "Row index of numeric maximum");
    private static final ValueInfo CARDINALITY_INFO = new DefaultValueInfo("Cardinality", Integer.class, "Number of distinct values in column; values >100 ignored");
    private static final ValueInfo MEDIAN_INFO = new QuantileInfo(0.5, "Median", "Middle value in sequence");
    private static final ValueInfo Q1_INFO = new QuantileInfo(0.25, "Quartile1", "First quartile");
    private static final ValueInfo Q2_INFO = new QuantileInfo(0.5, "Quartile2", "Second quartile");
    private static final ValueInfo Q3_INFO = new QuantileInfo(0.75, "Quartile3", "Third quartile");
    private static final ValueInfo ARRAY_NGOOD_INFO = new DefaultValueInfo("ArrayNGood", long[].class, "Per-element non-blank counts for fixed-length array columns");
    private static final ValueInfo ARRAY_SUM_INFO = new DefaultValueInfo("ArraySum", double[].class, "Per-element sums for fixed-length array columns");
    private static final ValueInfo ARRAY_MEAN_INFO = new DefaultValueInfo("ArrayMean", double[].class, "Per-element means for fixed-length array columns");
    private static final ValueInfo ARRAY_POPSD_INFO = new DefaultValueInfo("ArrayStDev", double[].class, "Per-element population standard deviation for fixed-length array columns");
    private static final ValueInfo[] KNOWN_INFOS = new ValueInfo[]{NGOOD_INFO, NBAD_INFO, MEAN_INFO, POPSD_INFO, POPVAR_INFO, SAMPSD_INFO, SAMPVAR_INFO, MAD_INFO, SMAD_INFO, SKEW_INFO, KURT_INFO, MIN_INFO, MAX_INFO, SUM_INFO, MINPOS_INFO, MAXPOS_INFO, CARDINALITY_INFO, MEDIAN_INFO, Q1_INFO, Q2_INFO, Q3_INFO, ARRAY_NGOOD_INFO, ARRAY_SUM_INFO, ARRAY_MEAN_INFO, ARRAY_POPSD_INFO};
    private static final ValueInfo[] QEX_INFOS = new ValueInfo[]{new DefaultValueInfo("Q.25", Number.class, "First quartile"), new DefaultValueInfo("Q.625", Number.class, "Fifth octile")};
    private static final ValueInfo[] ALL_KNOWN_INFOS;
    private static final ValueInfo[] DEFAULT_INFOS;

    public StatsFilter() {
        super("stats", "[-[no]parallel] [-qapprox|-qexact] [<item> ...]");
    }

    @Override
    protected String[] getDescriptionLines() {
        ArrayList<ValueInfo> extras = new ArrayList<ValueInfo>(Arrays.asList(KNOWN_INFOS));
        extras.removeAll(Arrays.asList(DEFAULT_INFOS));
        ValueInfo[] extraKnownInfos = extras.toArray(new ValueInfo[0]);
        return new String[]{"<p>Calculates statistics on the data in the table.", "This filter turns the table sideways, so that each row", "of the output corresponds to a column of the input.", "The columns of the output table contain statistical items", "such as mean, standard deviation etc corresponding to each", "column of the input table.", "</p><p>By default the output table contains columns for the", "following items:", DocUtils.listInfos(DEFAULT_INFOS), "</p>", "<p>However, the output may be customised by supplying one or more", "<code>&lt;item&gt;</code> headings.  These may be selected", "from the above as well as the following:", DocUtils.listInfos(extraKnownInfos), "Additionally, the form \"Q.<em>nn</em>\" may be used to", "represent the quantile corresponding to the proportion", "0.<em>nn</em>, e.g.:", DocUtils.listInfos(QEX_INFOS), "</p>", "<p>Any parameters of the input table are propagated", "to the output one.", "</p>", "<p>The <code>-qapprox</code> or <code>-qexact</code>", "flag controls how quantiles are calculated.", "With <code>-qexact</code> they are calculated exactly,", "but this requires memory usage scaling with the number of rows.", "If the <code>-qapprox</code> flag is supplied,", "an method is used which is typically slower and produces only", "approximate values, but which will work in fixed memory", "and so can be used for arbitrarily large tables.", "By default, exact calculation is used.", "These flags are ignored if neither quantiles nor the MAD", "are being calculated", "</p>", "<p>The <code>-noparallel</code> flag may be supplied to inhibit", "multi-threaded statistics accumulation.", "Calculation is done in parallel by default if multi-threaded", "hardware is available, and it's usually faster.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        boolean isParallel = true;
        boolean isQuantileApprox = false;
        HashMap<String, ValueInfo> infoMap = new HashMap<String, ValueInfo>();
        for (int i = 0; i < ALL_KNOWN_INFOS.length; ++i) {
            ValueInfo info = ALL_KNOWN_INFOS[i];
            infoMap.put(info.getName().toLowerCase(), info);
        }
        ArrayList<Object> infoList = new ArrayList<Object>();
        while (argIt.hasNext()) {
            StringBuffer msg;
            block10: {
                String name = argIt.next();
                argIt.remove();
                String lname = name.toLowerCase();
                double quantile = StatsFilter.parseQuantileSpecifier(name);
                if (lname.equals("-parallel")) {
                    isParallel = true;
                    continue;
                }
                if (lname.equals("-noparallel")) {
                    isParallel = false;
                    continue;
                }
                if (lname.equals("-qapprox")) {
                    isQuantileApprox = true;
                    continue;
                }
                if (lname.equals("-qexact")) {
                    isQuantileApprox = false;
                    continue;
                }
                if (infoMap.containsKey(lname)) {
                    infoList.add(infoMap.get(lname));
                    continue;
                }
                if (!Double.isNaN(quantile)) {
                    infoList.add((Object)new QuantileInfo(quantile));
                    continue;
                }
                ArrayList<Object> docInfoList = new ArrayList<Object>();
                docInfoList.addAll(Arrays.asList(ALL_KNOWN_INFOS));
                docInfoList.add(new DefaultValueInfo("Q.nn", Number.class, "Quantile for 0.nn"));
                ValueInfo[] docInfos = docInfoList.toArray(new ValueInfo[0]);
                msg = new StringBuffer().append("Unknown quantity ").append(name);
                try {
                    String opts = new Formatter().formatXML(DocUtils.listInfos(docInfos), 6);
                    msg.append(" must be one of: ").append(opts);
                }
                catch (SAXException e) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
            throw new ArgException(msg.toString());
        }
        final ValueInfo[] colInfos = infoList.isEmpty() ? DEFAULT_INFOS : infoList.toArray(new ValueInfo[0]);
        final RowRunner runner = isParallel ? RowRunner.DEFAULT : RowRunner.SEQUENTIAL;
        final boolean qApprox = isQuantileApprox;
        final Supplier<Quantiler> qSupplier = isQuantileApprox ? GKQuantiler::new : SortQuantiler::new;
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) throws IOException {
                MapGroup group;
                try {
                    group = StatsFilter.statsMapGroup(base, colInfos, runner, qSupplier);
                }
                catch (OutOfMemoryError e) {
                    if (!qApprox) {
                        throw new IOException("Out of memory: Try -qapprox?", e);
                    }
                    throw e;
                }
                group.setKnownKeys(Arrays.asList(colInfos));
                ValueInfoMapGroupTable table = new ValueInfoMapGroupTable((MapGroup<ValueInfo, Object>)group);
                table.setParameters(base.getParameters());
                return table;
            }
        };
    }

    public static double parseQuantileSpecifier(String txt) {
        if (txt.matches("^[qQ]\\.[0-9]+$")) {
            double quant = Double.parseDouble(txt.substring(1));
            assert (quant >= 0.0 && quant <= 1.0);
            return quant;
        }
        return Double.NaN;
    }

    private static MapGroup<ValueInfo, Object> statsMapGroup(StarTable table, ValueInfo[] infos, RowRunner runner, Supplier<Quantiler> qSupplier) throws IOException {
        ColumnInfo[] cinfos = Tables.getColumnInfos((StarTable)table);
        int ncol = cinfos.length;
        boolean doCard = Arrays.asList(infos).contains(CARDINALITY_INFO);
        boolean doMad = Arrays.asList(infos).contains(MAD_INFO) || Arrays.asList(infos).contains(SMAD_INFO);
        ArrayList<QuantileInfo> quantInfoList = new ArrayList<QuantileInfo>();
        for (int i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof QuantileInfo)) continue;
            quantInfoList.add((QuantileInfo)infos[i]);
        }
        boolean doQuant = !quantInfoList.isEmpty() || doMad;
        QuantileInfo[] quantInfos = doQuant ? quantInfoList.toArray(new QuantileInfo[0]) : null;
        TableStats tstats = TableStats.calculateStats(table, runner, doQuant ? qSupplier : null, doCard);
        UnivariateStats[] colStats = tstats.getColumnStats();
        MapGroup<ValueInfo, Object> group = MetadataFilter.metadataMapGroup(table);
        for (int icol = 0; icol < ncol; ++icol) {
            Quantiler quantiler;
            int ncard;
            double dcount;
            UnivariateStats stats = colStats[icol];
            long count = stats.getCount();
            double sum0 = dcount = (double)count;
            double sum1 = stats.getSum();
            double sum2 = stats.getSum2();
            double sum3 = stats.getSum3();
            double sum4 = stats.getSum4();
            double mean = sum1 / dcount;
            double nvar = sum2 - sum1 * sum1 / dcount;
            double popvar = nvar / dcount;
            double sampvar = nvar / (dcount - 1.0);
            double skew = Math.sqrt(dcount) / Math.pow(nvar, 1.5) * (1.0 * sum3 - 3.0 * mean * sum2 + 3.0 * mean * mean * sum1 - 1.0 * mean * mean * mean * sum0);
            double kurtosis = dcount / (nvar * nvar) * (1.0 * sum4 - 4.0 * mean * sum3 + 6.0 * mean * mean * sum2 - 4.0 * mean * mean * mean * sum1 + 1.0 * mean * mean * mean * mean * sum0) - 3.0;
            Comparable<?> min = stats.getMinimum();
            Comparable<?> max = stats.getMaximum();
            UnivariateStats.ArrayStats arrayStats = stats.getArrayStats();
            Map map = (Map)group.getMaps().get(icol);
            map.put(NGOOD_INFO, count);
            map.put(NBAD_INFO, tstats.getRowCount() - count);
            map.put(SUM_INFO, sum1);
            if (StatsFilter.isFinite(mean)) {
                map.put(MEAN_INFO, Float.valueOf((float)mean));
            }
            if (StatsFilter.isFinite(popvar)) {
                map.put(POPSD_INFO, Float.valueOf((float)Math.sqrt(popvar)));
                map.put(POPVAR_INFO, Float.valueOf((float)popvar));
            }
            if (StatsFilter.isFinite(sampvar)) {
                map.put(SAMPSD_INFO, Float.valueOf((float)Math.sqrt(sampvar)));
                map.put(SAMPVAR_INFO, Float.valueOf((float)sampvar));
            }
            if (StatsFilter.isFinite(skew)) {
                map.put(SKEW_INFO, Float.valueOf((float)skew));
            }
            if (StatsFilter.isFinite(kurtosis)) {
                map.put(KURT_INFO, Float.valueOf((float)kurtosis));
            }
            if (min != null) {
                map.put(MIN_INFO, min);
                map.put(MINPOS_INFO, stats.getMinPos() + 1L);
            }
            if (max != null) {
                map.put(MAX_INFO, max);
                map.put(MAXPOS_INFO, stats.getMaxPos() + 1L);
            }
            if (doCard && (ncard = stats.getCardinality()) > 0) {
                map.put(CARDINALITY_INFO, ncard);
            }
            if ((quantiler = stats.getQuantiler()) != null) {
                for (int iq = 0; iq < quantInfos.length; ++iq) {
                    QuantileInfo quantInfo = quantInfos[iq];
                    double quantile = quantiler.getValueAtQuantile(quantInfo.getQuant());
                    map.put(quantInfo, Float.valueOf((float)quantile));
                }
            }
            if (arrayStats == null) continue;
            long[] sum0s = arrayStats.getCounts();
            double[] sum1s = arrayStats.getSum1s();
            double[] sum2s = arrayStats.getSum2s();
            int leng = arrayStats.getLength();
            double[] means = new double[leng];
            double[] popsds = new double[leng];
            for (int i = 0; i < leng; ++i) {
                double acount = sum0s[i];
                double asum1 = sum1s[i];
                double asum2 = sum2s[i];
                double amean = asum1 / acount;
                double anvar = asum2 - asum1 * asum1 / acount;
                double apopvar = anvar / acount;
                means[i] = amean;
                popsds[i] = Math.sqrt(apopvar);
            }
            map.put(ARRAY_NGOOD_INFO, sum0s);
            map.put(ARRAY_SUM_INFO, sum1s);
            map.put(ARRAY_MEAN_INFO, means);
            map.put(ARRAY_POPSD_INFO, popsds);
        }
        if (doMad) {
            double[] medians = new double[ncol];
            int nmad = 0;
            for (int icol = 0; icol < ncol; ++icol) {
                Quantiler quantiler = colStats[icol].getQuantiler();
                medians[icol] = Double.NaN;
                if (quantiler == null) continue;
                medians[icol] = quantiler.getValueAtQuantile(0.5);
                ++nmad;
            }
            if (nmad > 0) {
                double[] mads = TableStats.calculateMads(table, runner, qSupplier, medians);
                for (int icol = 0; icol < ncol; ++icol) {
                    double mad = mads[icol];
                    if (Double.isNaN(mad)) continue;
                    double smad = mad * 1.4826;
                    Map map = (Map)group.getMaps().get(icol);
                    map.put(MAD_INFO, Float.valueOf((float)mad));
                    map.put(SMAD_INFO, Float.valueOf((float)smad));
                }
            }
        }
        return group;
    }

    private static final boolean isFinite(double val) {
        return val > -1.7976931348623157E308 && val < Double.MAX_VALUE;
    }

    static {
        ArrayList<ValueInfo> known = new ArrayList<ValueInfo>();
        known.addAll(Arrays.asList(MetadataFilter.KNOWN_INFOS));
        known.addAll(Arrays.asList(KNOWN_INFOS));
        ALL_KNOWN_INFOS = known.toArray(new ValueInfo[0]);
        DEFAULT_INFOS = new ValueInfo[]{MetadataFilter.NAME_INFO, MEAN_INFO, POPSD_INFO, MIN_INFO, MAX_INFO, NGOOD_INFO};
    }

    private static class QuantileInfo
    extends DefaultValueInfo {
        private final double quant_;

        QuantileInfo(double quant) {
            super("Q_" + quant, Number.class);
            if (quant < 0.0 || quant > 1.0) {
                throw new IllegalArgumentException(quant + " not in range 0-1");
            }
            this.quant_ = quant;
            String qv = Float.toString((float)quant);
            Matcher matcher = Pattern.compile("^0?.([0-9]+)$").matcher(qv);
            if (matcher.matches()) {
                qv = matcher.group(1);
                while (qv.length() < 2) {
                    qv = qv + '0';
                }
            }
            this.setName("Q_" + qv);
            if (qv.length() == 2) {
                this.setDescription("Percentile " + qv);
            } else {
                this.setDescription("Quantile corresponding to " + quant);
            }
        }

        QuantileInfo(double quant, String name, String description) {
            this(quant);
            this.setName(name);
            this.setDescription(description);
        }

        public double getQuant() {
            return this.quant_;
        }
    }
}

