/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.TailTable;

public class TailFilter
extends BasicFilter {
    public TailFilter() {
        super("tail", "<nrows>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Include only the last <code>&lt;nrows&gt;</code> rows", "of the table.", "If the table has fewer than <code>&lt;nrows&gt;</code> rows", "then it will be unchanged.", "</p>", "<p>The <code>&lt;nrows&gt;</code> argument", " may be given as a plain integer (<code>1000</code>),\nor with embedded underscores (<code>1_000</code>),\nor in exponential format (<code>1e3</code>).", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        if (argIt.hasNext()) {
            long count;
            String countStr = argIt.next();
            argIt.remove();
            try {
                count = Tables.parseCount((String)countStr);
            }
            catch (NumberFormatException e) {
                throw new ArgException("Row count " + countStr + " not numeric");
            }
            assert (count >= 0L);
            return new TailStep(count);
        }
        throw new ArgException("No row count given");
    }

    private static class TailStep
    implements ProcessingStep {
        final long count_;

        TailStep(long count) {
            this.count_ = count;
        }

        @Override
        public StarTable wrap(StarTable base) {
            return new TailTable(base, this.count_);
        }
    }
}

