/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.ArrayReader;
import uk.ac.starlink.ttools.filter.Quantiler;

public abstract class UnivariateStats {
    public static final int MAX_CARDINALITY = 100;

    public abstract void acceptDatum(Object var1, long var2);

    public abstract void addStats(UnivariateStats var1);

    public abstract long getCount();

    public abstract double getSum();

    public abstract double getSum2();

    public abstract double getSum3();

    public abstract double getSum4();

    public abstract Comparable<?> getMinimum();

    public abstract Comparable<?> getMaximum();

    public abstract long getMinPos();

    public abstract long getMaxPos();

    public abstract int getCardinality();

    public abstract Quantiler getQuantiler();

    public abstract ArrayStats getArrayStats();

    public static UnivariateStats createStats(Class<?> clazz, Supplier<Quantiler> qSupplier, boolean doCard) {
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumberStats(qSupplier, doCard);
        }
        if (clazz == Boolean.class) {
            return new BooleanStats();
        }
        if (ArrayReader.forClass(clazz) != null) {
            return new NumericArrayStats(ArrayReader.forClass(clazz));
        }
        boolean doCompare = Comparable.class.isAssignableFrom(clazz);
        return new ObjectStats(doCard, doCompare);
    }

    private static int compare(Comparable<?> c1, Comparable<?> c2) {
        int cmp = c1.compareTo(c2);
        return cmp;
    }

    private static class NumericArrayStats
    extends UnivariateStats {
        private final ArrayReader ardr_;
        private int aleng_;
        private long nGood_;
        private long[] sum0s_;
        private double[] sum1s_;
        private double[] sum2s_;

        public NumericArrayStats(ArrayReader ardr) {
            this.ardr_ = ardr;
        }

        @Override
        public void acceptDatum(Object array, long irow) {
            int leng = this.ardr_.getLength(array);
            if (leng > 0 && this.aleng_ >= 0) {
                if (this.aleng_ == 0) {
                    this.initLeng(leng);
                }
                if (leng == this.aleng_) {
                    boolean hasGood = false;
                    for (int i = 0; i < leng; ++i) {
                        double d = this.ardr_.getValue(array, i);
                        if (Double.isNaN(d)) continue;
                        double d2 = d * d;
                        hasGood = true;
                        int n = i;
                        this.sum0s_[n] = this.sum0s_[n] + 1L;
                        int n2 = i;
                        this.sum1s_[n2] = this.sum1s_[n2] + d;
                        int n3 = i;
                        this.sum2s_[n3] = this.sum2s_[n3] + d2;
                    }
                    if (hasGood) {
                        ++this.nGood_;
                    }
                } else {
                    this.initLeng(-1);
                }
            }
        }

        @Override
        public long getCount() {
            return this.nGood_;
        }

        @Override
        public double getSum() {
            return Double.NaN;
        }

        @Override
        public double getSum2() {
            return Double.NaN;
        }

        @Override
        public double getSum3() {
            return Double.NaN;
        }

        @Override
        public double getSum4() {
            return Double.NaN;
        }

        @Override
        public Comparable<?> getMinimum() {
            return null;
        }

        @Override
        public Comparable<?> getMaximum() {
            return null;
        }

        @Override
        public long getMinPos() {
            return -1L;
        }

        @Override
        public long getMaxPos() {
            return -1L;
        }

        @Override
        public int getCardinality() {
            return -1;
        }

        @Override
        public Quantiler getQuantiler() {
            return null;
        }

        @Override
        public ArrayStats getArrayStats() {
            return this.aleng_ > 0 ? new ArrayStats(){

                @Override
                public int getLength() {
                    return aleng_;
                }

                @Override
                public long[] getCounts() {
                    return sum0s_;
                }

                @Override
                public double[] getSum1s() {
                    return sum1s_;
                }

                @Override
                public double[] getSum2s() {
                    return sum2s_;
                }
            } : null;
        }

        @Override
        public void addStats(UnivariateStats o) {
            NumericArrayStats other = (NumericArrayStats)o;
            if (this.aleng_ < 0) {
                return;
            }
            if (other.aleng_ < 0) {
                this.initLeng(-1);
                return;
            }
            if (other.aleng_ == 0) {
                return;
            }
            assert (other.aleng_ > 0);
            if (this.aleng_ == 0) {
                this.initLeng(other.aleng_);
            }
            this.nGood_ += other.nGood_;
            for (int i = 0; i < this.aleng_; ++i) {
                int n = i;
                this.sum0s_[n] = this.sum0s_[n] + other.sum0s_[i];
                int n2 = i;
                this.sum1s_[n2] = this.sum1s_[n2] + other.sum1s_[i];
                int n3 = i;
                this.sum2s_[n3] = this.sum2s_[n3] + other.sum2s_[i];
            }
        }

        private void initLeng(int leng) {
            this.aleng_ = leng;
            if (leng > 0) {
                this.sum0s_ = new long[leng];
                this.sum1s_ = new double[leng];
                this.sum2s_ = new double[leng];
            } else if (leng < 0) {
                this.sum0s_ = null;
                this.sum1s_ = null;
                this.sum2s_ = null;
                this.nGood_ = 0L;
            } else assert (false);
        }
    }

    private static class NumberStats
    extends UnivariateStats {
        private long nGood_;
        private double sum1_;
        private double sum2_;
        private double sum3_;
        private double sum4_;
        private double dmin_ = Double.NaN;
        private double dmax_ = Double.NaN;
        private Number min_;
        private Number max_;
        private long minPos_ = -1L;
        private long maxPos_ = -1L;
        private final Quantiler quantiler_;
        private Set<Object> distincts_;
        private int ndistinct_;
        private final int maxCard_;

        public NumberStats(Supplier<Quantiler> qSupplier, boolean doCard) {
            this.quantiler_ = qSupplier == null ? null : qSupplier.get();
            this.distincts_ = doCard ? new HashSet() : null;
            this.maxCard_ = 100;
        }

        @Override
        public void acceptDatum(Object obj, long irow) {
            Number val;
            double dval;
            if (obj instanceof Number && !Double.isNaN(dval = (val = (Number)obj).doubleValue())) {
                ++this.nGood_;
                double s1 = dval;
                double s2 = dval * s1;
                double s3 = dval * s2;
                double s4 = dval * s3;
                this.sum1_ += s1;
                this.sum2_ += s2;
                this.sum3_ += s3;
                this.sum4_ += s4;
                if (!(dval >= this.dmin_)) {
                    this.dmin_ = dval;
                    this.min_ = val;
                    this.minPos_ = irow;
                }
                if (!(dval <= this.dmax_)) {
                    this.dmax_ = dval;
                    this.max_ = val;
                    this.maxPos_ = irow;
                }
                if (this.distincts_ != null) {
                    if (this.ndistinct_ < this.maxCard_) {
                        if (this.distincts_.add(val)) {
                            ++this.ndistinct_;
                        }
                    } else {
                        this.distincts_ = null;
                    }
                }
                if (this.quantiler_ != null) {
                    this.quantiler_.acceptDatum(dval);
                }
            }
        }

        @Override
        public void addStats(UnivariateStats o) {
            NumberStats other = (NumberStats)o;
            this.nGood_ += other.nGood_;
            this.sum1_ += other.sum1_;
            this.sum2_ += other.sum2_;
            this.sum3_ += other.sum3_;
            this.sum4_ += other.sum4_;
            if (!Double.isNaN(other.dmin_) && !(other.dmin_ >= this.dmin_)) {
                this.dmin_ = other.dmin_;
                this.min_ = other.min_;
                this.minPos_ = other.minPos_;
            }
            if (!Double.isNaN(other.dmax_) && !(other.dmax_ <= this.dmax_)) {
                this.dmax_ = other.dmax_;
                this.max_ = other.max_;
                this.maxPos_ = other.maxPos_;
            }
            if (this.distincts_ != null) {
                if (other.distincts_ != null) {
                    this.distincts_.addAll(other.distincts_);
                }
                this.ndistinct_ = this.distincts_.size();
                if (this.ndistinct_ > this.maxCard_) {
                    this.distincts_ = null;
                }
            }
            if (this.quantiler_ != null) {
                this.quantiler_.addQuantiler(other.quantiler_);
            }
        }

        @Override
        public long getCount() {
            return this.nGood_;
        }

        @Override
        public double getSum() {
            return this.sum1_;
        }

        @Override
        public double getSum2() {
            return this.sum2_;
        }

        @Override
        public double getSum3() {
            return this.sum3_;
        }

        @Override
        public double getSum4() {
            return this.sum4_;
        }

        @Override
        public Comparable<?> getMinimum() {
            return this.min_ instanceof Comparable ? (Comparable)((Object)this.min_) : null;
        }

        @Override
        public Comparable<?> getMaximum() {
            return this.max_ instanceof Comparable ? (Comparable)((Object)this.max_) : null;
        }

        @Override
        public long getMinPos() {
            return this.minPos_;
        }

        @Override
        public long getMaxPos() {
            return this.maxPos_;
        }

        @Override
        public int getCardinality() {
            return this.distincts_ == null ? -1 : this.distincts_.size();
        }

        @Override
        public Quantiler getQuantiler() {
            if (this.quantiler_ != null) {
                this.quantiler_.ready();
            }
            return this.quantiler_;
        }

        @Override
        public ArrayStats getArrayStats() {
            return null;
        }
    }

    private static class BooleanStats
    extends UnivariateStats {
        private long nGood_;
        private long nTrue_;

        private BooleanStats() {
        }

        @Override
        public void acceptDatum(Object obj, long irow) {
            if (obj instanceof Boolean) {
                ++this.nGood_;
                if (((Boolean)obj).booleanValue()) {
                    ++this.nTrue_;
                }
            }
        }

        @Override
        public void addStats(UnivariateStats o) {
            BooleanStats other = (BooleanStats)o;
            this.nGood_ += other.nGood_;
            this.nTrue_ += other.nTrue_;
        }

        @Override
        public long getCount() {
            return this.nGood_;
        }

        @Override
        public double getSum() {
            return this.nTrue_;
        }

        @Override
        public double getSum2() {
            return Double.NaN;
        }

        @Override
        public double getSum3() {
            return Double.NaN;
        }

        @Override
        public double getSum4() {
            return Double.NaN;
        }

        @Override
        public Comparable<?> getMinimum() {
            return null;
        }

        @Override
        public Comparable<?> getMaximum() {
            return null;
        }

        @Override
        public long getMinPos() {
            return -1L;
        }

        @Override
        public long getMaxPos() {
            return -1L;
        }

        @Override
        public int getCardinality() {
            int card = 0;
            if (this.nTrue_ > 0L) {
                ++card;
            }
            if (this.nGood_ > this.nTrue_) {
                ++card;
            }
            return card;
        }

        @Override
        public Quantiler getQuantiler() {
            return null;
        }

        @Override
        public ArrayStats getArrayStats() {
            return null;
        }
    }

    private static class ObjectStats
    extends UnivariateStats {
        private boolean doCompare_;
        private long nGood_;
        private Set<Object> distincts_;
        private int ndistinct_;
        private final int maxCard_;
        private Comparable<?> min_;
        private Comparable<?> max_;
        private long minPos_ = -1L;
        private long maxPos_ = -1L;

        ObjectStats(boolean doCard, boolean doCompare) {
            this.doCompare_ = doCompare;
            this.distincts_ = doCard ? new HashSet() : null;
            this.maxCard_ = 100;
        }

        @Override
        public void acceptDatum(Object obj, long irow) {
            if (!Tables.isBlank((Object)obj)) {
                ++this.nGood_;
                if (this.distincts_ != null) {
                    if (this.ndistinct_ < this.maxCard_) {
                        if (this.distincts_.add(obj)) {
                            ++this.ndistinct_;
                        }
                    } else {
                        this.distincts_ = null;
                    }
                }
                if (this.doCompare_ && obj instanceof Comparable) {
                    try {
                        Comparable cobj = (Comparable)obj;
                        if (this.min_ == null || UnivariateStats.compare(cobj, this.min_) < 0) {
                            this.min_ = cobj;
                            this.minPos_ = irow;
                        }
                        if (this.max_ == null || UnivariateStats.compare(cobj, this.max_) > 0) {
                            this.max_ = cobj;
                            this.maxPos_ = irow;
                        }
                    }
                    catch (ClassCastException e) {
                        this.doCompare_ = false;
                    }
                }
            }
        }

        @Override
        public void addStats(UnivariateStats o) {
            ObjectStats other = (ObjectStats)o;
            this.nGood_ += other.nGood_;
            boolean bl = this.doCompare_ = this.doCompare_ && other.doCompare_;
            if (this.doCompare_) {
                try {
                    if (other.min_ != null && (this.min_ == null || UnivariateStats.compare(other.min_, this.min_) < 0)) {
                        this.min_ = other.min_;
                        this.minPos_ = other.minPos_;
                    }
                    if (other.max_ != null && (this.max_ == null || UnivariateStats.compare(other.max_, this.max_) > 0)) {
                        this.max_ = other.max_;
                        this.maxPos_ = other.maxPos_;
                    }
                }
                catch (ClassCastException e) {
                    this.doCompare_ = false;
                }
            }
            if (this.distincts_ != null) {
                if (other.distincts_ != null) {
                    this.distincts_.addAll(other.distincts_);
                }
                this.ndistinct_ = this.distincts_.size();
                if (this.ndistinct_ > this.maxCard_) {
                    this.distincts_ = null;
                }
            }
        }

        @Override
        public long getCount() {
            return this.nGood_;
        }

        @Override
        public double getSum() {
            return Double.NaN;
        }

        @Override
        public double getSum2() {
            return Double.NaN;
        }

        @Override
        public double getSum3() {
            return Double.NaN;
        }

        @Override
        public double getSum4() {
            return Double.NaN;
        }

        @Override
        public Comparable<?> getMinimum() {
            return this.doCompare_ ? this.min_ : null;
        }

        @Override
        public Comparable<?> getMaximum() {
            return this.doCompare_ ? this.max_ : null;
        }

        @Override
        public long getMinPos() {
            return this.doCompare_ ? this.minPos_ : -1L;
        }

        @Override
        public long getMaxPos() {
            return this.doCompare_ ? this.maxPos_ : -1L;
        }

        @Override
        public int getCardinality() {
            return this.distincts_ == null ? -1 : this.distincts_.size();
        }

        @Override
        public Quantiler getQuantiler() {
            return null;
        }

        @Override
        public ArrayStats getArrayStats() {
            return null;
        }
    }

    public static interface ArrayStats {
        public int getLength();

        public long[] getCounts();

        public double[] getSum1s();

        public double[] getSum2s();
    }
}

