/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import gnu.jel.CompilationException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.build.HideDoc;
import uk.ac.starlink.ttools.filter.SortQuantiler;
import uk.ac.starlink.ttools.jel.JELArrayFunction;

public class Arrays {
    @HideDoc
    public static final String ARRAY_ELEMENT_VARNAME = "x";
    @HideDoc
    public static final String ARRAY_INDEX_VARNAME = "i";
    private static final DoubleBinaryOperator ADD = (a, b) -> a + b;
    private static final DoubleBinaryOperator SUBTRACT = (a, b) -> a - b;
    private static final DoubleBinaryOperator MULTIPLY = (a, b) -> a * b;
    private static final DoubleBinaryOperator DIVIDE = (a, b) -> a / b;
    private static final ThreadLocal<ArrayFuncMap> afuncsThreadLocal_ = ThreadLocal.withInitial(ArrayFuncMap::new);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.func");

    private Arrays() {
    }

    public static double sum(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
            }
            return sum;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double mean(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
                ++count;
            }
            return sum / (double)count;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double variance(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
                sum2 += d * d;
                ++count;
            }
            double mean = sum / (double)count;
            return sum2 / (double)count - mean * mean;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double stdev(Object array) {
        return Math.sqrt(Arrays.variance(array));
    }

    public static double minimum(Object array) {
        try {
            int n = Array.getLength(array);
            double min = Double.NaN;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d) || d > min) continue;
                min = d;
            }
            return min;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double maximum(Object array) {
        try {
            int n = Array.getLength(array);
            double max = Double.NaN;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d) || d < max) continue;
                max = d;
            }
            return max;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double median(Object array) {
        return Arrays.quantile(array, 0.5);
    }

    public static double quantile(Object array, double quant) {
        try {
            int n = Array.getLength(array);
            SortQuantiler qc = new SortQuantiler(n);
            for (int i = 0; i < n; ++i) {
                qc.acceptDatum(Array.getDouble(array, i));
            }
            qc.ready();
            return qc.getValueAtQuantile(quant);
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static int size(Object array) {
        return array != null && array.getClass().isArray() ? Array.getLength(array) : 0;
    }

    public static int count(Object array) {
        try {
            int n = Array.getLength(array);
            int count = 0;
            for (int i = 0; i < n; ++i) {
                if (Tables.isBlank((Object)Array.get(array, i))) continue;
                ++count;
            }
            return count;
        }
        catch (RuntimeException e) {
            return 0;
        }
    }

    public static int countTrue(boolean[] array) {
        int count = 0;
        for (boolean b : array) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    public static String join(Object array, String joiner) {
        StringBuilder sbuf = new StringBuilder();
        try {
            int n = Array.getLength(array);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sbuf.append(joiner);
                }
                sbuf.append(Array.get(array, i));
            }
            return sbuf.toString();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static double dotProduct(Object array1, Object array2) {
        int n1 = Arrays.getNumericArrayLength(array1);
        int n2 = Arrays.getNumericArrayLength(array2);
        if (n1 >= 0 && n1 == n2) {
            double d = 0.0;
            for (int i = 0; i < n1; ++i) {
                d += Array.getDouble(array1, i) * Array.getDouble(array2, i);
            }
            return d;
        }
        return Double.NaN;
    }

    public static double[] add(Object arrayOrScalar1, Object arrayOrScalar2) {
        return Arrays.arrayOp(arrayOrScalar1, arrayOrScalar2, ADD);
    }

    public static double[] subtract(Object arrayOrScalar1, Object arrayOrScalar2) {
        return Arrays.arrayOp(arrayOrScalar1, arrayOrScalar2, SUBTRACT);
    }

    public static double[] multiply(Object arrayOrScalar1, Object arrayOrScalar2) {
        return Arrays.arrayOp(arrayOrScalar1, arrayOrScalar2, MULTIPLY);
    }

    public static double[] divide(Object arrayOrScalar1, Object arrayOrScalar2) {
        return Arrays.arrayOp(arrayOrScalar1, arrayOrScalar2, DIVIDE);
    }

    public static double[] reciprocal(Object array) {
        int n = Arrays.getNumericArrayLength(array);
        if (n >= 0) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = 1.0 / Array.getDouble(array, i);
            }
            return out;
        }
        return null;
    }

    public static double[] condition(boolean[] flagArray, double trueValue, double falseValue) {
        int n = flagArray.length;
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = flagArray[i] ? trueValue : falseValue;
        }
        return out;
    }

    public static double[] constant(int n, double value) {
        double[] array = new double[n];
        java.util.Arrays.fill(array, value);
        return array;
    }

    @HideDoc
    public static float[] constant(int n, float value) {
        float[] array = new float[n];
        java.util.Arrays.fill(array, value);
        return array;
    }

    @HideDoc
    public static byte[] constant(int n, byte value) {
        byte[] array = new byte[n];
        java.util.Arrays.fill(array, value);
        return array;
    }

    @HideDoc
    public static short[] constant(int n, short value) {
        short[] array = new short[n];
        java.util.Arrays.fill(array, value);
        return array;
    }

    @HideDoc
    public static int[] constant(int n, int value) {
        int[] array = new int[n];
        java.util.Arrays.fill(array, value);
        return array;
    }

    @HideDoc
    public static long[] constant(int n, long value) {
        long[] array = new long[n];
        java.util.Arrays.fill(array, value);
        return array;
    }

    public static double[] slice(double[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            double[] out = new double[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static float[] slice(float[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            float[] out = new float[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static long[] slice(long[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            long[] out = new long[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static int[] slice(int[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            int[] out = new int[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static short[] slice(short[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            short[] out = new short[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static byte[] slice(byte[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            byte[] out = new byte[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static String[] slice(String[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            String[] out = new String[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    @HideDoc
    public static Object[] slice(Object[] array, int i0, int i1) {
        if (array != null) {
            int leng = array.length;
            int j0 = Arrays.effectiveIndex(i0, leng);
            int j1 = Arrays.effectiveIndex(i1, leng);
            int count = Math.max(0, j1 - j0);
            Object[] out = new Object[count];
            System.arraycopy(array, j0, out, 0, count);
            return out;
        }
        return null;
    }

    public static double[] pick(double[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static float[] pick(float[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            float[] out = new float[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static long[] pick(long[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            long[] out = new long[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static int[] pick(int[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            int[] out = new int[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static short[] pick(short[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            short[] out = new short[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static byte[] pick(byte[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            byte[] out = new byte[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static String[] pick(String[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            String[] out = new String[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    @HideDoc
    public static Object[] pick(Object[] array, int ... indices) {
        if (array != null) {
            int leng = array.length;
            int n = indices.length;
            Object[] out = new Object[n];
            for (int i = 0; i < n; ++i) {
                int ix = indices[i];
                int jx = ix >= 0 ? ix : leng + ix;
                out[i] = array[jx];
            }
            return out;
        }
        return null;
    }

    public static double[] arrayFunc(String expr, Object inArray) {
        return Arrays.arrayFunc(expr, inArray, double[].class);
    }

    public static int[] intArrayFunc(String expr, Object inArray) {
        return Arrays.arrayFunc(expr, inArray, int[].class);
    }

    @HideDoc
    public static Object untypedArrayFunc(String expr, Object inArray) {
        return Arrays.arrayFunc(expr, inArray, Object.class);
    }

    private static <I, O> O arrayFunc(String expr, I inArray, Class<O> outClazz) {
        if (inArray == null || expr == null) {
            return null;
        }
        Class<?> inClazz = inArray.getClass();
        JELArrayFunction<?, O> afunc = Arrays.getArrayFunction(ARRAY_INDEX_VARNAME, ARRAY_ELEMENT_VARNAME, expr, inClazz, outClazz);
        return afunc == null ? null : (O)afunc.evaluate(inArray);
    }

    private static <I, O> JELArrayFunction<I, O> getArrayFunction(String iname, String xname, String fexpr, Class<I> inClazz, Class<O> outClazz) {
        return afuncsThreadLocal_.get().getArrayFunction(iname, xname, fexpr, inClazz, outClazz);
    }

    public static int indexOf(Object[] array, Object item) {
        block4: {
            if (array == null) break block4;
            int n = array.length;
            if (item == null) {
                for (int i = 0; i < n; ++i) {
                    if (array[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!item.equals(array[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @HideDoc
    public static int indexOf(double[] array, double item) {
        block4: {
            if (array == null) break block4;
            int n = array.length;
            if (Double.isNaN(item)) {
                for (int i = 0; i < n; ++i) {
                    if (!Double.isNaN(array[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (array[i] != item) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @HideDoc
    public static int indexOf(float[] array, double item) {
        block4: {
            if (array == null) break block4;
            int n = array.length;
            if (Double.isNaN(item)) {
                for (int i = 0; i < n; ++i) {
                    if (!Float.isNaN(array[i])) continue;
                    return i;
                }
            } else {
                float fitem = (float)item;
                for (int i = 0; i < n; ++i) {
                    if (array[i] != fitem) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @HideDoc
    public static int indexOf(long[] array, long item) {
        if (array != null) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                if (array[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    @HideDoc
    public static int indexOf(int[] array, int item) {
        if (array != null) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                if (array[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    @HideDoc
    public static int indexOf(short[] array, int item) {
        short sitem = (short)item;
        if (array != null && sitem == item) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                if (array[i] != item) continue;
                return i;
            }
        }
        return -1;
    }

    public static int[] sequence(int n) {
        int[] seq = new int[n];
        for (int i = 0; i < n; ++i) {
            seq[i] = i;
        }
        return seq;
    }

    public static double[] sequence(int n, double start, double step) {
        double[] seq = new double[n];
        for (int i = 0; i < n; ++i) {
            seq[i] = start + (double)i * step;
        }
        return seq;
    }

    public static int[] loop(int start, int end) {
        int n = Math.max(end - start, 0);
        int[] array = new int[n];
        for (int i = 0; i < n; ++i) {
            array[i] = start + i;
        }
        return array;
    }

    public static double[] loop(double start, double end, double step) {
        double dn = step != 0.0 ? Math.ceil((end - start) / step) : 0.0;
        int n = dn > 0.0 ? (int)dn : 0;
        double[] array = new double[n];
        for (int i = 0; i < n; ++i) {
            array[i] = start + (double)i * step;
        }
        return array;
    }

    public static double[] array(double ... values) {
        return values;
    }

    public static int[] intArray(int ... values) {
        return values;
    }

    public static String[] stringArray(String ... values) {
        return values;
    }

    private static int getNumericArrayLength(Object array) {
        return array instanceof byte[] || array instanceof short[] || array instanceof int[] || array instanceof long[] || array instanceof float[] || array instanceof double[] ? Array.getLength(array) : -1;
    }

    private static int effectiveIndex(int index, int leng) {
        return index >= 0 ? Math.min(leng, index) : Math.max(0, leng + index);
    }

    private static double[] arrayOp(Object aos1, Object aos2, DoubleBinaryOperator operator) {
        ElementHandler eh1 = Arrays.createElementHandler(aos1);
        if (eh1 == null) {
            return null;
        }
        ElementHandler eh2 = Arrays.createElementHandler(aos2);
        if (eh2 == null) {
            return null;
        }
        int leng1 = eh1.length_;
        int leng2 = eh2.length_;
        int leng = leng1 == leng2 ? leng1 : (leng1 < 0 ? leng2 : (leng2 < 0 ? leng1 : -1));
        if (leng >= 0) {
            double[] result = new double[leng];
            for (int i = 0; i < leng; ++i) {
                result[i] = operator.applyAsDouble(eh1.getElement(i), eh2.getElement(i));
            }
            return result;
        }
        return null;
    }

    private static ElementHandler createElementHandler(Object aos) {
        if (aos instanceof Number) {
            double scalar = ((Number)aos).doubleValue();
            return new ElementHandler(i -> scalar, -1);
        }
        if (aos instanceof double[]) {
            double[] array = (double[])aos;
            return new ElementHandler(i -> array[i], array.length);
        }
        if (aos instanceof float[]) {
            float[] array = (float[])aos;
            return new ElementHandler(i -> array[i], array.length);
        }
        if (aos instanceof int[]) {
            int[] array = (int[])aos;
            return new ElementHandler(i -> array[i], array.length);
        }
        if (aos instanceof short[]) {
            short[] array = (short[])aos;
            return new ElementHandler(i -> array[i], array.length);
        }
        if (aos instanceof long[]) {
            long[] array = (long[])aos;
            return new ElementHandler(i -> array[i], array.length);
        }
        if (aos instanceof byte[]) {
            byte[] array = (byte[])aos;
            return new ElementHandler(i -> array[i], array.length);
        }
        return null;
    }

    private static class ArrayFuncMap {
        private final Map<Key<?, ?>, JELArrayFunction<?, ?>> map_ = new HashMap();

        ArrayFuncMap() {
        }

        <I, O> JELArrayFunction<I, O> getArrayFunction(String iname, String xname, String fexpr, Class<I> inClazz, Class<O> outClazz) {
            JELArrayFunction<Object, Object> afunc;
            Key<I, O> key = new Key<I, O>(iname, xname, fexpr, inClazz, outClazz);
            if (this.map_.containsKey(key)) {
                JELArrayFunction<?, ?> afunc0;
                afunc = afunc0 = this.map_.get(key);
            } else {
                try {
                    afunc = new JELArrayFunction<I, O>(iname, xname, fexpr, inClazz, outClazz);
                }
                catch (CompilationException e) {
                    logger_.log(Level.WARNING, "Bad expresssion \"" + fexpr + "\": " + e, e);
                    afunc = null;
                }
                this.map_.put(key, afunc);
            }
            return afunc;
        }

        private static class Key<I, O> {
            final String iname_;
            final String xname_;
            final String fexpr_;
            final Class<I> inClazz_;
            final Class<O> outClazz_;

            Key(String iname, String xname, String fexpr, Class<I> inClazz, Class<O> outClazz) {
                this.iname_ = iname;
                this.xname_ = xname;
                this.fexpr_ = fexpr;
                this.inClazz_ = inClazz;
                this.outClazz_ = outClazz;
            }

            public int hashCode() {
                int code = -9971;
                code = 23 * code + this.iname_.hashCode();
                code = 23 * code + this.xname_.hashCode();
                code = 23 * code + this.fexpr_.hashCode();
                code = 23 * code + this.inClazz_.hashCode();
                code = 23 * code + this.outClazz_.hashCode();
                return code;
            }

            public boolean equals(Object o) {
                if (o instanceof Key) {
                    Key other = (Key)o;
                    return this.fexpr_.equals(other.fexpr_) && this.iname_.equals(other.iname_) && this.xname_.equals(other.xname_) && this.inClazz_.equals(other.inClazz_) && this.outClazz_.equals(other.outClazz_);
                }
                return false;
            }
        }
    }

    private static class ElementHandler {
        final int length_;
        final IntToDoubleFunction accessor_;

        ElementHandler(IntToDoubleFunction accessor, int length) {
            this.accessor_ = accessor;
            this.length_ = length;
        }

        double getElement(int i) {
            return this.accessor_.applyAsDouble(i);
        }
    }
}

