/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.ttools.func.Integrator;
import uk.ac.starlink.ttools.func.Maths;

public class Distances {
    public static final double SPEED_OF_LIGHT = 2.99792458E8;
    public static final double METRE_PER_PARSEC = 3.08567758E16;
    public static final double SEC_PER_YEAR = 3.15576E7;
    private static final Map<List<Double>, Integrator> distIntegratorMap_ = new HashMap<List<Double>, Integrator>();
    private static final Map<List<Double>, Integrator> timeIntegratorMap_ = new HashMap<List<Double>, Integrator>();
    private static final double EXAMPLE_H0 = 71.0;
    private static final double EXAMPLE_OMEGA_M = 0.27;
    private static final double EXAMPLE_OMEGA_LAMBDA = 0.73;

    private Distances() {
    }

    public static double MpcToM(double distMpc) {
        return distMpc * 1000000.0 * 3.08567758E16;
    }

    public static double mToMpc(double distM) {
        return distM / 3.08567758E16 / 1000000.0;
    }

    public static double zToDist(double z) {
        return Distances.luminosityDistance(z, 71.0, 0.27, 0.73);
    }

    public static double zToAge(double z) {
        return Distances.lookbackTime(z, 71.0, 0.27, 0.73);
    }

    public static double comovingDistanceL(double z, double H0, double omegaM, double omegaLambda) {
        return Distances.dH(H0) * Distances.getDistIntegrator(omegaM, omegaLambda).integral(z);
    }

    public static double comovingDistanceT(double z, double H0, double omegaM, double omegaLambda) {
        double omegaK = Distances.omegaK(omegaM, omegaLambda);
        double dC = Distances.comovingDistanceL(z, H0, omegaM, omegaLambda);
        if (omegaK == 0.0) {
            return dC;
        }
        if (omegaK < 0.0) {
            double dH = Distances.dH(H0);
            double oks = Math.sqrt(-omegaK);
            return dH / oks * Math.sin(oks * dC / dH);
        }
        if (omegaK > 0.0) {
            double dH = Distances.dH(H0);
            double oks = Math.sqrt(omegaK);
            return dH / oks * Maths.sinh(oks * dC / dH);
        }
        assert (Double.isNaN(omegaK));
        return Double.NaN;
    }

    public static double angularDiameterDistance(double z, double H0, double omegaM, double omegaLambda) {
        return Distances.comovingDistanceT(z, H0, omegaM, omegaLambda) / (1.0 + z);
    }

    public static double luminosityDistance(double z, double H0, double omegaM, double omegaLambda) {
        return Distances.comovingDistanceT(z, H0, omegaM, omegaLambda) * (1.0 + z);
    }

    public static double lookbackTime(double z, double H0, double omegaM, double omegaLambda) {
        return Distances.tH(H0) * Distances.getTimeIntegrator(omegaM, omegaLambda).integral(z);
    }

    public static double comovingVolume(double z, double H0, double omegaM, double omegaLambda) {
        double dH = Distances.dH(H0) * 0.001;
        double dM = Distances.comovingDistanceT(z, H0, omegaM, omegaLambda) * 0.001;
        double omegaK = Distances.omegaK(omegaM, omegaLambda);
        if (omegaK == 0.0) {
            return 4.1887902047863905 * dM * dM * dM;
        }
        if (omegaK < 0.0) {
            double oks = Math.sqrt(-omegaK);
            double dMH = dM / dH;
            double t1 = dMH * Math.sqrt(1.0 + omegaK * dMH * dMH);
            double t2 = Math.asin(oks * dMH) / oks;
            return Math.PI * 2 * dH * dH * dH / omegaK * (t1 - t2);
        }
        if (omegaK > 0.0) {
            double oks = Math.sqrt(omegaK);
            double dMH = dM / dH;
            double t1 = dMH * Math.sqrt(1.0 + omegaK * dMH * dMH);
            double t2 = Maths.asinh(oks * dMH) / oks;
            return Math.PI * 2 * dH * dH * dH / omegaK * (t1 - t2);
        }
        assert (Double.isNaN(omegaK));
        return Double.NaN;
    }

    private static double dH(double H0) {
        return 299792.458 / H0;
    }

    private static double tH(double H0) {
        double h0PerSec = H0 * 1000.0 / 3.08567758E16 / 1000000.0;
        double thSec = 1.0 / h0PerSec;
        double thGyr = thSec / 3.15576E7 / 1.0E9;
        return thGyr;
    }

    private static double omegaK(double omegaM, double omegaLambda) {
        return 1.0 - omegaM - omegaLambda;
    }

    private static double E(double z, double omegaM, double omegaLambda) {
        double omegaK = Distances.omegaK(omegaM, omegaLambda);
        double zz = 1.0 + z;
        double zz2 = zz * zz;
        double zz3 = zz2 * zz;
        return Math.sqrt(omegaM * zz3 + omegaK * zz2 + omegaLambda);
    }

    private static Integrator getDistIntegrator(final double omegaM, final double omegaLambda) {
        List<Double> key = Distances.createKey(omegaM, omegaLambda);
        if (!distIntegratorMap_.containsKey(key)) {
            distIntegratorMap_.put(key, new Integrator(0.0, 0.02){

                @Override
                public double function(double z) {
                    return 1.0 / Distances.E(z, omegaM, omegaLambda);
                }
            });
        }
        return distIntegratorMap_.get(key);
    }

    private static Integrator getTimeIntegrator(final double omegaM, final double omegaLambda) {
        List<Double> key = Distances.createKey(omegaM, omegaLambda);
        if (!timeIntegratorMap_.containsKey(key)) {
            timeIntegratorMap_.put(key, new Integrator(0.0, 0.02){

                @Override
                public double function(double z) {
                    return 1.0 / (1.0 + z) / Distances.E(z, omegaM, omegaLambda);
                }
            });
        }
        return timeIntegratorMap_.get(key);
    }

    private static List<Double> createKey(double omegaM, double omegaLambda) {
        return Arrays.asList(omegaM, omegaLambda);
    }
}

