/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import uk.ac.starlink.dpac.epoch.EpochTransformation;
import uk.ac.starlink.dpac.math.Edsd;
import uk.ac.starlink.dpac.math.FuncUtils;
import uk.ac.starlink.dpac.math.Function;
import uk.ac.starlink.dpac.math.NumericFunction;
import uk.ac.starlink.ttools.func.AstrometryParams;
import uk.ac.starlink.ttools.func.Maths;
import uk.ac.starlink.ttools.func.TrigDegrees;
import uk.ac.starlink.ttools.plot.Matrices;

public class Gaia {
    public static final double AU_YRKMS = 4.740470446;
    public static final double PC_AU = 206264.80624709633;
    public static final double PC_YRKMS = 977792.2180642763;
    public static final double C_KMS = 299792.458;
    private static final double RVNORM = 4.740470446;
    private static final double RVNORM1 = 0.2109495273499275;
    private static final double C1_KMS = 3.3356409519815205E-6;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double MAS2RAD = 4.84813681109536E-9;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double RAD2MAS = 2.0626480624709633E8;
    private static final double[] AG_PRIME = new double[]{-0.0548755604162154, -0.873437090234885, -0.4838350155487132, 0.4941094278755837, -0.4448296299600112, 0.746982244497219, -0.8676661490190047, -0.1980763734312015, 0.4559837761750669};
    private static final double[] AG = Matrices.transpose(AG_PRIME);
    private static final double[] AK = new double[]{0.9999999999999639, 2.465125329E-7, -1.068762105E-7, -2.686837421E-7, 0.9174821334228226, -0.3977769913529863, 0.0, 0.3977769913530006, 0.9174821334228557};
    private static final double[] AK_PRIME = Matrices.transpose(AK);

    private Gaia() {
    }

    public static double[] polarXYZ(double phi, double theta, double r) {
        double cosPhi = TrigDegrees.cosDeg(phi);
        double sinPhi = TrigDegrees.sinDeg(phi);
        double cosTheta = TrigDegrees.cosDeg(theta);
        double sinTheta = TrigDegrees.sinDeg(theta);
        return new double[]{r * cosTheta * cosPhi, r * cosTheta * sinPhi, r * sinTheta};
    }

    public static double[] astromXYZ(double ra, double dec, double parallax) {
        double r = 1000.0 / parallax;
        return Gaia.polarXYZ(ra, dec, r);
    }

    public static double[] icrsToGal(double[] xyz) {
        return Matrices.mvMult(AG_PRIME, xyz);
    }

    public static double[] galToIcrs(double[] xyz) {
        return Matrices.mvMult(AG, xyz);
    }

    public static double[] icrsToEcl(double[] xyz) {
        return Matrices.mvMult(AK_PRIME, xyz);
    }

    public static double[] eclToIcrs(double[] xyz) {
        return Matrices.mvMult(AK, xyz);
    }

    public static double[] astromUVW(double[] astrom6) {
        double ra = astrom6[0];
        double dec = astrom6[1];
        double parallax = astrom6[2];
        double pmra = astrom6[3];
        double pmdec = astrom6[4];
        double radial_velocity = astrom6[5];
        double r_parsec = 1000.0 / parallax;
        return Gaia.astromUVW(ra, dec, pmra, pmdec, radial_velocity, r_parsec, false);
    }

    public static double[] astromUVW(double ra, double dec, double pmra, double pmdec, double radial_velocity, double r_parsec, boolean useDoppler) {
        double cosRa = TrigDegrees.cosDeg(ra);
        double sinRa = TrigDegrees.sinDeg(ra);
        double cosDec = TrigDegrees.cosDeg(dec);
        double sinDec = TrigDegrees.sinDeg(dec);
        double px = -sinRa;
        double qx = -sinDec * cosRa;
        double rx = cosDec * cosRa;
        double py = cosRa;
        double qy = -sinDec * sinRa;
        double ry = cosDec * sinRa;
        double pz = 0.0;
        double qz = cosDec;
        double rz = sinDec;
        double v1 = pmra * 4.740470446 * 0.001 * r_parsec;
        double v2 = pmdec * 4.740470446 * 0.001 * r_parsec;
        double v3 = radial_velocity;
        if (useDoppler) {
            double kDoppler = 1.0 / (1.0 - 3.3356409519815205E-6 * radial_velocity);
            v1 *= kDoppler;
            v2 *= kDoppler;
            v3 *= kDoppler;
        }
        return new double[]{px * v1 + qx * v2 + rx * v3, py * v1 + qy * v2 + ry * v3, pz * v1 + qz * v2 + rz * v3};
    }

    public static double[] epochProp(double tYr, double[] astrom6) {
        if (astrom6 == null || astrom6.length < 5) {
            return null;
        }
        if (Double.isNaN(astrom6[0]) || Double.isNaN(astrom6[1]) || Double.isNaN(astrom6[3]) || Double.isNaN(astrom6[4])) {
            return new double[]{astrom6[0], astrom6[1], astrom6[2], astrom6[3], astrom6[4], astrom6.length > 5 ? astrom6[5] : Double.NaN};
        }
        boolean hasPlx = !Double.isNaN(astrom6[2]);
        boolean hasRv = astrom6.length > 5 && !Double.isNaN(astrom6[5]);
        double[] out6 = Gaia.epochProp((double)tYr, (AstrometryParams)new AstrometryParams((double[])astrom6)).params;
        if (!hasPlx) {
            out6[2] = Double.NaN;
            out6[5] = astrom6[5];
        }
        if (!hasRv) {
            out6[5] = Double.NaN;
        }
        return out6;
    }

    public static double[] epochPropErr(double tYr, double[] astrom22) {
        double errRvkms1;
        double rvkms1;
        boolean hasRv1;
        if (astrom22 == null || astrom22.length != 22) {
            return null;
        }
        if (Double.isNaN(astrom22[0]) || Double.isNaN(astrom22[1]) || Double.isNaN(astrom22[3]) || Double.isNaN(astrom22[4])) {
            return (double[])astrom22.clone();
        }
        boolean hasPlx = !Double.isNaN(astrom22[2]);
        boolean hasRv = !Double.isNaN(astrom22[5]);
        double ra0 = astrom22[0] * (Math.PI / 180);
        double dec0 = astrom22[1] * (Math.PI / 180);
        double plx0 = hasPlx ? astrom22[2] * 4.84813681109536E-9 : 0.0;
        double pmra0 = astrom22[3] * 4.84813681109536E-9;
        double pmdec0 = astrom22[4] * 4.84813681109536E-9;
        double rvkms0 = hasRv ? astrom22[5] : 0.0;
        double errRa0 = astrom22[6] * 4.84813681109536E-9;
        double errDec0 = astrom22[7] * 4.84813681109536E-9;
        double errPlx0 = astrom22[8] * 4.84813681109536E-9;
        double errPmra0 = astrom22[9] * 4.84813681109536E-9;
        double errPmdec0 = astrom22[10] * 4.84813681109536E-9;
        double errRvkms0 = hasRv ? astrom22[11] : 0.0;
        double corrRaDec0 = astrom22[12];
        double corrRaPlx0 = astrom22[13];
        double corrRaPmra0 = astrom22[14];
        double corrRaPmdec0 = astrom22[15];
        double corrDecPlx0 = astrom22[16];
        double corrDecPmra0 = astrom22[17];
        double corrDecPmdec0 = astrom22[18];
        double corrPlxPmra0 = astrom22[19];
        double corrPlxPmdec0 = astrom22[20];
        double corrPmraPmdec0 = astrom22[21];
        double zeta0 = rvkms0 * plx0 * 0.2109495273499275;
        double[] a0 = new double[]{ra0, dec0, plx0, pmra0, pmdec0, zeta0};
        double[][] cov0 = new double[6][6];
        cov0[0][0] = errRa0 * errRa0;
        cov0[1][1] = errDec0 * errDec0;
        cov0[2][2] = errPlx0 * errPlx0;
        cov0[3][3] = errPmra0 * errPmra0;
        cov0[4][4] = errPmdec0 * errPmdec0;
        double d = errRa0 * errDec0 * corrRaDec0;
        cov0[1][0] = d;
        cov0[0][1] = d;
        double d2 = errRa0 * errPlx0 * corrRaPlx0;
        cov0[2][0] = d2;
        cov0[0][2] = d2;
        double d3 = errRa0 * errPmra0 * corrRaPmra0;
        cov0[3][0] = d3;
        cov0[0][3] = d3;
        double d4 = errRa0 * errPmdec0 * corrRaPmdec0;
        cov0[4][0] = d4;
        cov0[0][4] = d4;
        double d5 = errDec0 * errPlx0 * corrDecPlx0;
        cov0[2][1] = d5;
        cov0[1][2] = d5;
        double d6 = errDec0 * errPmra0 * corrDecPmra0;
        cov0[3][1] = d6;
        cov0[1][3] = d6;
        double d7 = errDec0 * errPmdec0 * corrDecPmdec0;
        cov0[4][1] = d7;
        cov0[1][4] = d7;
        double d8 = errPlx0 * errPmra0 * corrPlxPmra0;
        cov0[3][2] = d8;
        cov0[2][3] = d8;
        double d9 = errPlx0 * errPmdec0 * corrPlxPmdec0;
        cov0[4][2] = d9;
        cov0[2][4] = d9;
        double d10 = errPmra0 * errPmdec0 * corrPmraPmdec0;
        cov0[4][3] = d10;
        cov0[3][4] = d10;
        if (hasRv) {
            double rva = rvkms0 * 0.2109495273499275;
            for (int i = 0; i < 5; ++i) {
                double d11 = rva * cov0[i][2];
                cov0[5][i] = d11;
                cov0[i][5] = d11;
            }
            cov0[5][5] = 0.04449970308915781 * (Maths.square(plx0 * errRvkms0) + Maths.square(rvkms0 * errPlx0) + Maths.square(errRvkms0 * errPlx0));
        }
        double[] a1 = new double[6];
        double[][] cov1 = new double[6][6];
        EpochTransformation.propagate((double)tYr, (double[])a0, (double[][])cov0, (double[])a1, (double[][])cov1);
        double ra1 = a1[0];
        double dec1 = a1[1];
        double plx1 = a1[2];
        double pmra1 = a1[3];
        double pmdec1 = a1[4];
        double zeta1 = a1[5];
        double errRa1 = Math.sqrt(cov1[0][0]);
        double errDec1 = Math.sqrt(cov1[1][1]);
        double errPlx1 = Math.sqrt(cov1[2][2]);
        double errPmra1 = Math.sqrt(cov1[3][3]);
        double errPmdec1 = Math.sqrt(cov1[4][4]);
        double errZeta1 = Math.sqrt(cov1[5][5]);
        double corrRaDec1 = cov1[0][1] / (errRa1 * errDec1);
        double corrRaPlx1 = cov1[0][2] / (errRa1 * errPlx1);
        double corrRaPmra1 = cov1[0][3] / (errRa1 * errPmra1);
        double corrRaPmdec1 = cov1[0][4] / (errRa1 * errPmdec1);
        double corrDecPlx1 = cov1[1][2] / (errDec1 * errPlx1);
        double corrDecPmra1 = cov1[1][3] / (errDec1 * errPmra1);
        double corrDecPmdec1 = cov1[1][4] / (errDec1 * errPmdec1);
        double corrPlxPmra1 = cov1[2][3] / (errPlx1 * errPmra1);
        double corrPlxPmdec1 = cov1[2][4] / (errPlx1 * errPmdec1);
        double corrPmraPmdec1 = cov1[3][4] / (errPmra1 * errPmdec1);
        boolean bl = hasRv1 = hasRv && hasPlx && plx1 != 0.0;
        if (hasRv1) {
            rvkms1 = 4.740470446 * zeta1 / plx1;
            errRvkms1 = Math.sqrt((22.47206004939944 * cov1[5][5] - rvkms1 * rvkms1 * cov1[2][2]) / (plx1 * plx1 + cov1[2][2]));
        } else {
            rvkms1 = Double.NaN;
            errRvkms1 = Double.NaN;
        }
        double[] out22 = new double[]{ra1 * 57.29577951308232, dec1 * 57.29577951308232, hasPlx ? plx1 * 2.0626480624709633E8 : Double.NaN, pmra1 * 2.0626480624709633E8, pmdec1 * 2.0626480624709633E8, hasRv1 ? rvkms1 : astrom22[5], errRa1 * 2.0626480624709633E8, errDec1 * 2.0626480624709633E8, errPlx1 * 2.0626480624709633E8, errPmra1 * 2.0626480624709633E8, errPmdec1 * 2.0626480624709633E8, hasRv1 ? errRvkms1 : astrom22[11], corrRaDec1, hasPlx ? corrRaPlx1 : astrom22[13], corrRaPmra1, corrRaPmdec1, hasPlx ? corrDecPlx1 : astrom22[16], corrDecPmra1, corrDecPmdec1, hasPlx ? corrPlxPmra1 : astrom22[19], hasPlx ? corrPlxPmdec1 : astrom22[20], corrPmraPmdec1};
        return out22;
    }

    public static double rvMasyrToKms(double rvMasyr, double plxMas) {
        return plxMas == 0.0 ? Double.NaN : rvMasyr * 4.740470446 / plxMas;
    }

    public static double rvKmsToMasyr(double rvKms, double plxMas) {
        return rvKms * plxMas * 0.2109495273499275;
    }

    private static AstrometryParams epochProp(double tYr, AstrometryParams ap) {
        double[] a0 = Gaia.fromDm(ap);
        double[] a1 = new double[6];
        EpochTransformation.propagate((double)tYr, (double[])a0, (double[])a1);
        return Gaia.toDm(a1);
    }

    public static double distanceEstimateEdsd(double plxMas, double plxErrorMas, double lPc) {
        return 1000.0 * new Edsd(plxMas, plxErrorMas, lPc * 0.001).getBestEstimation();
    }

    public static double[] distanceBoundsEdsd(double plxMas, double plxErrorMas, double lPc) {
        return Gaia.distanceQuantilesEdsd(plxMas, plxErrorMas, lPc, 0.05, 0.95);
    }

    public static double[] distanceQuantilesEdsd(double plxMas, double plxErrorMas, double lPc, double ... qpoints) {
        int nq = qpoints.length;
        Edsd edsd = new Edsd(plxMas, plxErrorMas, lPc * 0.001);
        double tol = 1.0E-6;
        NumericFunction ncdf = edsd.calculateCdf(tol);
        Function scdf = FuncUtils.interpolateQuadratic((NumericFunction)ncdf);
        double[] qvs = new double[nq];
        double rmin = 0.0;
        double rmax = ncdf.getX(ncdf.getCount() - 1);
        double ytol = 1.0E-5;
        for (int i = 0; i < nq; ++i) {
            qvs[i] = 1000.0 * FuncUtils.findValueMonotonic((Function)scdf, (double)rmin, (double)rmax, (double)qpoints[i], (double)ytol);
        }
        return qvs;
    }

    public static double distanceToModulus(double distPc) {
        return 5.0 * Math.log10(distPc) - 5.0;
    }

    public static double modulusToDistance(double distmod) {
        return Math.pow(10.0, 1.0 + 0.2 * distmod);
    }

    private static double[] fromDm(AstrometryParams ap) {
        double raDeg = ap.ra;
        double decDeg = ap.dec;
        double plxMas = ap.plx;
        double pmraMasyr = ap.pmra;
        double pmdecMasyr = ap.pmdec;
        double rvKms = ap.rv;
        double raRad = raDeg * (Math.PI / 180);
        double decRad = decDeg * (Math.PI / 180);
        double plxRad = plxMas * 4.84813681109536E-9;
        double pmraRadyr = pmraMasyr * 4.84813681109536E-9;
        double pmdecRadyr = pmdecMasyr * 4.84813681109536E-9;
        double normRvRadyr = rvKms * plxRad * 0.2109495273499275;
        return new double[]{raRad, decRad, plxRad, pmraRadyr, pmdecRadyr, normRvRadyr};
    }

    private static AstrometryParams toDm(double[] a) {
        double raRad = a[0];
        double decRad = a[1];
        double plxRad = a[2];
        double pmraRadyr = a[3];
        double pmdecRadyr = a[4];
        double normRvRadyr = a[5];
        double raDeg = raRad * 57.29577951308232;
        double decDeg = decRad * 57.29577951308232;
        double plxMas = plxRad * 2.0626480624709633E8;
        double pmraMasyr = pmraRadyr * 2.0626480624709633E8;
        double pmdecMasyr = pmdecRadyr * 2.0626480624709633E8;
        double rvKms = plxRad == 0.0 ? Double.NaN : normRvRadyr / (plxRad * 0.2109495273499275);
        return new AstrometryParams(raDeg, decDeg, plxMas, pmraMasyr, pmdecMasyr, rvKms);
    }
}

