/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

abstract class Integrator {
    private final double base_;
    private final double step_;
    private double[] plusIntegrals_;
    private double[] minusIntegrals_;
    private static final double OVER_CALC = 0.2;

    public Integrator(double base, double step) {
        this.base_ = base;
        this.step_ = step;
        this.plusIntegrals_ = new double[]{0.0};
        this.minusIntegrals_ = new double[]{0.0};
    }

    public abstract double function(double var1);

    public double integral(double x) {
        if (x == this.base_) {
            return 0.0;
        }
        if (x > this.base_) {
            double point = (x - this.base_) / this.step_;
            int p0 = (int)point;
            int p1 = p0 + 1;
            double[] plusInts = this.getPlusIntegrals(p1);
            double v0 = plusInts[p0];
            double v1 = plusInts[p1];
            return v0 + (point - (double)p0) * (v1 - v0);
        }
        if (x < this.base_) {
            double point = (this.base_ - x) / this.step_;
            int p0 = (int)point;
            int p1 = p0 + 1;
            double[] minusInts = this.getMinusIntegrals(p1);
            double v0 = minusInts[p0];
            double v1 = minusInts[p1];
            return v0 - (point - (double)p0) * (v0 - v1);
        }
        assert (Double.isNaN(x));
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getPlusIntegrals(int ip) {
        double[] ints0 = this.plusIntegrals_;
        int n0 = ints0.length;
        if (ip < n0) {
            return ints0;
        }
        int n1 = (int)((double)ip * 1.2) + 1;
        double[] ints1 = new double[n1];
        System.arraycopy(ints0, 0, ints1, 0, n0);
        for (int i = n0; i < n1; ++i) {
            ints1[i] = ints1[i - 1] + this.step_ * this.function(this.base_ + ((double)i - 0.5) * this.step_);
        }
        Integrator integrator = this;
        synchronized (integrator) {
            this.plusIntegrals_ = ints1;
        }
        return ints1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getMinusIntegrals(int ip) {
        double[] ints0 = this.minusIntegrals_;
        int n0 = ints0.length;
        if (ip < n0) {
            return ints0;
        }
        int n1 = (int)((double)ip * 1.2) + 1;
        double[] ints1 = new double[n1];
        System.arraycopy(ints0, 0, ints1, 0, n0);
        for (int i = n0; i < n1; ++i) {
            ints1[i] = ints1[i - 1] - this.step_ * this.function(this.base_ - ((double)i - 0.5) * this.step_);
        }
        Integrator integrator = this;
        synchronized (integrator) {
            this.minusIntegrals_ = ints1;
        }
        return ints1;
    }
}

