/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Json {
    private Json() {
    }

    public static JSONObject jsonObject(String txt) {
        JSONObject jsonObj = Json.jsonObjectOpt(txt);
        return jsonObj == null ? new JSONObject() : jsonObj;
    }

    public static JSONArray jsonArray(String txt) {
        JSONArray jsonArray = Json.jsonArrayOpt(txt);
        return jsonArray == null ? new JSONArray() : jsonArray;
    }

    public static JSONObject jsonObjectOpt(String txt) {
        String string = txt = txt == null ? "" : txt.trim();
        if (txt.startsWith("{") && txt.endsWith("}")) {
            try {
                return new JSONObject(txt);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return null;
    }

    public static JSONArray jsonArrayOpt(String txt) {
        String string = txt = txt == null ? "" : txt.trim();
        if (txt.startsWith("[") && txt.endsWith("]")) {
            try {
                return new JSONArray(txt);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return null;
    }

    public static double[] jsonToDoubles(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        int n = jsonArray.length();
        double[] doubleArray = new double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = jsonArray.optDouble(i, Double.NaN);
        }
        return doubleArray;
    }

    public static String[] jsonToStrings(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        int n = jsonArray.length();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = jsonArray.optString(i, null);
        }
        return stringArray;
    }

    public static String[] jsonGetKeys(JSONObject jsonObject) {
        return jsonObject == null ? null : JSONObject.getNames((JSONObject)jsonObject);
    }
}

