/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import uk.ac.starlink.ttools.func.Arithmetic;
import uk.ac.starlink.ttools.func.CoordsDegrees;
import uk.ac.starlink.ttools.func.TrigDegrees;

public class Sky {
    private static final double D2R = Math.PI / 180;

    private Sky() {
    }

    public static double skyDistance(double lon1, double lat1, double lon2, double lat2) {
        return CoordsDegrees.skyDistanceDegrees(lon1, lat1, lon2, lat2);
    }

    public static double midLon(double lon1, double lon2) {
        if (Math.abs(lon2 - lon1) < 180.0) {
            return 0.5 * (lon1 + lon2);
        }
        double lon1a = (lon1 + 180.0) % 360.0 - 180.0;
        double lon2a = (lon2 + 180.0) % 360.0 - 180.0;
        assert (Math.abs(lon2a - lon1a) < 180.0);
        return 0.5 * (lon1a + lon2a);
    }

    public static double midLat(double lat1, double lat2) {
        return 0.5 * (lat1 + lat2);
    }

    public static boolean inSkyEllipse(double lon0, double lat0, double lonCenter, double latCenter, double rA, double rB, double posAng) {
        double sinTheta;
        if (!(lat0 >= -90.0 && lat0 <= 90.0 && latCenter >= -90.0 && latCenter <= 90.0 && rA >= 0.0 && rB >= 0.0 && !Double.isNaN(lon0) && !Double.isNaN(lonCenter) && !Double.isNaN(posAng))) {
            return false;
        }
        if (Math.min(rA, rB) > 180.0) {
            return true;
        }
        double rMax = Math.max(rA, rB);
        if (Math.abs(lat0 - latCenter) > rMax) {
            return false;
        }
        double dist = Sky.skyDistance(lon0, lat0, lonCenter, latCenter);
        if (dist > rMax) {
            return false;
        }
        if (dist <= Math.min(rA, rB)) {
            return true;
        }
        double theta = CoordsDegrees.posAngDegrees(lonCenter, latCenter, lon0, lat0) - posAng;
        double cosTheta = Math.cos(Math.PI / 180 * theta);
        double rEllipse = rA * rB / Math.hypot(rB * cosTheta, rA * (sinTheta = Math.sin(Math.PI / 180 * theta)));
        return dist <= rEllipse;
    }

    public static boolean inSkyPolygon(double lon0, double lat0, double ... lonLats) {
        int np2 = lonLats.length;
        if (np2 % 2 != 0 || np2 < 6) {
            return false;
        }
        int ncN = 0;
        int ncS = 0;
        lon0 = Arithmetic.mod(lon0, 360.0);
        double latSum = 0.0;
        double lonA = Arithmetic.mod(lonLats[np2 - 2], 360.0);
        double latA = lonLats[np2 - 1];
        for (int ip2 = 0; ip2 < np2; ip2 += 2) {
            double lonB = Arithmetic.mod(lonLats[ip2 + 0], 360.0);
            double latB = lonLats[ip2 + 1];
            double dlonAB = lonB - lonA;
            if (dlonAB != 0.0 && Math.abs(dlonAB) < 180.0 ? lonA <= lon0 && lon0 < lonB || lonB <= lon0 && lon0 < lonA : lon0 < lonA && lon0 < lonB || lon0 >= lonA && lon0 >= lonB) {
                double latAB = Sky.arcLat(lonA, latA, lonB, latB, lon0);
                if (latAB > lat0) {
                    ++ncN;
                } else if (latAB < lat0) {
                    ++ncS;
                } else {
                    return true;
                }
            }
            latSum += latA;
            lonA = lonB;
            latA = latB;
        }
        int nc = latSum > 0.0 ? ncS : ncN;
        return nc % 2 != 0;
    }

    private static double arcLat(double lonA, double latA, double lonB, double latB, double lon0) {
        double k;
        double[] vecA = Sky.toVector(lonA, latA);
        double[] vecB = Sky.toVector(lonB, latB);
        double xA = vecA[0];
        double yA = vecA[1];
        double zA = vecA[2];
        double xAB = vecB[0] - vecA[0];
        double yAB = vecB[1] - vecA[1];
        double zAB = vecB[2] - vecA[2];
        double phi = Math.toRadians(lon0);
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        if (Math.abs(sinPhi) < Math.abs(cosPhi)) {
            double tanPhi = sinPhi / cosPhi;
            k = (yA - xA * tanPhi) / (xAB * tanPhi - yAB);
        } else {
            double cotPhi = cosPhi / sinPhi;
            k = (xA - yA * cotPhi) / (yAB * cotPhi - xAB);
        }
        double x0 = xA + k * xAB;
        double y0 = yA + k * yAB;
        double z0 = zA + k * zAB;
        double r0 = Math.sqrt(x0 * x0 + y0 * y0 + z0 * z0);
        return TrigDegrees.asinDeg(z0 / r0);
    }

    private static double[] toVector(double lon, double lat) {
        double cosLat = TrigDegrees.cosDeg(lat);
        double sinLat = TrigDegrees.sinDeg(lat);
        double cosLon = TrigDegrees.cosDeg(lon);
        double sinLon = TrigDegrees.sinDeg(lon);
        return new double[]{cosLat * cosLon, cosLat * sinLon, sinLat};
    }
}

