/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.convert.SkySystem;

public class Strings {
    private static Map<String, Pattern> patterns = new HashMap<String, Pattern>();
    private static final Pattern DESIG_REGEX = Pattern.compile("([A-Za-z0-9][\\w.-]+[ _])?([BJG]?)([0-9]{2,})((?:[.][0-9]+)?)([+-])([0-9]{2,})((?:[.][0-9]+)?)( [(][^)]*[)])?");
    private static final String URI_DATA_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.~";

    private Strings() {
    }

    public static String concat(Object ... strings) {
        StringBuffer sbuf = new StringBuffer();
        for (Object s : strings) {
            if (s == null) continue;
            sbuf.append(s);
        }
        return sbuf.toString();
    }

    public static String join(String separator, Object ... words) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            if (i > 0) {
                sbuf.append(separator);
            }
            sbuf.append(words[i]);
        }
        return sbuf.toString();
    }

    public static boolean equals(String s1, String s2) {
        boolean b1 = Tables.isBlank((Object)s1);
        boolean b2 = Tables.isBlank((Object)s2);
        if (b1 && b2) {
            return true;
        }
        if (b1 || b2) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        boolean b1 = Tables.isBlank((Object)s1);
        boolean b2 = Tables.isBlank((Object)s2);
        if (b1 && b2) {
            return true;
        }
        if (b1 || b2) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean startsWith(String whole, String start) {
        return whole != null && whole.startsWith(start);
    }

    public static boolean endsWith(String whole, String end) {
        return whole != null && whole.endsWith(end);
    }

    public static boolean contains(String whole, String sub) {
        return whole != null && whole.indexOf(sub) >= 0;
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static String[] split(String words) {
        return Strings.trim(words).split(" +");
    }

    public static String[] split(String words, String regex) {
        return words.split(regex);
    }

    public static boolean matches(String str, String regex) {
        return str != null && Strings.getPattern(regex).matcher(str).find();
    }

    public static String matchGroup(String str, String regex) {
        Matcher matcher;
        if (str != null && (matcher = Strings.getPattern(regex).matcher(str)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String replaceFirst(String str, String regex, String replacement) {
        return str == null ? null : Strings.getPattern(regex).matcher(str).replaceFirst(replacement == null ? "" : replacement);
    }

    public static String replaceAll(String str, String regex, String replacement) {
        return str == null ? null : Strings.getPattern(regex).matcher(str).replaceAll(replacement == null ? "" : replacement);
    }

    public static String substring(String str, int startIndex) {
        return str == null || str.length() < startIndex ? null : str.substring(startIndex);
    }

    public static String substring(String str, int startIndex, int endIndex) {
        if (str == null) {
            return null;
        }
        int leng = str.length();
        return str.substring(Math.min(startIndex, leng), Math.min(endIndex, leng));
    }

    public static String toUpperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String padWithZeros(long value, int ndigit) {
        String sval = Long.toString(value);
        int sl = sval.length();
        if (sl < ndigit) {
            char[] cbuf = new char[ndigit - sl];
            Arrays.fill(cbuf, '0');
            sval = new String(cbuf) + sval;
        }
        return sval;
    }

    public static double desigToRa(String designation) {
        double[] pos = Strings.desigToIcrs(designation);
        return pos == null ? Double.NaN : pos[0];
    }

    public static double desigToDec(String designation) {
        double[] pos = Strings.desigToIcrs(designation);
        return pos == null ? Double.NaN : pos[1];
    }

    public static double[] desigToIcrs(String designation) {
        Matcher matcher = DESIG_REGEX.matcher(designation);
        if (matcher.matches()) {
            String acronym = matcher.group(1);
            String flag = matcher.group(2);
            String lonInt = matcher.group(3);
            String lonFrac = matcher.group(4);
            String latSign = matcher.group(5);
            String latInt = matcher.group(6);
            String latFrac = matcher.group(7);
            if ("G".equals(flag)) {
                double b;
                double l;
                try {
                    l = Double.parseDouble(lonInt + lonFrac);
                    b = Double.parseDouble(latSign + latInt + latFrac);
                }
                catch (NumberFormatException e) {
                    assert (false) : "Regex should preclude this";
                    return null;
                }
                double[] fk5rad = SkySystem.GALACTIC.toFK5(Math.toRadians(l), Math.toRadians(b), 2000.0);
                double[] icrsRad = SkySystem.ICRS.fromFK5(fk5rad[0], fk5rad[1], 2000.0);
                return new double[]{Math.toDegrees(icrsRad[0]), Math.toDegrees(icrsRad[1])};
            }
            if ("B".equals(flag) || "J".equals(flag) || flag.length() == 0) {
                double latDeg;
                double lonDeg;
                try {
                    lonDeg = Strings.desigTxtToDegrees("", lonInt, lonFrac);
                    latDeg = Strings.desigTxtToDegrees(latSign, latInt, latFrac);
                }
                catch (RuntimeException e) {
                    assert (false) : "Regex should preclude this";
                    return null;
                }
                if ("J".equals(flag)) {
                    return new double[]{lonDeg, latDeg};
                }
                double[] fk5rad = SkySystem.FK4.toFK5(Math.toRadians(lonDeg), Math.toRadians(latDeg), 1950.0);
                double[] icrsRad = SkySystem.ICRS.fromFK5(fk5rad[0], fk5rad[1], 2000.0);
                return new double[]{Math.toDegrees(icrsRad[0]), Math.toDegrees(icrsRad[1])};
            }
            assert (false) : "Regex should preclude this";
            return null;
        }
        return null;
    }

    private static double desigTxtToDegrees(String txtSign, String txtInt, String txtFrac) {
        double factor;
        if ("".equals(txtSign)) {
            factor = 15.0;
        } else if ("+".equals(txtSign)) {
            factor = 1.0;
        } else if ("-".equals(txtSign)) {
            factor = -1.0;
        } else {
            assert (false) : "Regex should preclude this";
            return Double.NaN;
        }
        int intlen = txtInt.length();
        int fraclen = txtFrac.length();
        double c1 = Double.parseDouble(txtInt.substring(0, 2));
        double c2 = intlen == 2 && fraclen > 0 ? Double.parseDouble(txtFrac) * 60.0 : (intlen == 3 ? (double)Integer.parseInt(txtInt.substring(2, 3)) * 6.0 : (intlen >= 4 ? (double)Integer.parseInt(txtInt.substring(2, 4)) : 0.0));
        double c3 = intlen == 4 && fraclen > 0 ? Double.parseDouble(txtFrac) * 60.0 : (intlen == 5 ? Double.parseDouble(txtInt.substring(4, 5)) * 6.0 : (intlen == 6 ? Double.parseDouble(txtInt.substring(4, 6) + txtFrac) : (intlen > 6 ? Double.parseDouble(txtInt.substring(4, 6) + "." + txtInt.substring(6)) : 0.0)));
        return factor * (c1 + (c2 + c3 / 60.0) / 60.0);
    }

    private static Pattern getPattern(String regex) {
        Pattern pat = patterns.get(regex);
        if (pat == null) {
            pat = Pattern.compile(regex);
            patterns.put(regex, pat);
        }
        return pat;
    }
}

