/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.util.IconUtils;

public class ShaderListCellRenderer
implements ListCellRenderer<Shader> {
    private static final Map<Shader, Icon> rendererIconMap_ = new HashMap<Shader, Icon>();
    private BasicComboBoxRenderer baseRenderer_ = new BasicComboBoxRenderer();

    public ShaderListCellRenderer(final JComboBox<Shader> comboBox) {
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ShaderListCellRenderer.this.baseRenderer_.setEnabled(comboBox.isEnabled());
                }
            }
        });
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Shader> list, Shader shader, int index, boolean isSel, boolean hasFocus) {
        Component comp = this.baseRenderer_.getListCellRendererComponent(list, shader, index, isSel, hasFocus);
        if (comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            String text = shader.getName();
            if (!shader.isAbsolute()) {
                text = "* " + text;
            }
            label.setText(text);
            label.setIcon(ShaderListCellRenderer.getRendererIcon(shader));
        }
        return comp;
    }

    private static Icon getRendererIcon(Shader shader) {
        if (!rendererIconMap_.containsKey(shader)) {
            Icon icon = Shaders.createShaderIcon(shader, true, 48, 16, 4, 1);
            rendererIconMap_.put(shader, IconUtils.toImageIcon((Icon)icon));
        }
        return rendererIconMap_.get(shader);
    }
}

