/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.lang.reflect.Array;
import java.util.function.Function;
import java.util.function.IntFunction;
import uk.ac.starlink.ttools.jel.JELUtils;

public class JELArrayFunction<I, O>
implements Function<I, O> {
    private final String ivarName_;
    private final String xvarName_;
    private final String fexpr_;
    private final XResolver xResolver_;
    private final CompiledExpression fCompex_;
    private final Object[] args_;
    private final IntFunction<O> outSupplier_;
    private final ArrayTransfer elEval_;
    private final BadTransfer badEval_;

    public JELArrayFunction(String ivarName, String xvarName, String fexpr, Class<I> inClazz, Class<O> outClazz) throws CompilationException {
        this.ivarName_ = ivarName;
        this.xvarName_ = xvarName;
        this.fexpr_ = fexpr;
        Class[] staticLib = JELUtils.getStaticClasses().toArray(new Class[0]);
        this.xResolver_ = new XResolver(ivarName, xvarName, inClazz);
        Class[] dynamicLib = new Class[]{this.xResolver_.getClass()};
        Library lib = JELUtils.createLibrary(staticLib, dynamicLib, this.xResolver_);
        Class<?> reqElClazz = outClazz.isArray() ? outClazz.getComponentType() : null;
        this.fCompex_ = Evaluator.compile(fexpr, lib, reqElClazz);
        this.args_ = new Object[]{this.xResolver_};
        Class<?> outElClazz = reqElClazz == null ? JELArrayFunction.getElementType(this.fCompex_) : reqElClazz;
        IntFunction<Object> outSupplier = n -> Array.newInstance(outElClazz, n);
        this.outSupplier_ = outSupplier;
        if (outElClazz.equals(Byte.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((byte[])out)[i] = this.fCompex_.evaluate_byte(this.args_);
            };
            this.badEval_ = null;
        } else if (outElClazz.equals(Short.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((short[])out)[i] = this.fCompex_.evaluate_short(this.args_);
            };
            this.badEval_ = null;
        } else if (outElClazz.equals(Integer.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((int[])out)[i] = this.fCompex_.evaluate_int(this.args_);
            };
            this.badEval_ = null;
        } else if (outElClazz.equals(Long.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((long[])out)[i] = this.fCompex_.evaluate_long(this.args_);
            };
            this.badEval_ = null;
        } else if (outElClazz.equals(Float.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((float[])out)[i] = this.fCompex_.evaluate_float(this.args_);
            };
            this.badEval_ = (out, i) -> {
                ((float[])out)[i] = Float.NaN;
            };
        } else if (outElClazz.equals(Double.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((double[])out)[i] = this.fCompex_.evaluate_double(this.args_);
            };
            this.badEval_ = (out, i) -> {
                ((double[])out)[i] = Double.NaN;
            };
        } else if (outElClazz.equals(Boolean.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((boolean[])out)[i] = this.fCompex_.evaluate_boolean(this.args_);
            };
            this.badEval_ = null;
        } else if (outElClazz.equals(Character.TYPE)) {
            this.elEval_ = (out, i) -> {
                ((char[])out)[i] = this.fCompex_.evaluate_char(this.args_);
            };
            this.badEval_ = null;
        } else {
            this.elEval_ = (out, i) -> {
                ((Object[])out)[i] = this.fCompex_.evaluate(this.args_);
            };
            this.badEval_ = null;
        }
    }

    public O evaluate(I inArray) {
        if (inArray == null || !inArray.getClass().isArray()) {
            return null;
        }
        int nel = Array.getLength(inArray);
        O outArray = this.outSupplier_.apply(nel);
        this.xResolver_.array_ = inArray;
        for (int i = 0; i < nel; ++i) {
            this.xResolver_.index_ = i;
            try {
                this.elEval_.transfer(outArray, i);
                continue;
            }
            catch (Throwable e) {
                if (this.badEval_ == null) continue;
                this.badEval_.transfer(outArray, i);
            }
        }
        return outArray;
    }

    @Override
    public O apply(I inArray) {
        return this.evaluate(inArray);
    }

    public static <I> Object evaluate(String ivarName, String xvarName, String fexpr, I inArray) throws CompilationException {
        if (inArray == null) {
            return null;
        }
        Class<?> inClazz = inArray.getClass();
        return JELArrayFunction.typedEvaluate(ivarName, xvarName, fexpr, inArray, inClazz, Object.class);
    }

    private static <I, O> O typedEvaluate(String ivarName, String xvarName, String fexpr, I inArray, Class<I> inClazz, Class<O> outClazz) throws CompilationException {
        return new JELArrayFunction<I, O>(ivarName, xvarName, fexpr, inClazz, outClazz).evaluate(inArray);
    }

    private static Class<?> getElementType(CompiledExpression compEx) {
        Class<?> clazz = compEx.getTypeC();
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        return clazz;
    }

    @FunctionalInterface
    private static interface BadTransfer {
        public void transfer(Object var1, int var2);
    }

    @FunctionalInterface
    private static interface ArrayTransfer {
        public void transfer(Object var1, int var2) throws Throwable;
    }

    public static class XResolver
    extends DVMap {
        private final String ivarName_;
        private final String xvarName_;
        private final String typeName_;
        private Object array_;
        private int index_;

        private XResolver(String ivarName, String xvarName, Class<?> arrayClazz) {
            this.xvarName_ = xvarName;
            this.ivarName_ = ivarName;
            String tname = arrayClazz.equals(byte[].class) ? "Byte" : (arrayClazz.equals(short[].class) ? "Short" : (arrayClazz.equals(int[].class) ? "Int" : (arrayClazz.equals(long[].class) ? "Long" : (arrayClazz.equals(float[].class) ? "Float" : (arrayClazz.equals(double[].class) ? "Double" : (arrayClazz.equals(boolean[].class) ? "Boolean" : (arrayClazz.equals(char[].class) ? "Char" : (arrayClazz.equals(String[].class) ? "String" : "Object"))))))));
            this.typeName_ = tname;
        }

        @Override
        public String getTypeName(String name) {
            if (name.equals(this.ivarName_)) {
                return "Int";
            }
            if (name.equals(this.xvarName_)) {
                return this.typeName_;
            }
            return null;
        }

        public byte getByteProperty(String name) {
            return name.equals(this.xvarName_) ? ((byte[])this.array_)[this.index_] : (byte)0;
        }

        public short getShortProperty(String name) {
            return name.equals(this.xvarName_) ? ((short[])this.array_)[this.index_] : (short)0;
        }

        public int getIntProperty(String name) {
            if (name.equals(this.ivarName_)) {
                return this.index_;
            }
            if (name.equals(this.xvarName_)) {
                return ((int[])this.array_)[this.index_];
            }
            return 0;
        }

        public long getLongProperty(String name) {
            return name.equals(this.xvarName_) ? ((long[])this.array_)[this.index_] : 0L;
        }

        public float getFloatProperty(String name) {
            return name.equals(this.xvarName_) ? ((float[])this.array_)[this.index_] : Float.NaN;
        }

        public double getDoubleProperty(String name) {
            return name.equals(this.xvarName_) ? ((double[])this.array_)[this.index_] : Double.NaN;
        }

        public boolean getBooleanProperty(String name) {
            return name.equals(this.xvarName_) ? ((boolean[])this.array_)[this.index_] : false;
        }

        public char getCharProperty(String name) {
            return name.equals(this.xvarName_) ? ((char[])this.array_)[this.index_] : (char)'\u0000';
        }

        public String getStringProperty(String name) {
            return name.equals(this.xvarName_) ? ((String[])this.array_)[this.index_] : null;
        }

        public Object getObjectProperty(String name) {
            return name.equals(this.xvarName_) ? ((Object[])this.array_)[this.index_] : null;
        }
    }
}

