/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import gnu.jel.Parser;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.func.Arithmetic;
import uk.ac.starlink.ttools.func.Arrays;
import uk.ac.starlink.ttools.func.Bits;
import uk.ac.starlink.ttools.func.Conversions;
import uk.ac.starlink.ttools.func.CoordsDegrees;
import uk.ac.starlink.ttools.func.CoordsRadians;
import uk.ac.starlink.ttools.func.Coverage;
import uk.ac.starlink.ttools.func.Distances;
import uk.ac.starlink.ttools.func.Fluxes;
import uk.ac.starlink.ttools.func.Formats;
import uk.ac.starlink.ttools.func.Gaia;
import uk.ac.starlink.ttools.func.Json;
import uk.ac.starlink.ttools.func.KCorrections;
import uk.ac.starlink.ttools.func.Lists;
import uk.ac.starlink.ttools.func.Maths;
import uk.ac.starlink.ttools.func.Randoms;
import uk.ac.starlink.ttools.func.Shapes;
import uk.ac.starlink.ttools.func.Sky;
import uk.ac.starlink.ttools.func.Strings;
import uk.ac.starlink.ttools.func.Tilings;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.func.TrigDegrees;
import uk.ac.starlink.ttools.func.URLs;
import uk.ac.starlink.ttools.func.VO;
import uk.ac.starlink.ttools.jel.CustomCompilationException;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELQuantity;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;
import uk.ac.starlink.ttools.jel.StateDependent;
import uk.ac.starlink.ttools.jel.TablelessJELRowReader;
import uk.ac.starlink.util.Loader;

public class JELUtils {
    private static List<Class<?>> staticClasses_;
    private static Logger logger_;
    private static final HashMap<String, Class<?>> CAST_MAP;
    public static final String CLASSES_PROPERTY = "jel.classes";

    public static Library getLibrary(JELRowReader reader) {
        Class[] classArray;
        Class[] staticLib = JELUtils.getStaticClasses().toArray(new Class[0]);
        if (reader == null) {
            classArray = new Class[]{};
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = reader.getClass();
        }
        Class[] dynamicLib = classArray;
        return JELUtils.createLibrary(staticLib, dynamicLib, reader);
    }

    public static Library createLibrary(Class<?>[] staticLib, Class<?>[] dynamicLib, DVMap resolver) {
        Class[] dotClasses = new Class[]{};
        Library lib = new Library(staticLib, dynamicLib, dotClasses, resolver, CAST_MAP);
        JELUtils.markStateDependentFunctions(lib, staticLib);
        return lib;
    }

    public static JELRowReader createDatalessRowReader(StarTable table) {
        if (table == null) {
            return new TablelessJELRowReader();
        }
        return new DummyJELRowReader((StarTable)new WrapperStarTable(table){

            public ColumnInfo getColumnInfo(int icol) {
                ColumnInfo baseInfo = super.getColumnInfo(icol);
                return new ColumnInfo("", baseInfo.getContentClass(), null);
            }

            public Object[] getRow(long irow) {
                throw new UnsupportedOperationException();
            }

            public Object getCell(long irow, int icol) {
                throw new UnsupportedOperationException();
            }

            public RowSequence getRowSequence() {
                throw new UnsupportedOperationException();
            }

            public RowAccess getRowAccess() {
                throw new UnsupportedOperationException();
            }

            public RowSplittable getRowSplittable() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static List<Class<?>> getStaticClasses() {
        if (staticClasses_ == null) {
            ArrayList<Class> classList = new ArrayList<Class>(java.util.Arrays.asList(Arithmetic.class, Bits.class, Arrays.class, Conversions.class, CoordsDegrees.class, CoordsRadians.class, Coverage.class, Distances.class, Fluxes.class, Formats.class, Gaia.class, Json.class, KCorrections.class, Lists.class, Maths.class, Randoms.class, Shapes.class, Sky.class, Strings.class, Tilings.class, Times.class, TrigDegrees.class, URLs.class, VO.class));
            Loader.loadProperties();
            try {
                String auxClasses = System.getProperty(CLASSES_PROPERTY);
                if (auxClasses != null && auxClasses.trim().length() > 0) {
                    String[] cs = auxClasses.split(":");
                    for (int i = 0; i < cs.length; ++i) {
                        String className = cs[i].trim();
                        try {
                            Class<?> clazz = Class.forName(className);
                            if (classList.contains(clazz)) continue;
                            classList.add(clazz);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            logger_.warning("Class not found: " + className);
                        }
                    }
                }
            }
            catch (SecurityException e) {
                logger_.info("Security manager prevents loading auxiliary JEL classes");
            }
            staticClasses_ = classList;
        }
        return staticClasses_;
    }

    public static Class<?> getExpressionType(Library lib, StarTable table, String expr) throws CompilationException {
        return new Parser((String)JELUtils.tweakExpression((StarTable)table, (String)expr), (Library)lib).parse(null).resType;
    }

    public static void checkExpressionType(Library lib, StarTable table, String expr, Class<?> clazz) throws CompilationException {
        new Parser(JELUtils.tweakExpression(table, expr), lib).parse(clazz);
    }

    public static CompiledExpression compile(Library lib, StarTable table, String expr, Class<?> clazz) throws CompilationException {
        try {
            return Evaluator.compile(JELUtils.tweakExpression(table, expr), lib, clazz);
        }
        catch (CompilationException e) {
            try {
                Evaluator.compile(JELUtils.tweakExpression(table, expr), lib);
            }
            catch (CompilationException e2) {
                throw e;
            }
            throw new CustomCompilationException("Expression " + expr + " has wrong type (not " + clazz.getName() + ")", e);
        }
    }

    public static CompiledExpression compile(Library lib, StarTable table, String expr) throws CompilationException {
        return Evaluator.compile(JELUtils.tweakExpression(table, expr), lib);
    }

    public static JELQuantity compileQuantity(Library lib, StarTableJELRowReader jelRdr, final String expr, Class<?> clazz) throws CompilationException {
        ColumnInfo info;
        StarTable table = jelRdr.getTable();
        String calcExpr = JELUtils.tweakExpression(table, expr);
        final CompiledExpression compEx = clazz == null ? JELUtils.compile(lib, table, calcExpr) : JELUtils.compile(lib, table, calcExpr, clazz);
        int icol = jelRdr.getColumnIndex(calcExpr);
        if (icol >= 0) {
            info = table.getColumnInfo(icol);
        } else {
            String name = expr.replaceAll("\\s", "").replaceAll("[^A-Za-z0-9]+", "_");
            Class<?> exprClazz = new Parser((String)calcExpr, (Library)lib).parse(null).resType;
            info = new DefaultValueInfo(name, JELUtils.getWrapperType(exprClazz));
            if (!name.trim().equals(expr.trim())) {
                ((DefaultValueInfo)info).setDescription(expr);
            }
        }
        return new JELQuantity((ValueInfo)info){
            final /* synthetic */ ValueInfo val$info;
            {
                this.val$info = valueInfo;
            }

            @Override
            public String getExpression() {
                return expr;
            }

            @Override
            public CompiledExpression getCompiledExpression() {
                return compEx;
            }

            @Override
            public ValueInfo getValueInfo() {
                return this.val$info;
            }
        };
    }

    public static Function<Library, CompiledExpression> compiler(StarTable table, String expr, Class<?> clazz) throws CompilationException {
        Library dummyLib = JELUtils.getLibrary(new DummyJELRowReader(table));
        JELUtils.compile(dummyLib, table, expr, clazz);
        return lib -> {
            try {
                return JELUtils.compile(lib, table, expr, clazz);
            }
            catch (CompilationException e) {
                throw new RuntimeException("Unexpected compilation error; it worked last time", e);
            }
        };
    }

    public static CompiledExpression[] compileExpressions(StarTableJELRowReader reader, String[] exprs) throws IOException {
        StarTable table = reader.getTable();
        int nexpr = exprs.length;
        Library lib = JELUtils.getLibrary(reader);
        CompiledExpression[] compexs = new CompiledExpression[nexpr];
        for (int icol = 0; icol < nexpr; ++icol) {
            String expr = exprs[icol];
            try {
                compexs[icol] = JELUtils.compile(lib, table, expr);
                continue;
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad expression: " + expr).initCause(e);
            }
        }
        return compexs;
    }

    public static IOException toIOException(CompilationException e, String expr) {
        StringBuffer sbuf = new StringBuffer().append("Bad expression \"").append(expr).append("\"");
        String msg = e.getMessage();
        if (msg != null && msg.trim().length() > 0) {
            sbuf.append(" (").append(msg).append(")");
        }
        return (IOException)new IOException(sbuf.toString()).initCause(e);
    }

    private static void markStateDependentFunctions(Library lib, Class<?>[] staticLib) {
        for (Class<?> clazz : staticLib) {
            for (Method method : clazz.getMethods()) {
                if (method.getAnnotation(StateDependent.class) == null) continue;
                String mname = method.getName();
                Class<?>[] argtypes = method.getParameterTypes();
                int mods = method.getModifiers();
                if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods)) {
                    logger_.warning("Attempting to mark state-dependent non-public-static method " + clazz.getName() + "." + method + "?");
                }
                try {
                    lib.markStateDependent(mname, argtypes);
                }
                catch (CompilationException e) {
                    assert (false);
                    logger_.warning("Can't mark state-dependent " + clazz.getName() + "." + method + "?");
                }
            }
        }
    }

    private static final String tweakExpression(StarTable table, String expr) {
        int ncol = table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            if (!table.getColumnInfo(icol).getName().equalsIgnoreCase(expr)) continue;
            return '$' + Integer.toString(icol + 1);
        }
        return expr;
    }

    public static Class<?> getWrapperType(Class<?> clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        return clazz;
    }

    private static HashMap<String, Class<?>> createCastMap() {
        HashMap cnmap = new HashMap();
        cnmap.put("booleanArray", boolean[].class);
        cnmap.put("charArray", char[].class);
        cnmap.put("byteArray", byte[].class);
        cnmap.put("shortArray", short[].class);
        cnmap.put("intArray", int[].class);
        cnmap.put("longArray", long[].class);
        cnmap.put("floatArray", float[].class);
        cnmap.put("doubleArray", double[].class);
        return cnmap;
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.ttools");
        CAST_MAP = JELUtils.createCastMap();
    }
}

