/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.LongFunction;
import java.util.stream.LongStream;
import uk.ac.starlink.ttools.moc.BitSetBag;
import uk.ac.starlink.ttools.moc.IndexBag;
import uk.ac.starlink.ttools.moc.MocBuilder;
import uk.ac.starlink.ttools.moc.MultiBitSetBag;
import uk.ac.starlink.util.LongList;

public class BagMocBuilder
implements MocBuilder {
    private final int maxOrder_;
    private final LongFunction<IndexBag> bagFactory_;
    private final IndexBag[] bags_;

    public BagMocBuilder(int maxOrder) {
        this(maxOrder, BagMocBuilder::createDefaultBag);
    }

    public BagMocBuilder(int maxOrder, LongFunction<IndexBag> bagFactory) {
        this.maxOrder_ = maxOrder;
        this.bagFactory_ = bagFactory;
        this.bags_ = new IndexBag[this.maxOrder_ + 1];
    }

    @Override
    public void addTile(int order, long ipix) {
        if (order > this.maxOrder_) {
            ipix >>= 2 * (order - this.maxOrder_);
            order = this.maxOrder_;
        }
        if (ipix < 0L || ipix >= 12L << 2 * order) {
            throw new IllegalArgumentException("Order: " + order + ", pixel: " + ipix);
        }
        this.getBag(order).addIndex(ipix);
    }

    @Override
    public void endTiles() {
        this.consolidate();
    }

    @Override
    public PrimitiveIterator.OfLong createOrderedUniqIterator() {
        boolean io = false;
        return new PrimitiveIterator.OfLong(){
            int io_ = -1;
            boolean done_;
            PrimitiveIterator.OfLong oIt_ = LongStream.empty().iterator();
            long nextUniq_;
            {
                this.calculateNext();
            }

            @Override
            public boolean hasNext() {
                return !this.done_;
            }

            @Override
            public long nextLong() {
                if (this.hasNext()) {
                    long nextUniq = this.nextUniq_;
                    this.calculateNext();
                    return nextUniq;
                }
                throw new NoSuchElementException();
            }

            private void calculateNext() {
                while (!this.oIt_.hasNext()) {
                    if (this.io_ + 1 < BagMocBuilder.this.bags_.length) {
                        IndexBag bag = BagMocBuilder.this.bags_[++this.io_];
                        this.oIt_ = bag == null ? LongStream.empty().iterator() : bag.sortedLongIterator();
                        continue;
                    }
                    this.done_ = true;
                    return;
                }
                this.nextUniq_ = BagMocBuilder.uniq(this.io_, this.oIt_.nextLong());
            }
        };
    }

    @Override
    public long[] getOrderCounts() {
        LongList countList = new LongList();
        for (int io = this.maxOrder_; io >= 0; --io) {
            long count;
            long l = count = this.bags_[io] == null ? 0L : this.bags_[io].getCount();
            if (countList.size() <= 0 && count <= 0L) continue;
            countList.add(count);
        }
        int nc = countList.size();
        long[] counts = new long[nc];
        for (int io = 0; io < nc; ++io) {
            counts[io] = countList.get(nc - 1 - io);
        }
        return counts;
    }

    public void consolidate() {
        IndexBag[] bags1 = new IndexBag[this.maxOrder_ + 1];
        long[] quadMembers = new long[4];
        for (int io = this.maxOrder_; io >= 0; --io) {
            IndexBag bag0 = this.bags_[io];
            if (bag0 == null) continue;
            IndexBag bag1 = this.createOrderBag(io);
            long iquad = -1L;
            int quadCount = 0;
            PrimitiveIterator.OfLong ixIt = bag0.sortedLongIterator();
            while (ixIt.hasNext()) {
                long index = ixIt.nextLong();
                long iq = index >> 2;
                if (iq != iquad) {
                    if (quadCount > 0 && !this.isCovered(io - 1, iquad)) {
                        if (quadCount == 4 && io > 0) {
                            this.getBag(io - 1).addIndex(iquad);
                        } else {
                            for (int i = 0; i < quadCount; ++i) {
                                bag1.addIndex(quadMembers[i]);
                            }
                        }
                    }
                    iquad = iq;
                    quadCount = 0;
                }
                quadMembers[quadCount++] = index;
            }
            if (quadCount > 0 && !this.isCovered(io - 1, iquad)) {
                if (quadCount == 4 && io > 0) {
                    this.getBag(io - 1).addIndex(iquad);
                } else {
                    for (int i = 0; i < quadCount; ++i) {
                        bag1.addIndex(quadMembers[i]);
                    }
                }
            }
            bags1[io] = bag1.getCount() == 0L ? null : bag1;
        }
        System.arraycopy(bags1, 0, this.bags_, 0, this.maxOrder_ + 1);
    }

    public static long uniq(int order, long lindex) {
        return (4L << 2 * order) + lindex;
    }

    private IndexBag createOrderBag(int order) {
        assert (order >= 0 && order <= this.maxOrder_);
        long size = 12L << 2 * order;
        return this.bagFactory_.apply(size);
    }

    private IndexBag getBag(int order) {
        if (this.bags_[order] == null) {
            this.bags_[order] = this.createOrderBag(order);
        }
        return this.bags_[order];
    }

    private boolean isCovered(int order, long lindex) {
        for (int io = order; io >= 0; --io) {
            if (this.bags_[io] != null && this.bags_[io].hasIndex(lindex)) {
                return true;
            }
            lindex >>= 2;
        }
        return false;
    }

    private static IndexBag createDefaultBag(long size) {
        int isize = (int)size;
        int bOrder = 12;
        if (size <= 12L << 2 * bOrder) {
            assert ((long)isize == size);
            return new BitSetBag(isize);
        }
        return new MultiBitSetBag(size);
    }
}

