/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.Range;
import cds.moc.SMoc;
import java.util.Arrays;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import uk.ac.starlink.ttools.func.Coverage;
import uk.ac.starlink.ttools.moc.MocBuilder;

public abstract class CdsMocBuilder
implements MocBuilder {
    private final int maxOrder_;
    final SMoc1 smoc_;

    protected CdsMocBuilder(int maxOrder) {
        this.maxOrder_ = maxOrder;
        this.smoc_ = new SMoc1(maxOrder);
    }

    @Override
    public PrimitiveIterator.OfLong createOrderedUniqIterator() {
        final Iterator cellIt = this.smoc_.iterator();
        return new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return cellIt.hasNext();
            }

            @Override
            public long nextLong() {
                MocCell cell = (MocCell)cellIt.next();
                return Moc.hpix2uniq((int)cell.order, (long)cell.start);
            }
        };
    }

    @Override
    public long[] getOrderCounts() {
        long[] counts = new long[this.maxOrder_ + 1];
        int maxOrd = 0;
        PrimitiveIterator.OfLong uniqIt = this.createOrderedUniqIterator();
        while (uniqIt.hasNext()) {
            long uniq = uniqIt.nextLong();
            int order = Coverage.uniqToOrder(uniq);
            maxOrd = Math.max(maxOrd, order);
            int n = order;
            counts[n] = counts[n] + 1L;
        }
        long[] counts1 = new long[maxOrd + 1];
        System.arraycopy(counts, 0, counts1, 0, maxOrd + 1);
        return counts1;
    }

    public static MocBuilder createCdsMocBuilder(final int maxOrder, final int batchSize) {
        if (batchSize == 1) {
            return new CdsMocBuilder(maxOrder){
                {
                    this.smoc_.bufferOn(500000);
                }

                @Override
                public void addTile(int order, long ipix) {
                    try {
                        this.smoc_.add(order, ipix);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("CDS MOC error", e);
                    }
                }

                @Override
                public void endTiles() {
                    this.smoc_.bufferOff();
                }
            };
        }
        return new CdsMocBuilder(maxOrder){
            final int bufsiz_;
            final long[][] bufs_;
            final int[] ibs_;
            {
                super(maxOrder2);
                this.bufsiz_ = batchSize;
                this.bufs_ = new long[maxOrder + 1][];
                this.ibs_ = new int[maxOrder + 1];
                this.smoc_.bufferOn(500000);
            }

            @Override
            public void addTile(int order, long ipix) {
                long[] buf = this.bufs_[order];
                if (buf == null) {
                    buf = new long[this.bufsiz_];
                }
                int n = order;
                int n2 = this.ibs_[n];
                this.ibs_[n] = n2 + 1;
                buf[n2] = ipix;
                if (this.ibs_[order] >= this.bufsiz_) {
                    this.smoc_.add(order, buf, this.ibs_[order]);
                    this.ibs_[order] = 0;
                }
            }

            @Override
            public void endTiles() {
                for (int io = 0; io <= maxOrder; ++io) {
                    long[] buf = this.bufs_[io];
                    if (buf == null) continue;
                    this.smoc_.add(io, buf, this.ibs_[io]);
                }
            }
        };
    }

    private static class SMoc1
    extends SMoc {
        SMoc1(int order) {
            super(order);
        }

        public void add(int order, long[] singletons, int size) {
            Arrays.sort(singletons, 0, size);
            int shift = (this.maxOrder() - order) * this.shiftOrder();
            Range r = new Range(size);
            for (int i = 0; i < size; ++i) {
                int j;
                for (j = i; j < size - 1 && singletons[j + 1] - singletons[j] <= 1L; ++j) {
                }
                long start = singletons[i] << shift;
                long end = singletons[j] + 1L << shift;
                r.append(start, end);
            }
            this.range = this.range.union(r);
            this.resetCache();
        }
    }
}

