/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import java.util.Arrays;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.stream.LongStream;
import uk.ac.starlink.ttools.moc.IndexBag;

public class MultiBitSetBag
implements IndexBag {
    private final long size_;
    private final int bankSize_;
    private final long bankSizeL_;
    private final int nbank_;
    private final BitSet[] banks_;
    public static final int DFLT_BANKSIZE = 0x1000000;

    public MultiBitSetBag(long size) {
        this(size, 0x1000000);
    }

    public MultiBitSetBag(long size, int bankSize) {
        this.size_ = size;
        this.bankSize_ = bankSize;
        this.bankSizeL_ = bankSize;
        long nb = (size - 1L) / this.bankSizeL_ + 1L;
        this.nbank_ = (int)nb;
        if ((long)this.nbank_ != nb) {
            throw new IllegalArgumentException("Bank count " + nb + " too high");
        }
        this.banks_ = new BitSet[this.nbank_];
    }

    @Override
    public void addIndex(long lindex) {
        this.getBank(lindex).set(this.getOffset(lindex));
    }

    @Override
    public boolean hasIndex(long lindex) {
        BitSet bank = this.getBank(lindex);
        return bank != null && bank.get(this.getOffset(lindex));
    }

    @Override
    public long getCount() {
        return Arrays.stream(this.banks_).mapToLong(b -> b == null ? 0L : (long)b.cardinality()).sum();
    }

    @Override
    public PrimitiveIterator.OfLong sortedLongIterator() {
        LongStream stream = LongStream.empty();
        for (int ib = 0; ib < this.nbank_; ++ib) {
            BitSet bank = this.banks_[ib];
            if (bank == null) continue;
            long offset = (long)ib * this.bankSizeL_;
            LongStream s1 = bank.stream().asLongStream().map(l -> l + offset);
            stream = LongStream.concat(stream, bank.stream().asLongStream().map(l -> l + offset));
        }
        return stream.iterator();
    }

    private int getBankIndex(long lindex) {
        return (int)(lindex / this.bankSizeL_);
    }

    private BitSet getBank(long lindex) {
        int ibank = this.getBankIndex(lindex);
        BitSet bank = this.banks_[ibank];
        if (bank == null) {
            this.banks_[ibank] = bank = new BitSet(this.bankSize_);
        }
        return bank;
    }

    private int getOffset(long lindex) {
        return (int)(lindex % this.bankSizeL_);
    }
}

