/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.CubeWriter;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.task.CombinerParameter;
import uk.ac.starlink.ttools.task.WordParser;
import uk.ac.starlink.ttools.task.WordsParameter;
import uk.ac.starlink.util.Destination;

public class CubeMode
implements ProcessingMode {
    private final WordsParameter<double[]> boundsParam_ = CubeMode.createBoundsParameter("bounds");
    private final WordsParameter<Double> binsizeParam_;
    private final WordsParameter<Integer> nbinParam_;
    private final OutputStreamParameter outParam_;
    private final CombinerParameter combinerParam_;
    private final ChoiceParameter<Class<?>> typeParam_;
    private final StringParameter scaleParam_;
    private WordsParameter<String> colsParam_;
    private static final Class<?>[] OUT_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    public CubeMode() {
        this.boundsParam_.setNullPermitted(true);
        this.boundsParam_.setStringDefault(null);
        this.boundsParam_.setWordUsage("[<lo>]:[<hi>]");
        this.boundsParam_.setPrompt("Data bounds for each dimension");
        this.boundsParam_.setDescription(new String[]{"<p>Gives the bounds for each dimension of the cube in data", "coordinates.  The form of the value is a space-separated list", "of words, each giving an optional lower bound, then a colon,", "then an optional upper bound, for instance", "\"1:100 0:20\" to represent a range for two-dimensional output", "between 1 and 100 of the first coordinate (table column)", "and between 0 and 20 for the second.", "Either or both numbers may be omitted to indicate that the", "bounds should be determined automatically by assessing the", "range of the data in the table.", "A null value for the parameter indicates that all bounds should", "be determined automatically for all the dimensions.", "</p>", "<p>If any of the bounds need to be determined automatically", "in this way, two passes through the data will be required,", "the first to determine bounds and the second", "to populate the cube.", "</p>"});
        this.binsizeParam_ = WordsParameter.createDoubleWordsParameter("binsizes");
        this.binsizeParam_.setWordUsage("<size>");
        this.binsizeParam_.setPrompt("Extent of bins in each dimension");
        this.binsizeParam_.setDescription(new String[]{"<p>Gives the extent of of the data bins (cube pixels) in each", "dimension in data coordinates.", "The form of the value is a space-separated list of values,", "giving a list of extents for the first, second, ... dimension.", "Either this parameter or the <code>nbins</code> parameter", "must be supplied.", "</p>"});
        this.nbinParam_ = WordsParameter.createIntegerWordsParameter("nbins");
        this.nbinParam_.setWordUsage("<num>");
        this.nbinParam_.setNullPermitted(true);
        this.nbinParam_.setPrompt("Number of bins in each dimension");
        this.nbinParam_.setDescription(new String[]{"<p>Gives the number of bins (cube pixels) in each dimension.", "The form of the value is a space-separated list of integers,", "giving the number of pixels for the output cube in the", "first, second, ... dimension.", "Either this parameter or the <code>binsizes</code> parameter", "must be supplied.", "</p>"});
        this.combinerParam_ = new CombinerParameter("combine");
        this.combinerParam_.setDescription(new String[]{"<p>Defines how values contributing to the same density map bin", "are combined together to produce the value assigned to that bin.", "Possible values are:", this.combinerParam_.getOptionsDescription(), "</p>"});
        this.combinerParam_.setDefaultOption(Combiner.SUM);
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPreferExplicit(true);
        this.outParam_.setPrompt("Location of output FITS file");
        this.outParam_.setDescription(new String[]{this.outParam_.getDescription(), "<p>The output cube is currently written as", "a single-HDU FITS file.", "</p>"});
        this.typeParam_ = new ChoiceParameter("otype", (Object[])OUT_TYPES);
        this.typeParam_.setNullPermitted(true);
        this.typeParam_.setStringDefault(null);
        this.typeParam_.setPrompt("Type of output array elements");
        this.typeParam_.setDescription(new String[]{"<p>The type of numeric value which will fill the output array.", "If no selection is made, the output type will be", "determined automatically as the shortest type required to hold", "all the values in the array.", "Currently, integers are always signed (no BSCALE/BZERO),", "so for instance the largest value that can be recorded", "in 8 bits is 127.", "</p>"});
        this.scaleParam_ = new StringParameter("scale");
        this.scaleParam_.setUsage("<expr>");
        this.scaleParam_.setNullPermitted(true);
        this.scaleParam_.setStringDefault(null);
        this.scaleParam_.setPrompt("Value by which to scale counts");
        this.scaleParam_.setDescription(new String[]{"<p>Optionally gives a weight for each entry contributing to", "histogram bins.", "The value of this expression is accumulated,", "in accordance with the", "<code>" + this.combinerParam_.getName() + "</code> parameter,", "into the bin defined by its coordinates.", "If no expression is given, the value 1 is assumed.", "</p>"});
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Makes an N-dimensional histogram of the columns in the", "input table.", "The result is an N-dimensional array which is output as a", "FITS image file.", "</p>"});
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[]{this.boundsParam_, this.binsizeParam_, this.nbinParam_, this.combinerParam_, this.outParam_, this.typeParam_, this.scaleParam_};
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        double[] binsizes;
        int[] nbins;
        String[] colExprs = this.colsParam_.wordsValue(env);
        int ndim = colExprs.length;
        this.boundsParam_.setRequiredWordCount(ndim);
        this.binsizeParam_.setRequiredWordCount(ndim);
        this.nbinParam_.setRequiredWordCount(ndim);
        String scaleExpr = this.scaleParam_.stringValue(env);
        double[][] boundsWords = this.boundsParam_.wordsValue(env);
        double[] loBounds = new double[ndim];
        double[] hiBounds = new double[ndim];
        if (boundsWords != null) {
            for (int i = 0; i < ndim; ++i) {
                double[] bounds = boundsWords[i];
                loBounds[i] = bounds[0];
                hiBounds[i] = bounds[1];
            }
        } else {
            Arrays.fill(loBounds, Double.NaN);
            Arrays.fill(hiBounds, Double.NaN);
        }
        Integer[] nbinWords = this.nbinParam_.wordsValue(env);
        if (nbinWords != null) {
            this.binsizeParam_.setNullPermitted(true);
            this.binsizeParam_.setValueFromString(env, null);
            nbins = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                nbins[i] = nbinWords[i];
                if (nbins[i] > 0) continue;
                throw new ParameterValueException(this.nbinParam_, "Non-positive value");
            }
            binsizes = null;
        } else {
            this.binsizeParam_.setNullPermitted(false);
            Double[] binsizeWords = this.binsizeParam_.wordsValue(env);
            binsizes = new double[ndim];
            for (int i = 0; i < ndim; ++i) {
                binsizes[i] = binsizeWords[i];
                if (binsizes[i] > 0.0) continue;
                throw new ParameterValueException(this.binsizeParam_, "Non-positive value");
            }
            nbins = null;
        }
        Combiner combiner = (Combiner)this.combinerParam_.objectValue(env);
        Destination dest = (Destination)this.outParam_.objectValue(env);
        Class outType = (Class)this.typeParam_.objectValue(env);
        return new CubeWriter(loBounds, hiBounds, nbins, binsizes, colExprs, scaleExpr, combiner, dest, outType);
    }

    public void setColumnsParameter(WordsParameter<String> colsParam) {
        this.colsParam_ = colsParam;
    }

    public static WordsParameter<double[]> createBoundsParameter(String name) {
        final Pattern boundsRegex = Pattern.compile("(.*):(.*)");
        return new WordsParameter<double[]>(name, double[][].class, new WordParser<double[]>(){

            @Override
            public double[] parseWord(String word) throws TaskException {
                Matcher matcher = boundsRegex.matcher(word);
                if (matcher.matches()) {
                    double[] bounds = new double[]{Double.NaN, Double.NaN};
                    for (int i = 0; i < 2; ++i) {
                        String sval = matcher.group(i + 1).trim();
                        if (sval.length() <= 0) continue;
                        try {
                            bounds[i] = Double.parseDouble(sval);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new UsageException("Bad bound string \"" + sval + "\"", (Throwable)e);
                        }
                    }
                    if (bounds[0] >= bounds[1]) {
                        throw new UsageException("Bad bound string \"" + word + "\": lo>=hi");
                    }
                    return bounds;
                }
                throw new UsageException("Bad <lo>:<hi> bounds string");
            }
        });
    }
}

