/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.util.logging.Logger;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.WriteMode;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.JdbcConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class JdbcMode
implements ProcessingMode {
    private final StringParameter protoParam_ = new StringParameter("protocol");
    private final StringParameter hostParam_;
    private final StringParameter dbParam_;
    private final StringParameter tableParam_;
    private final ChoiceParameter<WriteMode> writeParam_;
    private final StringParameter userParam_;
    private final StringParameter passwdParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");

    public JdbcMode() {
        this.protoParam_.setPrompt("Subprotocol for JDBC connection (e.g. mysql)");
        this.protoParam_.setUsage("<jdbc-protocol>");
        this.protoParam_.setDescription(new String[]{"<p>The driver-specific sub-protocol specifier for the JDBC", "connection.", "For MySQL's Connector/J driver, this is <code>mysql</code>,", "and for PostgreSQL's driver it is <code>postgresql</code>.", "For other drivers, you may have to consult the driver", "documentation.", "</p>"});
        this.hostParam_ = new StringParameter("host");
        this.hostParam_.setPrompt("SQL database host");
        this.hostParam_.setPrompt("<hostname>");
        this.hostParam_.setStringDefault("localhost");
        this.hostParam_.setDescription(new String[]{"<p>The host which is acting as a database server.", "</p>"});
        this.dbParam_ = new StringParameter("db");
        this.dbParam_.setPrompt("Name of database on database server");
        this.dbParam_.setUsage("<db-name>");
        this.dbParam_.setDescription(new String[]{"<p>The name of the database on the server into which the", "new table will be written.", "</p>", "<p>The value of this parameter forms the last part", "of the JDBC connection URL.", "That means that for some JDBC drivers,", "you can append parameter specifications to it", "to affect the way the connection is made to the database, e.g.", "\"<code>" + this.dbParam_.getName() + "=some_db?useSSL=false</code>\"", "for MySQL's Connector/J.", "</p>"});
        this.tableParam_ = new StringParameter("dbtable");
        this.tableParam_.setPrompt("Name of table to write to database");
        this.tableParam_.setUsage("<table-name>");
        this.tableParam_.setDescription(new String[]{"<p>The name of the table which will be written to the", "database.", "</p>"});
        Object[] modes = WriteMode.getAllModes();
        this.writeParam_ = new ChoiceParameter("write", modes);
        this.writeParam_.setPrompt("Mode for writing to the database table");
        this.writeParam_.setDefaultOption((Object)WriteMode.CREATE);
        StringBuffer descrip = new StringBuffer().append("<p>Controls how the values are written to a table ").append("in the database. ").append("The options are:\n").append("<ul>\n");
        for (int i = 0; i < modes.length; ++i) {
            descrip.append("<li><code>").append(modes[i].toString()).append("</code>: ").append(modes[i].getDescription()).append("</li>").append("\n");
        }
        descrip.append("</ul>\n").append("</p>");
        this.writeParam_.setDescription(descrip.toString());
        this.userParam_ = new StringParameter("user");
        this.userParam_.setPrompt("Username for SQL connection");
        this.userParam_.setUsage("<username>");
        this.userParam_.setNullPermitted(true);
        this.userParam_.setPreferExplicit(true);
        try {
            this.userParam_.setStringDefault(System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.userParam_.setDescription(new String[]{"<p>User name for the SQL connection to the database.", "</p>"});
        this.passwdParam_ = new StringParameter("password");
        this.passwdParam_.setPrompt("Password for SQL connection");
        this.passwdParam_.setUsage("<passwd>");
        this.passwdParam_.setNullPermitted(true);
        this.passwdParam_.setPreferExplicit(true);
        this.passwdParam_.setDescription(new String[]{"<p>Password for the SQL connection to the database.", "</p>"});
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[]{this.protoParam_, this.hostParam_, this.dbParam_, this.tableParam_, this.writeParam_, this.userParam_, this.passwdParam_};
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Writes a new table to an SQL database.", "You need the appropriate JDBC drivers and", "<code>-Djdbc.drivers</code> set as usual", "(see <ref id=\"jdbcConfig\"/>).", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        String url = "jdbc:" + this.protoParam_.stringValue(env) + "://" + this.hostParam_.stringValue(env) + "/" + this.dbParam_.stringValue(env) + "#" + this.tableParam_.stringValue(env);
        logger_.info("JDBC URL: " + url);
        final String user = this.userParam_.stringValue(env);
        final String passwd = this.passwdParam_.stringValue(env);
        WriteMode mode = (WriteMode)this.writeParam_.objectValue(env);
        JDBCAuthenticator auth = new JDBCAuthenticator(){

            public String[] authenticate() {
                return new String[]{user, passwd};
            }
        };
        return new JdbcConsumer(url, new JDBCHandler(auth), mode);
    }
}

