/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Area;
import uk.ac.starlink.ttools.AreaDomain;
import uk.ac.starlink.ttools.AreaMapper;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.func.Coverage;
import uk.ac.starlink.ttools.jel.JELQuantity;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.moc.MocBuilder;
import uk.ac.starlink.ttools.moc.MocImpl;
import uk.ac.starlink.ttools.moc.MocStreamFormat;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.util.Destination;

public class MocShapeMode
implements ProcessingMode {
    private final IntegerParameter orderParam_ = new IntegerParameter("order");
    private final StringParameter coordsParam_;
    private final ChoiceParameter<AreaMapper> shapeParam_;
    private final ChoiceParameter<MocStreamFormat> mocfmtParam_;
    private final ChoiceParameter<MocImpl> mocimplParam_;
    private final OutputStreamParameter outParam_;
    private static final int MAX_ORDER = 29;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.mode");

    public MocShapeMode() {
        this.orderParam_.setPrompt("MOC Healpix maximum order");
        this.orderParam_.setUsage("0..29");
        this.orderParam_.setMaximum(29);
        int orderDflt = 10;
        int dfltResArcmin = (int)Math.round(3520.0 * Math.pow(2.0, -orderDflt));
        assert (dfltResArcmin > 0 && dfltResArcmin < 5000);
        this.orderParam_.setIntDefault(orderDflt);
        this.orderParam_.setDescription(new String[]{"<p>Maximum HEALPix order for the MOC.", "This defines the maximum resolution of the output coverage map.", "The angular resolution corresponding to order <em>k</em>", "is approximately 180/sqrt(3.Pi)/2^<em>k</em> degrees", "(3520*2^<em>-k</em> arcmin).", "Permitted values are 0..29 inclusive.", "The default value is " + orderDflt + ", which corresponds to", "about " + dfltResArcmin + " arcmin.", "</p>"});
        String coordsName = "coords";
        String shapeName = "shape";
        this.coordsParam_ = new StringParameter(coordsName);
        this.coordsParam_.setUsage("<expr>");
        this.coordsParam_.setPrompt("Coordinate array column or expression");
        this.coordsParam_.setDescription(new String[]{"<p>Name of the column or an array expression", "giving the coordinates of the shape in each row to add", "to the MOC.", "The type and semantics of this value", "(the type of shape represented)", "are defined by the <code>" + shapeName + "</code> parameter.", "</p>"});
        ArrayList<AreaMapper> areaMappers = new ArrayList<AreaMapper>(Arrays.asList(AreaDomain.INSTANCE.getMappers()));
        areaMappers.remove(AreaDomain.TFCAT_MAPPER);
        this.shapeParam_ = new ChoiceParameter(shapeName, AreaMapper.class, (Object[])areaMappers.toArray(new AreaMapper[0]));
        this.shapeParam_.setPrompt("Coordinate shape type");
        this.shapeParam_.setDescription(new String[]{"<p>Defines the interpretation of the", "<code>" + coordsName + "</code> parameter,", "i.e. the type of shape defined by the supplied coordinates.", "</p>", "<p>The options are:", DocUtils.describedList(areaMappers, AreaMapper::toString, AreaMapper::getSkySourceDescription, true), "If a blank value is supplied (the default)", "an attempt will be made to guess the shape type given the", "supplied coordinate column; if no good guess can be made,", "an error will result.", "</p>"});
        this.shapeParam_.setNullPermitted(true);
        this.mocfmtParam_ = new ChoiceParameter("mocfmt", (Object[])MocStreamFormat.FORMATS);
        this.mocfmtParam_.setPrompt("Output format for MOC file");
        this.mocfmtParam_.setDescription(new String[]{"<p>Determines the output format for the MOC file.", "</p>"});
        this.mocfmtParam_.setDefaultOption((Object)MocStreamFormat.ASCII);
        Object[] mocImpls = new MocImpl[]{MocImpl.AUTO, MocImpl.CDS, MocImpl.BITSET, MocImpl.LIST};
        this.mocimplParam_ = new ChoiceParameter("mocimpl", mocImpls);
        this.mocimplParam_.setPrompt("MOC builder implementation");
        this.mocimplParam_.setDescription(new String[]{"<p>Controls how the MOC is built.", "You can generally leave this alone, but if you find performance", "is slow, or you are running out of memory, it may be worth", "experimenting with the options.", DocUtils.describedList(mocImpls, MocImpl::getName, MocImpl::getDescription, true), "</p>"});
        this.mocimplParam_.setDefaultOption((Object)MocImpl.AUTO);
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPrompt("Location of output MOC file");
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[]{this.orderParam_, this.coordsParam_, this.shapeParam_, this.mocfmtParam_, this.mocimplParam_, this.outParam_};
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Generates and outputs a Multi-Order Coverage map from", "sky shapes associated with the rows of the input table.", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        int order = this.orderParam_.intValue(env);
        String coordsExpr = this.coordsParam_.stringValue(env);
        AreaMapper shapeMapper0 = (AreaMapper)this.shapeParam_.objectValue(env);
        MocImpl mocimpl = (MocImpl)this.mocimplParam_.objectValue(env);
        MocStreamFormat mocfmt = (MocStreamFormat)this.mocfmtParam_.objectValue(env);
        MocBuilder mocBuilder = mocimpl.createMocBuilder(order);
        HealpixNested hpx = Healpix.getNested((int)order);
        Destination dest = (Destination)this.outParam_.objectValue(env);
        return table -> {
            JELQuantity coordQuantity;
            SequentialJELRowReader rdr = new SequentialJELRowReader(table);
            try {
                coordQuantity = JELUtils.compileQuantity(JELUtils.getLibrary(rdr), rdr, coordsExpr, Object.class);
            }
            catch (CompilationException e) {
                throw new IOException("Bad expression " + e.getMessage());
            }
            CompiledExpression coordCompex = coordQuantity.getCompiledExpression();
            ValueInfo coordInfo = coordQuantity.getValueInfo();
            AreaMapper shapeMapper = shapeMapper0 != null ? shapeMapper0 : AreaDomain.INSTANCE.getProbableMapper(coordInfo);
            if (shapeMapper == null) {
                throw new IOException("Can't guess shape type; please supply value for " + this.shapeParam_.getName() + " parameter");
            }
            Class coordClazz = coordInfo.getContentClass();
            Function<Object, Area> areaFunc = shapeMapper.areaFunction(coordClazz);
            if (areaFunc == null) {
                throw new IOException("Quantity " + coordsExpr + "(" + coordClazz.getSimpleName() + ") is not compatible with type " + shapeMapper.getSourceName());
            }
            while (rdr.next()) {
                Object coords;
                try {
                    coords = rdr.evaluate(coordCompex);
                }
                catch (Throwable e) {
                    throw new IOException("Evaluation error for " + coordsExpr, e);
                }
                Area area = areaFunc.apply(coords);
                if (area == null) continue;
                for (long uniq : area.toMocUniqs(order)) {
                    mocBuilder.addTile(Coverage.uniqToOrder(uniq), Coverage.uniqToIndex(uniq));
                }
            }
            rdr.close();
            mocBuilder.endTiles();
            long[] orderCounts = mocBuilder.getOrderCounts();
            long ntile = 0L;
            double cov = 0.0;
            for (int io = 0; io < orderCounts.length; ++io) {
                ntile += orderCounts[io];
                cov += (double)orderCounts[io] * 1.0 / (double)(12L << 2 * io);
            }
            if (logger_.isLoggable(Level.INFO)) {
                logger_.info("MOC: size=" + ntile + ", coverage=" + cov);
            }
            int maxOrder = orderCounts.length - 1;
            try (OutputStream out = dest.createStream();){
                mocfmt.writeMoc(mocBuilder.createOrderedUniqIterator(), ntile, maxOrder, out);
            }
        };
    }
}

