/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import uk.ac.starlink.table.BeanStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.TextTableWriter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.filter.KeepColumnFilter;
import uk.ac.starlink.ttools.filter.StatsFilter;
import uk.ac.starlink.ttools.mode.ColStats;
import uk.ac.starlink.ttools.mode.ProcessingMode;

public class StatsMode
implements ProcessingMode {
    private final boolean isParallel_;
    private static final ValueInfo ROWCOUNT_INFO = new DefaultValueInfo("Total Rows", Long.class);

    public StatsMode() {
        this(true);
    }

    public StatsMode(boolean isParallel) {
        this.isParallel_ = isParallel;
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[0];
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Calculates and displays univariate statistics for each", "of the numeric columns in the table.", "The following entries are shown for each column as appropriate:", "<ul>", "<li>mean</li>", "<li>population standard deviation</li>", "<li>minimum</li>", "<li>maximum</li>", "<li>number of non-null entries</li>", "</ul>", "</p>", "<p>See the " + DocUtils.filterRef(new StatsFilter()) + " filter", "for more flexible statistical calculations.", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) {
        final PrintStream out = env.getOutputStream();
        final RowRunner runner = this.isParallel_ ? RowRunner.DEFAULT : RowRunner.SEQUENTIAL;
        return new TableConsumer(){

            @Override
            public void consume(StarTable table) throws IOException {
                new TextTableWriter().writeStarTable(StatsMode.makeStatsTable(table, runner), (OutputStream)out);
            }
        };
    }

    private static StarTable makeStatsTable(StarTable table, RowRunner runner) throws IOException {
        BeanStarTable statsTable;
        StatsCollector collector = new StatsCollector(Tables.getColumnInfos((StarTable)table));
        TableStats tstats = (TableStats)runner.collect((RowCollector)collector, table);
        long nrow = tstats.nrow_;
        try {
            statsTable = new BeanStarTable(ColStats.class);
        }
        catch (IntrospectionException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Introspection Error???"))).initCause(e));
        }
        statsTable.setData((Object[])tstats.colStats_);
        String columns = "column mean stdDev min max good ";
        statsTable = KeepColumnFilter.keepColumnTable((StarTable)statsTable, columns);
        statsTable.setParameter(new DescribedValue(ROWCOUNT_INFO, (Object)nrow));
        return statsTable;
    }

    private static class StatsCollector
    extends RowCollector<TableStats> {
        private final ColumnInfo[] infos_;
        private final int nc_;

        StatsCollector(ColumnInfo[] infos) {
            this.infos_ = infos;
            this.nc_ = infos.length;
        }

        public TableStats createAccumulator() {
            return new TableStats(this.infos_);
        }

        public TableStats combine(TableStats tstats1, TableStats tstats2) {
            tstats1.addStats(tstats2);
            return tstats1;
        }

        public void accumulateRows(RowSplittable rseq, TableStats tstats) throws IOException {
            ColStats[] cstats = tstats.colStats_;
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int ic = 0; ic < this.nc_; ++ic) {
                    cstats[ic].acceptDatum(row[ic]);
                }
                ++tstats.nrow_;
            }
        }
    }

    private static class TableStats {
        final int nc_;
        final ColStats[] colStats_;
        long nrow_;

        TableStats(ColumnInfo[] infos) {
            this.nc_ = infos.length;
            this.colStats_ = new ColStats[this.nc_];
            for (int ic = 0; ic < this.nc_; ++ic) {
                this.colStats_[ic] = ColStats.makeColStats(infos[ic]);
            }
        }

        void addStats(TableStats other) {
            this.nrow_ += other.nrow_;
            for (int ic = 0; ic < this.nc_; ++ic) {
                this.colStats_[ic].addStats(other.colStats_[ic]);
            }
        }
    }
}

