/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.DefaultStyle;

public class BarStyle
extends DefaultStyle
implements Icon {
    private final Form form_;
    private final Placement placement_;
    private static final int ICON_HEIGHT = 12;
    private static final int ICON_WIDTH = 8;
    private static final float BODY_FADE = 0.25f;
    private static final float LINE_FADE = 0.5f;
    public static final Form FORM_OPEN = new Form("Open", true){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            int thickness = g2.getStroke() instanceof BasicStroke ? (int)((BasicStroke)g2.getStroke()).getLineWidth() : 1;
            int x0 = x + thickness / 2;
            int y0 = y + height;
            int x1 = x + width - 1 - (thickness + 1) / 2;
            int y1 = y;
            int[] xp = new int[]{x0, x0, x1, x1};
            int[] yp = new int[]{y0, y1, y1, y0};
            g2.drawPolyline(xp, yp, 4);
        }
    };
    public static final Form FORM_FILLED = new Form("Filled", true){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            g.fillRect(x, y, Math.max(width - 1, 1), height);
        }
    };
    public static final Form FORM_FILLED3D = new Form("Filled 3D", true){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            g.fill3DRect(x, y, Math.max(width - 1, 1), height, true);
        }
    };
    public static final Form FORM_TOP = new Form("Steps", true){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            g.drawLine(x, y, x + width, y);
        }

        @Override
        public void drawEdge(Graphics g, int x, int y1, int y2) {
            g.drawLine(x, y1, x, y2);
        }
    };
    public static final Form FORM_SPIKE = new Form("Spikes", true){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setStroke(DefaultStyle.getStroke(g2.getStroke(), 1, 0));
            int xpos = x + width / 2;
            g2.drawLine(xpos, y + height, xpos, y);
        }
    };
    public static final Form FORM_SEMIFILLED = new Form("Semi Filled", false){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            Color color0 = g2.getColor();
            g2.setColor(BarStyle.fade(color0, 0.25f));
            g2.fillRect(x, y, width, height + 1);
            int thickness = g2.getStroke() instanceof BasicStroke ? (int)((BasicStroke)g2.getStroke()).getLineWidth() : 1;
            int x0 = x;
            int y0 = y + height;
            int x1 = x0 + width;
            int y1 = y;
            int[] xp = new int[]{x0, x0, x1, x1};
            int[] yp = new int[]{y0, y1, y1, y0};
            g2.setColor(BarStyle.fade(color0, 0.5f));
            g2.drawPolyline(xp, yp, 4);
            g2.setColor(color0);
        }
    };
    public static final Form FORM_SEMITOP = new Form("Semi Steps", false){

        @Override
        public void drawBar(Graphics g, int x, int y, int width, int height) {
            Color color0 = g.getColor();
            g.setColor(BarStyle.fade(color0, 0.25f));
            g.fillRect(x, y, width, height + 1);
            g.setColor(BarStyle.fade(color0, 0.5f));
            g.drawLine(x, y, x + width, y);
            g.setColor(color0);
        }

        @Override
        public void drawEdge(Graphics g, int x, int y1, int y2) {
            Color color0 = g.getColor();
            g.setColor(BarStyle.fade(color0, 0.5f));
            g.drawLine(x, y1, x, y2);
            g.setColor(color0);
        }
    };
    public static final Placement PLACE_ADJACENT = new Placement("adjacent"){

        @Override
        public int[] getXRange(int lo, int hi, int iseq, int nseq) {
            int gap = (hi - lo - 2) / nseq;
            int rlo = lo + 1 + gap * iseq;
            int rhi = rlo + gap + 1;
            return new int[]{rlo, rhi};
        }
    };
    public static final Placement PLACE_OVER = new Placement("over"){

        @Override
        public int[] getXRange(int lo, int hi, int iseq, int nseq) {
            return new int[]{lo, hi};
        }
    };

    public BarStyle(Color color, Form form, Placement placement) {
        super(color, Arrays.asList(form, placement));
        this.setLineWidth(2);
        this.form_ = form;
        this.placement_ = placement;
    }

    public void drawBar(Graphics g, int xlo, int xhi, int ylo, int yhi, int iseq, int nseq) {
        Graphics2D g2 = (Graphics2D)g;
        Color col = g.getColor();
        Stroke str = g2.getStroke();
        g.setColor(this.getColor());
        g2.setStroke(this.getStroke(2, 0));
        int[] xRange = this.placement_.getXRange(xlo, xhi, iseq, nseq);
        int x = xRange[0];
        int width = xRange[1] - xRange[0];
        this.form_.drawBar(g, xRange[0], ylo, xRange[1] - xRange[0], yhi - ylo);
        g.setColor(col);
        g2.setStroke(str);
    }

    public void drawEdge(Graphics g, int x, int y1, int y2, int iseq, int nseq) {
        Graphics2D g2 = (Graphics2D)g;
        Color col = g.getColor();
        Stroke str = g2.getStroke();
        g.setColor(this.getColor());
        g2.setStroke(this.getStroke(2, 0));
        this.form_.drawEdge(g, x, y1, y2);
        g.setColor(col);
        g2.setStroke(str);
    }

    public Form getForm() {
        return this.form_;
    }

    public Placement getPlacement() {
        return this.placement_;
    }

    @Override
    public Icon getLegendIcon() {
        return this;
    }

    @Override
    public int getIconHeight() {
        return 12;
    }

    @Override
    public int getIconWidth() {
        return 8;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int x0 = x;
        int x1 = x + 8;
        int y0 = y;
        int y1 = y + 12;
        int iseq = 1;
        int nseq = 3;
        this.drawEdge(g, x0, y0, y1, iseq, nseq);
        this.drawBar(g, x0, x1, y0, y1, iseq, nseq);
        this.drawEdge(g, x1, y0, y1, iseq, nseq);
    }

    private static Color fade(Color color, float alpha) {
        float[] rgba = color.getComponents(null);
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3] * alpha);
    }

    public static abstract class Placement {
        private final String name_;

        protected Placement(String name) {
            this.name_ = name;
        }

        public abstract int[] getXRange(int var1, int var2, int var3, int var4);

        public String toString() {
            return this.name_;
        }
    }

    public static abstract class Form {
        private final String name_;
        private final boolean isOpaque_;

        protected Form(String name, boolean isOpaque) {
            this.name_ = name;
            this.isOpaque_ = isOpaque;
        }

        public abstract void drawBar(Graphics var1, int var2, int var3, int var4, int var5);

        public void drawEdge(Graphics g, int x, int y1, int y2) {
        }

        public boolean isOpaque() {
            return this.isOpaque_;
        }

        public String toString() {
            return this.name_;
        }
    }
}

