/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Arrays;

public class BinGrid {
    private final int xsize_;
    private final int ysize_;
    private final int npix_;
    private final double[] sums_;
    private double minSum_;
    private double maxSum_;
    private double[] blockSorted_;

    public BinGrid(int xsize, int ysize) {
        this.xsize_ = xsize;
        this.ysize_ = ysize;
        this.npix_ = this.xsize_ * this.ysize_;
        this.sums_ = new double[this.npix_];
    }

    public int getSizeX() {
        return this.xsize_;
    }

    public int getSizeY() {
        return this.ysize_;
    }

    public double getSum(int ix, int iy) {
        return this.sums_[this.getIndex(ix, iy)];
    }

    public double getMaxSum() {
        return this.maxSum_;
    }

    public double getMinSum() {
        return this.minSum_;
    }

    public double getCut(double frac) {
        if (frac < 0.0 || frac > 1.0) {
            throw new IllegalArgumentException();
        }
        double[] blox = this.getBlockSorted();
        int index = (int)((double)blox.length * frac);
        return blox[index];
    }

    private double[] getBlockSorted() {
        if (this.blockSorted_ == null) {
            double[] sorted = (double[])this.sums_.clone();
            Arrays.sort(sorted);
            int blockSize = Math.max(1, this.npix_ / 1000);
            int nblock = this.npix_ / blockSize;
            int b2 = blockSize / 2;
            double[] blocked = new double[nblock];
            boolean ipix = false;
            for (int ib = 0; ib < nblock; ++ib) {
                int ip = Math.min(ib * blockSize + b2, this.npix_ - 1);
                blocked[ib] = sorted[ip];
            }
            this.blockSorted_ = blocked;
        }
        return this.blockSorted_;
    }

    public void submitDatum(int ix, int iy, double weight) {
        int ip = this.getIndex(ix, iy);
        double sum = this.sums_[ip];
        this.sums_[ip] = sum += weight;
        this.minSum_ = Math.min(this.minSum_, sum);
        this.maxSum_ = Math.max(this.maxSum_, sum);
    }

    public void recalculate() {
        this.minSum_ = 0.0;
        this.maxSum_ = 0.0;
        for (int ip = 0; ip < this.npix_; ++ip) {
            double sum = this.sums_[ip];
            this.minSum_ = Math.min(this.minSum_, sum);
            this.maxSum_ = Math.max(this.maxSum_, sum);
        }
    }

    public byte[] getBytes(double loCut, double hiCut, boolean log) {
        double scale1 = log ? Math.log(hiCut / loCut) : hiCut - loCut;
        double scale = 255.0 / scale1;
        byte[] buf = new byte[this.npix_];
        for (int ipix = 0; ipix < this.npix_; ++ipix) {
            int ival;
            double sum = this.sums_[ipix];
            if (sum <= loCut) {
                ival = 0;
            } else if (sum >= hiCut) {
                ival = 255;
            } else {
                double val = log ? Math.log(sum / loCut) : sum - loCut;
                ival = (int)(val * scale);
            }
            buf[ipix] = (byte)ival;
        }
        return buf;
    }

    public double[] getSums() {
        return this.sums_;
    }

    private int getIndex(int ix, int iy) {
        return ix + this.xsize_ * (this.ysize_ - 1 - iy);
    }
}

