/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.BitSet;
import uk.ac.starlink.ttools.plot.Pixellator;

public class Drawing
implements Pixellator {
    private final BitSet pixelMask_;
    private final Rectangle bounds_;
    private int nextPointKey_ = Integer.MAX_VALUE;
    private Point point_;
    private static final Stroke STROKE = new BasicStroke();

    public Drawing(Rectangle bounds) {
        this.bounds_ = bounds;
        this.pixelMask_ = new BitSet(bounds.width * bounds.height);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.bounds_);
    }

    public void addPixel(int x, int y) {
        if (this.bounds_.contains(x, y)) {
            int xoff = x - this.bounds_.x;
            int yoff = y - this.bounds_.y;
            int packed = xoff + this.bounds_.width * yoff;
            assert (packed >= 0 && packed < this.bounds_.width * this.bounds_.height);
            this.pixelMask_.set(packed);
        }
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        if (x0 == x1) {
            int x = x0;
            if (y0 > y1) {
                int y2 = y1;
                y1 = y0;
                y0 = y2;
            }
            int ya = Math.max(y0, this.bounds_.y);
            int yb = Math.min(y1, this.bounds_.y + this.bounds_.height);
            for (int y = ya; y <= yb; ++y) {
                this.addPixel(x, y);
            }
        } else if (y0 == y1) {
            int y = y0;
            if (x0 > x1) {
                int x2 = x1;
                x1 = x0;
                x0 = x2;
            }
            int xa = Math.max(x0, this.bounds_.x);
            int xb = Math.min(x1, this.bounds_.x + this.bounds_.width);
            for (int x = xa; x <= xb; ++x) {
                this.addPixel(x, y);
            }
        } else if (Math.abs(x1 - x0) > Math.abs(y1 - y0)) {
            if (x0 > x1) {
                int x2 = x1;
                int y2 = y1;
                x1 = x0;
                y1 = y0;
                x0 = x2;
                y0 = y2;
            }
            double slope = (double)(y1 - y0) / (double)(x1 - x0);
            int xa = Math.max(x0, this.bounds_.x);
            int xb = Math.min(x1, this.bounds_.x + this.bounds_.width);
            for (int x = xa; x <= xb; ++x) {
                this.addPixel(x, y0 + (int)Math.round((double)(x - x0) * slope));
            }
        } else {
            assert (Math.abs(x1 - x0) <= Math.abs(y1 - y0));
            if (y0 > y1) {
                int x2 = x1;
                int y2 = y1;
                x1 = x0;
                y1 = y0;
                x0 = x2;
                y0 = y2;
            }
            double slope = (double)(x1 - x0) / (double)(y1 - y0);
            int ya = Math.max(y0, this.bounds_.y);
            int yb = Math.min(y1, this.bounds_.y + this.bounds_.height);
            for (int y = ya; y <= yb; ++y) {
                this.addPixel(x0 + (int)Math.round((double)(y - y0) * slope), y);
            }
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        int xlo = Math.max(this.bounds_.x, x);
        int xhi = Math.min(this.bounds_.x + this.bounds_.width, x + width);
        int ylo = Math.max(this.bounds_.y, y);
        int yhi = Math.min(this.bounds_.y + this.bounds_.height, y + height);
        if (xlo < xhi && ylo < yhi) {
            for (int ix = xlo; ix < xhi; ++ix) {
                for (int iy = ylo; iy < yhi; ++iy) {
                    this.addPixel(ix, iy);
                }
            }
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        int a = width / 2;
        int b = height / 2;
        double a2r = 1.0 / ((double)a * (double)a);
        double b2r = 1.0 / ((double)b * (double)b);
        int x0 = x + a;
        int y0 = y + b;
        int xp = x0 - this.bounds_.x;
        int xq = this.bounds_.x + this.bounds_.width - x0;
        if (xp < 0) {
            xmin = -xp;
            xmax = xq;
        } else if (xq < 0) {
            xmin = -xq;
            xmax = xp;
        } else {
            xmin = 0;
            xmax = Math.min(a, Math.max(xp, xq));
        }
        int lasty = 0;
        for (int ix = xmin; ix < xmax; ++ix) {
            int iy = (int)Math.round((double)b * Math.sqrt(1.0 - a2r * (double)ix * (double)ix));
            this.addPixel(x0 + ix, y0 + iy);
            this.addPixel(x0 + ix, y0 - iy);
            this.addPixel(x0 - ix, y0 + iy);
            this.addPixel(x0 - ix, y0 - iy);
            if (lasty - iy > 1) break;
            lasty = iy;
        }
        int yp = y0 - this.bounds_.y;
        int yq = this.bounds_.y + this.bounds_.height - y0;
        if (yp < 0) {
            ymin = -yp;
            ymax = yq;
        } else if (yq < 0) {
            ymin = -yq;
            ymax = yp;
        } else {
            ymin = 0;
            ymax = Math.min(b, Math.max(yp, yq));
        }
        int lastx = 0;
        for (int iy = ymin; iy < ymax; ++iy) {
            int ix = (int)Math.round((double)a * Math.sqrt(1.0 - b2r * (double)iy * (double)iy));
            this.addPixel(x0 + ix, y0 + iy);
            this.addPixel(x0 + ix, y0 - iy);
            this.addPixel(x0 - ix, y0 + iy);
            this.addPixel(x0 - ix, y0 - iy);
            if (lastx - ix > 1) break;
            lastx = ix;
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        int a = width / 2;
        int b = height / 2;
        int x0 = x + a;
        int y0 = y + b;
        int xlo = Math.max(this.bounds_.x, x);
        int xhi = Math.min(this.bounds_.x + this.bounds_.width, x + width);
        int ylo = Math.max(this.bounds_.y, y);
        int yhi = Math.min(this.bounds_.y + this.bounds_.height, y + height);
        double a2 = (double)a * (double)a;
        double b2 = (double)b * (double)b;
        double a2b2 = a2 * b2;
        for (int ix = xlo; ix <= xhi; ++ix) {
            int jx = ix - x0;
            double jxb2 = b2 * (double)jx * (double)jx;
            for (int iy = ylo; iy <= yhi; ++iy) {
                int jy = iy - y0;
                double jya2 = a2 * (double)jy * (double)jy;
                if (!(jxb2 + jya2 <= a2b2)) continue;
                this.addPixel(ix, iy);
            }
        }
    }

    public void drawEllipse(int x0, int y0, int ax, int ay, int bx, int by) {
        double a2r;
        double cC;
        double cB;
        double cA;
        int xmax = Math.abs(ax) + Math.abs(bx);
        int ymax = Math.abs(ay) + Math.abs(by);
        int xlo = Math.max(x0 - xmax, this.bounds_.x);
        int xhi = Math.min(x0 + xmax, this.bounds_.x + this.bounds_.width);
        int ylo = Math.max(y0 - ymax, this.bounds_.y);
        int yhi = Math.min(y0 + ymax, this.bounds_.y + this.bounds_.height);
        double kxx = (double)ay * (double)ay + (double)by * (double)by;
        double kxy = -2.0 * ((double)ax * (double)ay + (double)bx * (double)by);
        double kyy = (double)ax * (double)ax + (double)bx * (double)bx;
        double r1 = (double)ax * (double)by - (double)bx * (double)ay;
        double r2 = r1 * r1;
        for (int x = xlo; x <= xhi; ++x) {
            double x1 = x - x0;
            double x2 = x1 * x1;
            cA = kyy;
            cB = kxy * x1;
            cC = kxx * x2 - r2;
            a2r = 0.5 / cA;
            double yz = (double)y0 - cB * a2r;
            double yd = Math.sqrt(cB * cB - 4.0 * cA * cC) * a2r;
            if (Double.isNaN(yd)) continue;
            this.addPixel(x, (int)Math.round(yz - yd));
            this.addPixel(x, (int)Math.round(yz + yd));
        }
        for (int y = ylo; y <= yhi; ++y) {
            double y1 = y - y0;
            double y2 = y1 * y1;
            cA = kxx;
            cB = kxy * y1;
            cC = kyy * y2 - r2;
            a2r = 0.5 / cA;
            double xz = (double)x0 - cB * a2r;
            double xd = Math.sqrt(cB * cB - 4.0 * cA * cC) * a2r;
            if (Double.isNaN(xd)) continue;
            this.addPixel((int)Math.round(xz - xd), y);
            this.addPixel((int)Math.round(xz + xd), y);
        }
    }

    public void fillEllipse(int x0, int y0, int ax, int ay, int bx, int by) {
        int xmax = Math.abs(ax) + Math.abs(bx);
        int ymax = Math.abs(ay) + Math.abs(by);
        int xlo = Math.max(x0 - xmax, this.bounds_.x);
        int xhi = Math.min(x0 + xmax, this.bounds_.x + this.bounds_.width);
        int ylo = Math.max(y0 - ymax, this.bounds_.y);
        int yhi = Math.min(y0 + ymax, this.bounds_.y + this.bounds_.height);
        double kxx = (double)ay * (double)ay + (double)by * (double)by;
        double kxy = -2.0 * ((double)ax * (double)ay + (double)bx * (double)by);
        double kyy = (double)ax * (double)ax + (double)bx * (double)bx;
        double r = (double)ax * (double)by - (double)bx * (double)ay;
        double r2 = r * r;
        if (xhi - xlo > 0 && yhi - ylo > 0) {
            for (int x = xlo; x <= xhi; ++x) {
                double x1 = x - x0;
                double x2 = x1 * x1;
                for (int y = ylo; y <= yhi; ++y) {
                    double y1 = y - y0;
                    double y2 = y1 * y1;
                    if (!(kxx * x2 + kxy * x1 * y1 + kyy * y2 <= r2)) continue;
                    this.addPixel(x, y);
                }
            }
        }
    }

    public void fill(Shape shape) {
        Rectangle box = shape.getBounds();
        int xlo = Math.max(this.bounds_.x, box.x);
        int xhi = Math.min(this.bounds_.x + this.bounds_.width, box.x + box.width);
        int ylo = Math.max(this.bounds_.y, box.y);
        int yhi = Math.min(this.bounds_.y + this.bounds_.height, box.y + box.height);
        if (xhi >= xlo && yhi >= ylo) {
            for (int x = xlo; x <= xhi; ++x) {
                double px = x;
                for (int y = ylo; y <= yhi; ++y) {
                    double py = y;
                    if (!shape.contains(px, py)) continue;
                    this.addPixel(x, y);
                }
            }
        }
    }

    public void draw(Shape shape) {
        this.fill(STROKE.createStrokedShape(shape));
    }

    public void addPixels(Pixellator pixellator) {
        pixellator.start();
        while (pixellator.next()) {
            this.addPixel(pixellator.getX(), pixellator.getY());
        }
    }

    @Override
    public void start() {
        this.point_ = new Point();
        this.nextPointKey_ = -1;
    }

    @Override
    public boolean next() {
        this.nextPointKey_ = this.pixelMask_.nextSetBit(this.nextPointKey_ + 1);
        if (this.nextPointKey_ >= 0) {
            this.point_.x = this.nextPointKey_ % this.bounds_.width + this.bounds_.x;
            this.point_.y = this.nextPointKey_ / this.bounds_.width + this.bounds_.y;
            return true;
        }
        this.point_ = null;
        this.nextPointKey_ = Integer.MAX_VALUE;
        return false;
    }

    @Override
    public int getX() {
        return this.point_.x;
    }

    @Override
    public int getY() {
        return this.point_.y;
    }

    public static Pixellator combinePixellators(Pixellator[] pixers) {
        Rectangle bounds = null;
        for (int is = 0; is < pixers.length; ++is) {
            Rectangle sbounds = pixers[is].getBounds();
            if (bounds != null) {
                if (sbounds == null) continue;
                bounds.add(new Rectangle(sbounds));
                continue;
            }
            bounds = new Rectangle(sbounds);
        }
        if (bounds == null) {
            return new Drawing(new Rectangle(0, 0, 0, 0)){

                @Override
                public Rectangle getBounds() {
                    return null;
                }
            };
        }
        Drawing union = new Drawing(bounds);
        for (int is = 0; is < pixers.length; ++is) {
            union.addPixels(pixers[is]);
        }
        return union;
    }
}

