/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

public class ErrorMode {
    private final String name_;
    private final Extent[] extents_;
    private final double loOff_;
    private final double hiOff_;
    public static final ErrorMode NONE;
    public static final ErrorMode SYMMETRIC;
    public static final ErrorMode LOWER;
    public static final ErrorMode UPPER;
    public static final ErrorMode BOTH;
    public static final Extent LOWER_EXTENT;
    public static final Extent UPPER_EXTENT;
    public static final Extent BOTH_EXTENT;
    private static final ErrorMode[] ALL_OPTIONS;

    private ErrorMode(String name, Extent[] extents, double loOff, double hiOff) {
        this.name_ = name;
        this.extents_ = (Extent[])extents.clone();
        this.loOff_ = loOff;
        this.hiOff_ = hiOff;
    }

    public Extent[] getExtents() {
        return (Extent[])this.extents_.clone();
    }

    public double getExampleLower() {
        return this.loOff_;
    }

    public double getExampleUpper() {
        return this.hiOff_;
    }

    public String toString() {
        return this.name_;
    }

    public static ErrorMode[] getOptions() {
        return (ErrorMode[])ALL_OPTIONS.clone();
    }

    public static boolean allBlank(ErrorMode[] modes) {
        if (modes == null) {
            return true;
        }
        for (int idim = 0; idim < modes.length; ++idim) {
            ErrorMode mode = modes[idim];
            if (mode == null || NONE.equals(mode)) continue;
            return false;
        }
        return true;
    }

    static {
        LOWER_EXTENT = new Extent("Lower", "-");
        UPPER_EXTENT = new Extent("Upper", "+");
        BOTH_EXTENT = new Extent("Both", "+/-");
        NONE = new ErrorMode("None", new Extent[0], 0.0, 0.0);
        SYMMETRIC = new ErrorMode("Symmetric", new Extent[]{BOTH_EXTENT}, 1.0, 1.0);
        LOWER = new ErrorMode("Lower Only", new Extent[]{LOWER_EXTENT}, 1.0, 0.0);
        UPPER = new ErrorMode("Upper Only", new Extent[]{UPPER_EXTENT}, 0.0, 1.0);
        BOTH = new ErrorMode("Lower & Upper", new Extent[]{LOWER_EXTENT, UPPER_EXTENT}, 1.0, 0.75);
        ALL_OPTIONS = new ErrorMode[]{NONE, SYMMETRIC, LOWER, UPPER, BOTH};
    }

    public static class Extent {
        private final String name_;
        private final String label_;

        private Extent(String name, String label) {
            this.name_ = name;
            this.label_ = label;
        }

        public String getName() {
            return this.name_;
        }

        public String getLabel() {
            return this.label_;
        }
    }
}

