/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Drawing;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.util.IconUtils;

public abstract class ErrorRenderer {
    private final String name_;
    public static final ErrorRenderer NONE = new Blank("None");
    public static final ErrorRenderer DEFAULT = new CappedLine("Lines", true, null);
    public static final ErrorRenderer EXAMPLE = new CappedLine("Capped Lines", true, new BarCapper(3));
    public static final ErrorRenderer TANGENT = new OpenEllipse("Ellipse", true);
    private static final ErrorRenderer[] OPTIONS_1D = new ErrorRenderer[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, new BarCapper(3)), new CappedLine("Arrows", true, new ArrowCapper(3))};
    private static final ErrorRenderer[] OPTIONS_2D = new ErrorRenderer[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, new BarCapper(3)), new CappedLine("Arrows", true, new ArrowCapper(3)), new OpenEllipse("Ellipse", false), new OpenEllipse("Crosshair Ellipse", true), new OpenRectangle("Rectangle", false), new OpenRectangle("Crosshair Rectangle", true), new FilledEllipse("Filled Ellipse"), new FilledRectangle("Filled Rectangle")};
    private static final ErrorRenderer[] OPTIONS_3D = new ErrorRenderer[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, new BarCapper(3)), new CappedLine("Arrows", true, new ArrowCapper(3)), new OpenCuboid("Cuboid"), new MultiPlaneRenderer(new OpenEllipse("Ellipse", false)), new MultiPlaneRenderer(new OpenEllipse("Crosshair Ellipse", true)), new MultiPlaneRenderer(new OpenRectangle("Rectangle", false)), new MultiPlaneRenderer(new OpenRectangle("Crosshair Rectangle", true)), new MultiPlaneRenderer(new FilledEllipse("Filled Ellipse")), new MultiPlaneRenderer(new FilledRectangle("Filled Rectangle"))};
    private static final ErrorRenderer[] OPTIONS_SPHERE = ErrorRenderer.spherizeRenderers(new ErrorRenderer[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Arrows", true, new ArrowCapper(3)), new OpenEllipse("Ellipse", false), new OpenEllipse("Crosshair Ellipse", true), new OpenRectangle("Rectangle", false), new OpenRectangle("Crosshair Rectangle", true), new FilledEllipse("Filled Ellipse"), new FilledRectangle("Filled Rectangle"), new OpenCuboid("Cuboid"), new Wrapper(new MultiPlaneRenderer(new OpenRectangle("Crosshair Rectangle", true))){

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 3;
        }
    }, new TangentRadialRenderer("Ellipse", new OpenEllipse("Ellipse", false), new CappedLine("Capped Lines", true, null)), new TangentRadialRenderer("Crosshair Ellipse", new OpenEllipse("Ellipse", true), new CappedLine("Capped Lines", true, null)), new TangentRadialRenderer("Filled Ellipse", new FilledEllipse("Ellipse"), new CappedLine("Capped Lines", true, null)), new TangentRadialRenderer("Capped Ellipse", new OpenEllipse("Ellipse", false), new CappedLine("Capped Lines", true, new BarCapper(3))), new TangentRadialRenderer("Capped Crosshair Ellipse", new OpenEllipse("Ellipse", true), new CappedLine("Capped Lines", true, new BarCapper(3))), new TangentRadialRenderer("Capped Filled Ellipse", new FilledEllipse("Ellipse"), new CappedLine("Capped Lines", true, new BarCapper(3)))});
    private static final ErrorRenderer[] OPTIONS_GENERAL = new ErrorRenderer[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, new BarCapper(3)), new CappedLine("Arrows", true, new ArrowCapper(3))};
    private static final ErrorRenderer[] OPTIONS_ELLIPSE = new ErrorRenderer[]{new OpenEllipse("Ellipse", false), new OpenEllipse("Crosshair Ellipse", true), new FilledEllipse("Filled Ellipse"), new OpenRectangle("Rectangle", false), new OpenRectangle("Crosshair Rectangle", true), new FilledRectangle("Filled Rectangle"), new Triangle("Open Triangle", false), new Triangle("Filled Triangle", true), DEFAULT, EXAMPLE, new CappedLine("Arrows", true, new ArrowCapper(3))};
    private static final ErrorRenderer[] OPTIONS_SIZEXY = new ErrorRenderer[]{new OpenRectangle("Open Rectangle", false), new FilledRectangle("Filled Rectangle"), new OpenRectangle("Crosshair Rectangle", true), new OpenEllipse("Open Ellipse", false), new FilledEllipse("Filled Ellipse"), new OpenEllipse("Crosshair Ellipse", true), DEFAULT, EXAMPLE};
    private static final ErrorRenderer[] OPTIONS_VECTOR = new ErrorRenderer[]{new CappedLine("Small Arrow", true, new ArrowCapper(3)), new CappedLine("Medium Arrow", true, new ArrowCapper(4)), new CappedLine("Large Arrow", true, new ArrowCapper(5)), new Dart("Small Open Dart", false, 2), new Dart("Medium Open Dart", false, 4), new Dart("Large Open Dart", false, 6), new Dart("Small Filled Dart", true, 2), new Dart("Medium Filled Dart", true, 4), new Dart("Large Filled Dart", true, 6), DEFAULT, EXAMPLE};
    private static final Stroke CAP_ROUND = new BasicStroke(1.0f, 1, 0);
    private static final Stroke CAP_BUTT = new BasicStroke(1.0f, 0, 0);
    private static final Iterator<int[][]> EMPTY_ITERATOR = new Iterator<int[][]>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int[][] next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new NoSuchElementException();
        }
    };
    private static final Pixellator NO_PIXELS = new Pixellator(){

        @Override
        public void start() {
        }

        @Override
        public Rectangle getBounds() {
            return null;
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public int getX() {
            throw new IllegalStateException();
        }

        @Override
        public int getY() {
            throw new IllegalStateException();
        }
    };
    private static final int LEGEND_WIDTH = 40;
    private static final int LEGEND_HEIGHT = 16;
    private static final int LEGEND_XPAD = 5;
    private static final int LEGEND_YPAD = 1;
    private static final int DUMMY_SIZE = 10000;

    protected ErrorRenderer(String name) {
        this.name_ = name;
    }

    public abstract Icon getLegendIcon();

    public abstract Icon getLegendIcon(ErrorMode[] var1, int var2, int var3, int var4, int var5);

    public String getName() {
        return this.name_;
    }

    public abstract boolean isBlank(ErrorMode[] var1);

    public abstract boolean supportsDimensionality(int var1);

    public abstract void drawErrors(Graphics var1, int var2, int var3, int[] var4, int[] var5);

    public abstract Rectangle getBounds(int var1, int var2, int[] var3, int[] var4);

    public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
        Rectangle bounds = this.getBounds(x, y, xoffs, yoffs).intersection(clip);
        int xdim = bounds.width;
        int ydim = bounds.height;
        if (xdim <= 0 || ydim <= 0) {
            return NO_PIXELS;
        }
        BufferedImage im = new BufferedImage(xdim, ydim, 2);
        Graphics2D g2 = im.createGraphics();
        g2.translate(-bounds.x, -bounds.y);
        g2.setClip(bounds);
        this.drawErrors(g2, x, y, xoffs, yoffs);
        Raster raster = im.getData();
        Drawing drawing = new Drawing(bounds);
        for (int ix = 0; ix < xdim; ++ix) {
            for (int iy = 0; iy < ydim; ++iy) {
                int alpha = raster.getSample(ix, iy, 3);
                assert (alpha == 0 || alpha == 255);
                if (alpha <= 0) continue;
                drawing.addPixel(ix + bounds.x, iy + bounds.y);
            }
        }
        return drawing;
    }

    public String toString() {
        return this.name_;
    }

    public static ErrorRenderer[] getOptions1d() {
        return (ErrorRenderer[])OPTIONS_1D.clone();
    }

    public static ErrorRenderer[] getOptions2d() {
        return (ErrorRenderer[])OPTIONS_2D.clone();
    }

    public static ErrorRenderer[] getOptions3d() {
        return (ErrorRenderer[])OPTIONS_3D.clone();
    }

    public static ErrorRenderer[] getOptionsSpherical() {
        return (ErrorRenderer[])OPTIONS_SPHERE.clone();
    }

    public static ErrorRenderer[] getOptionsGeneral() {
        return (ErrorRenderer[])OPTIONS_GENERAL.clone();
    }

    public static ErrorRenderer[] getOptionsEllipse() {
        return (ErrorRenderer[])OPTIONS_ELLIPSE.clone();
    }

    public static ErrorRenderer[] getOptionsSizeXY() {
        return (ErrorRenderer[])OPTIONS_SIZEXY.clone();
    }

    public static ErrorRenderer[] getOptionsVector() {
        return (ErrorRenderer[])OPTIONS_VECTOR.clone();
    }

    private static ErrorRenderer[] spherizeRenderers(ErrorRenderer[] rends) {
        for (int ir = 0; ir < rends.length; ++ir) {
            rends[ir] = ErrorRenderer.spherizeRenderer(rends[ir]);
        }
        return rends;
    }

    private static Dimension getApproxGraphicsSize(Graphics2D g) {
        Dimension size = g.getDeviceConfiguration().getBounds().getSize();
        return size.width > 1 && size.height > 1 ? size : new Dimension(10000, 10000);
    }

    private static ErrorRenderer spherizeRenderer(ErrorRenderer rend) {
        return new Wrapper(rend){

            @Override
            public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
                boolean hasRad;
                boolean hasTan = modes[0] != ErrorMode.NONE;
                boolean bl = hasRad = modes[2] != ErrorMode.NONE;
                ErrorMode[] smodes = hasTan && hasRad ? modes : (hasTan ? new ErrorMode[]{modes[0], modes[1]} : (hasRad ? new ErrorMode[]{modes[2]} : new ErrorMode[]{ErrorMode.NONE}));
                return super.getLegendIcon(smodes, width, height, xpad, ypad);
            }
        };
    }

    private static class Blank
    extends ErrorRenderer {
        private final Icon legend_ = IconUtils.emptyIcon((int)0, (int)0);

        Blank(String name) {
            super(name);
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return IconUtils.emptyIcon((int)width, (int)height);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return true;
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return true;
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            return NO_PIXELS;
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            return new Rectangle(x, y, 0, 0);
        }
    }

    private static class TangentRadialRenderer
    extends ErrorRenderer {
        private final ErrorRenderer tanRenderer_;
        private final ErrorRenderer radRenderer_;
        private final Icon legend_;
        private final int[] tanXoffs_;
        private final int[] tanYoffs_;
        private final int[] radXoffs_;
        private final int[] radYoffs_;

        TangentRadialRenderer(String name, ErrorRenderer tanRenderer, ErrorRenderer radRenderer) {
            super(name);
            this.tanRenderer_ = tanRenderer;
            this.radRenderer_ = radRenderer;
            this.legend_ = new ErrorRendererIcon(this, 3);
            this.tanXoffs_ = new int[4];
            this.tanYoffs_ = new int[4];
            this.radXoffs_ = new int[4];
            this.radYoffs_ = new int[4];
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 3;
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad, ypad);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            int ndim = xoffs.length / 2;
            if (ndim == 3) {
                this.splitOffs(xoffs, yoffs);
                Rectangle bounds = this.tanRenderer_.getBounds(x, y, this.tanXoffs_, this.tanYoffs_);
                bounds.add(this.radRenderer_.getBounds(x, y, this.radXoffs_, this.radYoffs_));
                return bounds;
            }
            return new Rectangle(x, y, 0, 0);
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            int ndim = xoffs.length / 2;
            if (ndim == 3) {
                this.splitOffs(xoffs, yoffs);
                this.radRenderer_.drawErrors(g, x, y, this.radXoffs_, this.radYoffs_);
                this.tanRenderer_.drawErrors(g, x, y, this.tanXoffs_, this.tanYoffs_);
            }
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            int ndim = xoffs.length / 2;
            if (ndim == 3) {
                this.splitOffs(xoffs, yoffs);
                Pixellator tanPixes = this.tanRenderer_.getPixels(clip, x, y, this.tanXoffs_, this.tanYoffs_);
                Pixellator radPixes = this.radRenderer_.getPixels(clip, x, y, this.radXoffs_, this.radYoffs_);
                return Drawing.combinePixellators(new Pixellator[]{radPixes, tanPixes});
            }
            return NO_PIXELS;
        }

        private final void splitOffs(int[] xoffs, int[] yoffs) {
            int i;
            for (i = 0; i < 4; ++i) {
                this.tanXoffs_[i] = xoffs[i];
                this.tanYoffs_[i] = yoffs[i];
            }
            for (i = 0; i < 2; ++i) {
                this.radXoffs_[i] = xoffs[i + 4];
                this.radYoffs_[i] = yoffs[i + 4];
            }
        }
    }

    private static class MultiPlaneRenderer
    extends ErrorRenderer {
        private final ErrorRenderer rend2d_;
        private final Icon legend_;

        MultiPlaneRenderer(ErrorRenderer rend2d) {
            super(rend2d.getName());
            this.rend2d_ = rend2d;
            this.legend_ = new ErrorRendererIcon(this, 3);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 3 || ndim < 3 && this.rend2d_.supportsDimensionality(ndim);
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad + width / 6, ypad + height / 6);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            Rectangle bounds = new Rectangle(x, y, 0, 0);
            Iterator<int[][]> it = this.get2dOffsets(xoffs, yoffs);
            while (it.hasNext()) {
                int[][] offs = it.next();
                bounds.add(this.rend2d_.getBounds(x, y, offs[0], offs[1]));
            }
            return bounds;
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            Iterator<int[][]> it = this.get2dOffsets(xoffs, yoffs);
            while (it.hasNext()) {
                int[][] offs = it.next();
                this.rend2d_.drawErrors(g, x, y, offs[0], offs[1]);
            }
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            Drawing drawing = new Drawing(clip);
            Iterator<int[][]> it = this.get2dOffsets(xoffs, yoffs);
            while (it.hasNext()) {
                int[][] offs = it.next();
                drawing.addPixels(this.rend2d_.getPixels(clip, x, y, offs[0], offs[1]));
            }
            return drawing;
        }

        private Iterator<int[][]> get2dOffsets(final int[] xoffs, final int[] yoffs) {
            int ndim = xoffs.length / 2;
            if (ndim < 3) {
                return Collections.singletonList(new int[][]{xoffs, yoffs}).iterator();
            }
            final int[] activeDims = new int[ndim];
            int iActiveDim = 0;
            for (int idim = 0; idim < ndim; ++idim) {
                int i2 = idim * 2;
                if (xoffs[i2 + 0] == 0 && yoffs[i2 + 0] == 0 && xoffs[i2 + 1] == 0 && yoffs[i2 + 0] == 0) continue;
                activeDims[iActiveDim++] = idim;
            }
            final int nActiveDim = iActiveDim;
            if (nActiveDim == 0) {
                return EMPTY_ITERATOR;
            }
            if (nActiveDim == 1) {
                int[][] offPairs = new int[2][2];
                int i2 = activeDims[0] * 2;
                offPairs[0][0] = xoffs[i2 + 0];
                offPairs[1][0] = yoffs[i2 + 0];
                offPairs[0][1] = xoffs[i2 + 1];
                offPairs[1][1] = yoffs[i2 + 1];
                return Collections.singletonList(offPairs).iterator();
            }
            assert (nActiveDim >= 2);
            return new Iterator<int[][]>(){
                int[][] offPairs = new int[2][4];
                boolean done;
                int iActive = 0;
                int jActive = 1;

                @Override
                public int[][] next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    int i2 = activeDims[this.iActive] * 2;
                    int j2 = activeDims[this.jActive] * 2;
                    if (++this.iActive >= this.jActive) {
                        this.iActive = 0;
                        if (++this.jActive >= nActiveDim) {
                            this.done = true;
                        }
                    }
                    this.offPairs[0][0] = xoffs[i2 + 0];
                    this.offPairs[1][0] = yoffs[i2 + 0];
                    this.offPairs[0][1] = xoffs[i2 + 1];
                    this.offPairs[1][1] = yoffs[i2 + 1];
                    this.offPairs[0][2] = xoffs[j2 + 0];
                    this.offPairs[1][2] = yoffs[j2 + 0];
                    this.offPairs[0][3] = xoffs[j2 + 1];
                    this.offPairs[1][3] = yoffs[j2 + 1];
                    return this.offPairs;
                }

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class OpenCuboid
    extends ErrorRenderer {
        private final Icon legendIcon_ = new ErrorRendererIcon(this, 3);

        OpenCuboid(String name) {
            super(name);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 3;
        }

        @Override
        public Icon getLegendIcon() {
            return this.legendIcon_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad + width / 6, ypad + height / 6);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(CAP_ROUND);
            int ndim = xoffs.length / 2;
            if (ndim == 1) {
                g.drawLine(x + xoffs[0], y + yoffs[0], x + xoffs[1], y + yoffs[1]);
            } else if (ndim == 2) {
                int x00 = x + xoffs[0] + xoffs[2];
                int x01 = x + xoffs[0] + xoffs[3];
                int x11 = x + xoffs[1] + xoffs[3];
                int x10 = x + xoffs[1] + xoffs[2];
                int y00 = y + yoffs[0] + yoffs[2];
                int y01 = y + yoffs[0] + yoffs[3];
                int y11 = y + yoffs[1] + yoffs[3];
                int y10 = y + yoffs[1] + yoffs[2];
                g.drawLine(x00, y00, x01, y01);
                g.drawLine(x01, y01, x11, y11);
                g.drawLine(x11, y11, x10, y10);
                g.drawLine(x10, y10, x00, y00);
            } else if (ndim == 3) {
                int x000 = x + xoffs[0] + xoffs[2] + xoffs[4];
                int x001 = x + xoffs[0] + xoffs[2] + xoffs[5];
                int x010 = x + xoffs[0] + xoffs[3] + xoffs[4];
                int x011 = x + xoffs[0] + xoffs[3] + xoffs[5];
                int x100 = x + xoffs[1] + xoffs[2] + xoffs[4];
                int x101 = x + xoffs[1] + xoffs[2] + xoffs[5];
                int x110 = x + xoffs[1] + xoffs[3] + xoffs[4];
                int x111 = x + xoffs[1] + xoffs[3] + xoffs[5];
                int y000 = y + yoffs[0] + yoffs[2] + yoffs[4];
                int y001 = y + yoffs[0] + yoffs[2] + yoffs[5];
                int y010 = y + yoffs[0] + yoffs[3] + yoffs[4];
                int y011 = y + yoffs[0] + yoffs[3] + yoffs[5];
                int y100 = y + yoffs[1] + yoffs[2] + yoffs[4];
                int y101 = y + yoffs[1] + yoffs[2] + yoffs[5];
                int y110 = y + yoffs[1] + yoffs[3] + yoffs[4];
                int y111 = y + yoffs[1] + yoffs[3] + yoffs[5];
                g.drawLine(x000, y000, x001, y001);
                g.drawLine(x000, y000, x010, y010);
                g.drawLine(x000, y000, x100, y100);
                g.drawLine(x001, y001, x011, y011);
                g.drawLine(x001, y001, x101, y101);
                g.drawLine(x010, y010, x011, y011);
                g.drawLine(x010, y010, x110, y110);
                g.drawLine(x100, y100, x101, y101);
                g.drawLine(x100, y100, x110, y110);
                g.drawLine(x011, y011, x111, y111);
                g.drawLine(x101, y101, x111, y111);
                g.drawLine(x110, y110, x111, y111);
            }
            g2.setStroke(oldStroke);
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            int xmin = 0;
            int xmax = 0;
            int ymin = 0;
            int ymax = 0;
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                xmin = Math.min(xmin, xoff);
                xmax = Math.max(xmax, xoff);
                ymin = Math.min(ymin, yoff);
                ymax = Math.max(ymax, yoff);
            }
            return new Rectangle(x + xmin, x + ymin, xmax - xmin, ymax - ymin);
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            int ndim = xoffs.length / 2;
            if (ndim == 1) {
                Drawing drawing = new Drawing(clip);
                drawing.drawLine(x + xoffs[0], y + yoffs[0], x + xoffs[1], y + yoffs[1]);
                return drawing;
            }
            if (ndim == 2) {
                Drawing drawing = new Drawing(clip);
                int x00 = x + xoffs[0] + xoffs[2];
                int x01 = x + xoffs[0] + xoffs[3];
                int x11 = x + xoffs[1] + xoffs[3];
                int x10 = x + xoffs[1] + xoffs[2];
                int y00 = y + yoffs[0] + yoffs[2];
                int y01 = y + yoffs[0] + yoffs[3];
                int y11 = y + yoffs[1] + yoffs[3];
                int y10 = y + yoffs[1] + yoffs[2];
                drawing.drawLine(x00, y00, x01, y01);
                drawing.drawLine(x01, y01, x11, y11);
                drawing.drawLine(x11, y11, x10, y10);
                drawing.drawLine(x10, y10, x00, y00);
                return drawing;
            }
            if (ndim == 3) {
                int x000 = x + xoffs[0] + xoffs[2] + xoffs[4];
                int x001 = x + xoffs[0] + xoffs[2] + xoffs[5];
                int x010 = x + xoffs[0] + xoffs[3] + xoffs[4];
                int x011 = x + xoffs[0] + xoffs[3] + xoffs[5];
                int x100 = x + xoffs[1] + xoffs[2] + xoffs[4];
                int x101 = x + xoffs[1] + xoffs[2] + xoffs[5];
                int x110 = x + xoffs[1] + xoffs[3] + xoffs[4];
                int x111 = x + xoffs[1] + xoffs[3] + xoffs[5];
                int y000 = y + yoffs[0] + yoffs[2] + yoffs[4];
                int y001 = y + yoffs[0] + yoffs[2] + yoffs[5];
                int y010 = y + yoffs[0] + yoffs[3] + yoffs[4];
                int y011 = y + yoffs[0] + yoffs[3] + yoffs[5];
                int y100 = y + yoffs[1] + yoffs[2] + yoffs[4];
                int y101 = y + yoffs[1] + yoffs[2] + yoffs[5];
                int y110 = y + yoffs[1] + yoffs[3] + yoffs[4];
                int y111 = y + yoffs[1] + yoffs[3] + yoffs[5];
                Drawing drawing = new Drawing(clip);
                drawing.drawLine(x000, y000, x001, y001);
                drawing.drawLine(x000, y000, x010, y010);
                drawing.drawLine(x000, y000, x100, y100);
                drawing.drawLine(x001, y001, x011, y011);
                drawing.drawLine(x001, y001, x101, y101);
                drawing.drawLine(x010, y010, x011, y011);
                drawing.drawLine(x010, y010, x110, y110);
                drawing.drawLine(x100, y100, x101, y101);
                drawing.drawLine(x100, y100, x110, y110);
                drawing.drawLine(x011, y011, x111, y111);
                drawing.drawLine(x101, y101, x111, y111);
                drawing.drawLine(x110, y110, x111, y111);
                return drawing;
            }
            return NO_PIXELS;
        }
    }

    private static class FilledRectangle
    extends Oblong {
        public FilledRectangle(String name) {
            super(name, false);
        }

        @Override
        protected void drawOblong(Graphics g, int x, int y, int width, int height) {
            g.fillRect(x, y, width, height);
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            if (xoffs.length != 4 || yoffs.length != 4) {
                return NO_PIXELS;
            }
            if (yoffs[0] == 0 && yoffs[1] == 0 && xoffs[2] == 0 && xoffs[3] == 0) {
                int xlo = x + Math.min(xoffs[0], xoffs[1]);
                int xhi = x + Math.max(xoffs[0], xoffs[1]);
                int ylo = y + Math.min(yoffs[2], yoffs[3]);
                int yhi = y + Math.max(yoffs[2], yoffs[3]);
                int width = xhi - xlo;
                int height = yhi - ylo;
                Drawing drawing = new Drawing(clip);
                drawing.fillRect(xlo, ylo, width, height);
                return drawing;
            }
            int[] xof = new int[]{xoffs[0] + xoffs[2], xoffs[1] + xoffs[2], xoffs[1] + xoffs[3], xoffs[0] + xoffs[3]};
            int[] yof = new int[]{yoffs[0] + yoffs[2], yoffs[1] + yoffs[2], yoffs[1] + yoffs[3], yoffs[0] + yoffs[3]};
            Polygon poly = new Polygon(xof, yof, 4);
            poly.translate(x, y);
            Drawing drawing = new Drawing(clip);
            drawing.fill(poly);
            return drawing;
        }
    }

    private static class OpenRectangle
    extends Oblong {
        private final boolean withLines_;

        public OpenRectangle(String name, boolean withLines) {
            super(name, withLines);
            this.withLines_ = withLines;
        }

        @Override
        protected void drawOblong(Graphics g, int x, int y, int width, int height) {
            g.drawRect(x, y, width, height);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 2;
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            if (xoffs.length == 4 && yoffs.length == 4) {
                int xa = x + xoffs[0] + xoffs[2];
                int xb = x + xoffs[0] + xoffs[3];
                int xc = x + xoffs[1] + xoffs[3];
                int xd = x + xoffs[1] + xoffs[2];
                int ya = y + yoffs[0] + yoffs[2];
                int yb = y + yoffs[0] + yoffs[3];
                int yc = y + yoffs[1] + yoffs[3];
                int yd = y + yoffs[1] + yoffs[2];
                Drawing drawing = new Drawing(clip);
                drawing.drawLine(xa, ya, xb, yb);
                drawing.drawLine(xb, yb, xc, yc);
                drawing.drawLine(xc, yc, xd, yd);
                drawing.drawLine(xd, yd, xa, ya);
                if (this.withLines_) {
                    for (int i = 0; i < 4; ++i) {
                        drawing.drawLine(x, y, x + xoffs[i], y + yoffs[i]);
                    }
                }
                return drawing;
            }
            return NO_PIXELS;
        }
    }

    private static class FilledEllipse
    extends Oblong {
        public FilledEllipse(String name) {
            super(name, false);
        }

        @Override
        protected void drawOblong(Graphics g, int x, int y, int width, int height) {
            g.fillOval(x, y, width, height);
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            if (xoffs.length != 4 || yoffs.length != 4) {
                return NO_PIXELS;
            }
            if (yoffs[0] == 0 && yoffs[1] == 0 && xoffs[2] == 0 && xoffs[3] == 0) {
                int xlo = x + Math.min(xoffs[0], xoffs[1]);
                int xhi = x + Math.max(xoffs[0], xoffs[1]);
                int ylo = y + Math.min(yoffs[2], yoffs[3]);
                int yhi = y + Math.max(yoffs[2], yoffs[3]);
                int width = xhi - xlo;
                int height = yhi - ylo;
                Drawing drawing = new Drawing(clip);
                drawing.fillOval(xlo, ylo, width, height);
                return drawing;
            }
            int ax = (xoffs[1] - xoffs[0]) / 2;
            int ay = (yoffs[1] - yoffs[0]) / 2;
            int bx = (xoffs[3] - xoffs[2]) / 2;
            int by = (yoffs[3] - yoffs[2]) / 2;
            int x0 = x + Math.round((float)(xoffs[0] + xoffs[1] + xoffs[2] + xoffs[3]) / 2.0f);
            int y0 = y + Math.round((float)(yoffs[0] + yoffs[1] + yoffs[2] + yoffs[3]) / 2.0f);
            Drawing drawing = new Drawing(clip);
            drawing.fillEllipse(x0, y0, ax, ay, bx, by);
            return drawing;
        }
    }

    private static class OpenEllipse
    extends Oblong {
        private final boolean withLines_;

        public OpenEllipse(String name, boolean withLines) {
            super(name, withLines);
            this.withLines_ = withLines;
        }

        @Override
        protected void drawOblong(Graphics g, int x, int y, int width, int height) {
            g.drawOval(x, y, width, height);
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            if (xoffs.length != 4 || yoffs.length != 4) {
                return NO_PIXELS;
            }
            if (yoffs[0] == 0 && yoffs[1] == 0 && xoffs[2] == 0 && xoffs[3] == 0) {
                int xlo = x + Math.min(xoffs[0], xoffs[1]);
                int xhi = x + Math.max(xoffs[0], xoffs[1]);
                int ylo = y + Math.min(yoffs[2], yoffs[3]);
                int yhi = y + Math.max(yoffs[2], yoffs[3]);
                int width = xhi - xlo;
                int height = yhi - ylo;
                Drawing drawing = new Drawing(clip);
                drawing.drawOval(xlo, ylo, width, height);
                if (this.withLines_) {
                    for (int i = 0; i < 4; ++i) {
                        drawing.drawLine(x, y, x + xoffs[i], y + yoffs[i]);
                    }
                }
                return drawing;
            }
            int ax = (xoffs[1] - xoffs[0]) / 2;
            int ay = (yoffs[1] - yoffs[0]) / 2;
            int bx = (xoffs[3] - xoffs[2]) / 2;
            int by = (yoffs[3] - yoffs[2]) / 2;
            int x0 = x + Math.round((float)(xoffs[0] + xoffs[1] + xoffs[2] + xoffs[3]) / 2.0f);
            int y0 = y + Math.round((float)(yoffs[0] + yoffs[1] + yoffs[2] + yoffs[3]) / 2.0f);
            Drawing drawing = new Drawing(clip);
            drawing.drawEllipse(x0, y0, ax, ay, bx, by);
            if (this.withLines_) {
                for (int i = 0; i < 4; ++i) {
                    drawing.drawLine(x, y, x + xoffs[i], y + yoffs[i]);
                }
            }
            return drawing;
        }
    }

    private static abstract class Oblong
    extends ErrorRenderer {
        private final Icon legend_;
        private final boolean withLines_;

        Oblong(String name, boolean withLines) {
            super(name);
            this.withLines_ = withLines;
            this.legend_ = new ErrorRendererIcon(this, 2);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 2;
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad, ypad);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            Graphics2D g2 = (Graphics2D)g;
            int noff = xoffs.length;
            Dimension size = ErrorRenderer.getApproxGraphicsSize(g2);
            int maxcoord = Math.max(size.width, size.height);
            boolean clipped = false;
            for (int ioff = 0; ioff < noff && !clipped; ++ioff) {
                int xoff = xoffs[ioff];
                int yoff = yoffs[ioff];
                clipped = clipped || xoff < -maxcoord || xoff > maxcoord || yoff < -maxcoord || yoff > maxcoord;
            }
            if (clipped) {
                int[] xo = new int[noff];
                int[] yo = new int[noff];
                for (int ioff = 0; ioff < noff; ++ioff) {
                    xo[ioff] = Math.max(-maxcoord, Math.min(maxcoord, xoffs[ioff]));
                    yo[ioff] = Math.max(-maxcoord, Math.min(maxcoord, yoffs[ioff]));
                }
                xoffs = xo;
                yoffs = yo;
            }
            if (noff == 2) {
                g.drawLine(x + xoffs[0], y + yoffs[0], x + xoffs[1], y + yoffs[1]);
            } else {
                if (noff != 4 || yoffs.length != 4 || !(g instanceof Graphics2D)) {
                    return;
                }
                if (yoffs[0] == 0 && yoffs[1] == 0 && xoffs[2] == 0 && xoffs[3] == 0) {
                    int xlo = Math.min(xoffs[0], xoffs[1]);
                    int xhi = Math.max(xoffs[0], xoffs[1]);
                    int ylo = Math.min(yoffs[2], yoffs[3]);
                    int yhi = Math.max(yoffs[2], yoffs[3]);
                    int width = xhi - xlo;
                    int height = yhi - ylo;
                    if (width > 0 || height > 0) {
                        this.drawOblong(g, x + xlo, y + ylo, width, height);
                    }
                } else {
                    int[] yo;
                    int[] xo;
                    double[] m2;
                    double[] m3;
                    AffineTransform trans;
                    double height;
                    double dx1 = xoffs[1] - xoffs[0];
                    double dy1 = yoffs[1] - yoffs[0];
                    double dx2 = xoffs[3] - xoffs[2];
                    double dy2 = yoffs[3] - yoffs[2];
                    double width = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                    double[] m1 = new double[]{width, 0.0, 0.0, 0.0, height = Math.sqrt(dx2 * dx2 + dy2 * dy2), 0.0, 1.0, 1.0, 1.0};
                    if (Matrices.det(m1) != 0.0 && (trans = new AffineTransform((m3 = Matrices.mmMult(m2 = new double[]{x + (xo = xoffs)[1] + xo[2], x + xo[0] + xo[3], x + xo[0] + xo[2], y + (yo = yoffs)[1] + yo[2], y + yo[0] + yo[3], y + yo[0] + yo[2], 1.0, 1.0, 1.0}, Matrices.invert(m1)))[0], m3[3], m3[1], m3[4], m3[2], m3[5])).getDeterminant() != 0.0) {
                        AffineTransform oldTrans = g2.getTransform();
                        g2.transform(trans);
                        this.drawOblong(g2, 0, 0, (int)Math.round(width), (int)Math.round(height));
                        g2.setTransform(oldTrans);
                    }
                }
            }
            if (this.withLines_) {
                CappedLine.drawErrors(g, x, y, xoffs, yoffs, true, null, true);
            }
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            int xmin = 0;
            int xmax = 0;
            int ymin = 0;
            int ymax = 0;
            int rmax = 0;
            boolean empty = true;
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                empty = false;
                if (xoff == 0) {
                    ymin = Math.min(ymin, yoff);
                    ymax = Math.max(ymax, yoff);
                    continue;
                }
                if (yoff == 0) {
                    xmin = Math.min(xmin, xoff);
                    xmax = Math.max(xmax, xoff);
                    continue;
                }
                rmax = Math.max(rmax, Math.abs(xoff) + Math.abs(yoff));
            }
            if (rmax > 0) {
                xmin = Math.min(xmin, -rmax);
                xmax = Math.max(xmax, rmax);
                ymin = Math.min(ymin, -rmax);
                ymax = Math.max(ymax, rmax);
            }
            if (empty) {
                return new Rectangle(x, y, 0, 0);
            }
            Rectangle box = new Rectangle(x + xmin, y + ymin, xmax - xmin, ymax - ymin);
            ++box.width;
            ++box.height;
            return box;
        }

        protected abstract void drawOblong(Graphics var1, int var2, int var3, int var4, int var5);
    }

    private static class ArrowCapper
    extends Capper {
        private final int capsize_;
        private final int[] xs_;
        private final int[] ys_;

        ArrowCapper(int capsize) {
            this.capsize_ = capsize;
            this.xs_ = new int[3];
            this.ys_ = new int[3];
        }

        @Override
        public void drawCapX(Graphics g, int x, int y, int xoff) {
            int xstart;
            int sign = xoff > 0 ? 1 : -1;
            int size = Math.min(this.capsize_, sign * xoff);
            this.xs_[0] = xstart = x + xoff - sign * size;
            this.ys_[0] = y - size;
            this.xs_[1] = x + xoff;
            this.ys_[1] = y;
            this.xs_[2] = xstart;
            this.ys_[2] = y + size;
            g.drawPolyline(this.xs_, this.ys_, 3);
        }

        @Override
        public void drawCapY(Graphics g, int x, int y, int yoff) {
            int sign = yoff > 0 ? 1 : -1;
            int size = Math.min(this.capsize_, sign * yoff);
            int ystart = y + yoff - sign * size;
            this.xs_[0] = x - size;
            this.ys_[0] = ystart;
            this.xs_[1] = x;
            this.ys_[1] = y + yoff;
            this.xs_[2] = x + size;
            this.ys_[2] = ystart;
            g.drawPolyline(this.xs_, this.ys_, 3);
        }

        @Override
        public void drawCap(Drawing drawing, int x, int y, int xoff, int yoff) {
            if (xoff == 0) {
                int sign = yoff > 0 ? 1 : -1;
                int size = Math.min(this.capsize_, sign * yoff);
                int ystart = y + yoff - sign * size;
                drawing.drawLine(x, y + yoff, x - size, ystart);
                drawing.drawLine(x, y + yoff, x + size, ystart);
            } else if (yoff == 0) {
                int sign = xoff > 0 ? 1 : -1;
                int size = Math.min(this.capsize_, sign * xoff);
                int xstart = x + xoff - sign * size;
                drawing.drawLine(x + xoff, y, xstart, y - size);
                drawing.drawLine(x + xoff, y, xstart, y + size);
            } else {
                double r1 = Math.sqrt(xoff * xoff + yoff * yoff);
                double size = Math.min((double)this.capsize_, r1);
                double capfact = size / r1;
                int ax = xoff + (int)Math.round(capfact * (double)(-xoff + yoff));
                int ay = yoff + (int)Math.round(capfact * (double)(-xoff - yoff));
                int bx = xoff + (int)Math.round(capfact * (double)(-xoff - yoff));
                int by = yoff + (int)Math.round(capfact * (double)(xoff - yoff));
                drawing.drawLine(x + xoff, y + yoff, x + ax, y + ay);
                drawing.drawLine(x + xoff, y + yoff, x + bx, y + by);
            }
        }

        @Override
        public void extendBounds(Rectangle bounds, int xoff, int yoff) {
            if (xoff == 0) {
                bounds.add(-this.capsize_, yoff);
                bounds.add(this.capsize_, yoff);
            } else if (yoff == 0) {
                bounds.add(xoff, -this.capsize_);
                bounds.add(xoff, this.capsize_);
            } else {
                bounds.add(xoff - this.capsize_, yoff - this.capsize_);
                bounds.add(xoff - this.capsize_, yoff + this.capsize_);
                bounds.add(xoff + this.capsize_, yoff - this.capsize_);
                bounds.add(xoff + this.capsize_, yoff + this.capsize_);
            }
        }
    }

    private static class BarCapper
    extends Capper {
        private final int capsize_;

        public BarCapper(int capsize) {
            this.capsize_ = capsize;
        }

        @Override
        public void drawCapX(Graphics g, int x, int y, int xoff) {
            g.drawLine(x + xoff, y - this.capsize_, x + xoff, y + this.capsize_);
        }

        @Override
        public void drawCapY(Graphics g, int x, int y, int yoff) {
            g.drawLine(x - this.capsize_, y + yoff, x + this.capsize_, y + yoff);
        }

        @Override
        public void drawCap(Drawing drawing, int x, int y, int xoff, int yoff) {
            if (xoff == 0) {
                drawing.drawLine(x - this.capsize_, y + yoff, x + this.capsize_, y + yoff);
            } else if (yoff == 0) {
                drawing.drawLine(x + xoff, y - this.capsize_, x + xoff, y + this.capsize_);
            } else {
                int x0 = x + xoff;
                int y0 = y + yoff;
                double r1 = Math.sqrt(xoff * xoff + yoff * yoff);
                double capfact = (double)this.capsize_ / r1;
                int x1 = (int)Math.round(-capfact * (double)yoff);
                int y1 = (int)Math.round(capfact * (double)xoff);
                drawing.drawLine(x0 - x1, y0 - y1, x0 + x1, y0 + y1);
            }
        }

        @Override
        public void extendBounds(Rectangle bounds, int xoff, int yoff) {
            if (xoff == 0) {
                bounds.add(-this.capsize_, yoff);
                bounds.add(this.capsize_, yoff);
            } else if (yoff == 0) {
                bounds.add(xoff, -this.capsize_);
                bounds.add(xoff, this.capsize_);
            } else {
                bounds.add(xoff - this.capsize_, yoff - this.capsize_);
                bounds.add(xoff - this.capsize_, yoff + this.capsize_);
                bounds.add(xoff + this.capsize_, yoff - this.capsize_);
                bounds.add(xoff + this.capsize_, yoff + this.capsize_);
            }
        }
    }

    private static abstract class Capper {
        private Capper() {
        }

        public abstract void drawCapX(Graphics var1, int var2, int var3, int var4);

        public abstract void drawCapY(Graphics var1, int var2, int var3, int var4);

        public abstract void drawCap(Drawing var1, int var2, int var3, int var4, int var5);

        public abstract void extendBounds(Rectangle var1, int var2, int var3);
    }

    private static class Triangle
    extends ErrorRenderer {
        private final boolean isFill_;
        private final Icon legend_;
        private final Stroke stroke_;

        public Triangle(String name, boolean isFill) {
            super(name);
            this.isFill_ = isFill;
            this.legend_ = new ErrorRendererIcon(this, 2);
            this.stroke_ = new BasicStroke(1.0f, 1, 1);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 2;
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad, ypad);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            return this.getTriangle(x, y, xoffs, yoffs).getBounds();
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            Polygon triangle = this.getTriangle(x, y, xoffs, yoffs);
            Drawing drawing = new Drawing(clip);
            if (this.isFill_) {
                drawing.fill(triangle);
            } else {
                int[] xs = triangle.xpoints;
                int[] ys = triangle.ypoints;
                drawing.drawLine(xs[1], ys[1], xs[2], ys[2]);
                drawing.drawLine(xs[2], ys[2], xs[0], ys[0]);
                drawing.drawLine(xs[0], ys[0], xs[1], ys[1]);
            }
            return drawing;
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            int ip;
            Dimension size = ErrorRenderer.getApproxGraphicsSize((Graphics2D)g);
            int dmax = Math.max(size.width, size.height);
            boolean ok = true;
            for (ip = 0; ip < 4 && ok; ++ip) {
                ok = ok && Math.abs(xoffs[ip]) < dmax && Math.abs(yoffs[ip]) < dmax;
            }
            if (!ok) {
                xoffs = (int[])xoffs.clone();
                yoffs = (int[])yoffs.clone();
                for (ip = 0; ip < 4; ++ip) {
                    xoffs[ip] = Math.min(dmax, Math.max(-dmax, xoffs[ip]));
                    yoffs[ip] = Math.min(dmax, Math.max(-dmax, yoffs[ip]));
                }
            }
            Polygon triangle = this.getTriangle(x, y, xoffs, yoffs);
            if (this.isFill_) {
                g.fillPolygon(triangle);
            } else {
                g.drawPolygon(triangle);
            }
        }

        private Polygon getTriangle(int x, int y, int[] xoffs, int[] yoffs) {
            int[] xs = new int[3];
            int[] ys = new int[3];
            xs[0] = x + xoffs[1];
            ys[0] = y + yoffs[1];
            xs[1] = x + xoffs[0] + xoffs[2];
            ys[1] = y + yoffs[0] + yoffs[2];
            xs[2] = x + xoffs[0] + xoffs[3];
            ys[2] = y + yoffs[0] + yoffs[3];
            return new Polygon(xs, ys, 3);
        }
    }

    private static class Dart
    extends ErrorRenderer {
        private final boolean isFill_;
        private final int basepix_;
        private final Icon legend_;
        private final int[] vys_;
        private final Stroke stroke_;

        public Dart(String name, boolean isFill, int basepix) {
            super(name);
            this.isFill_ = isFill;
            this.basepix_ = basepix;
            this.legend_ = new ErrorRendererIcon(this, 2);
            this.vys_ = new int[]{this.basepix_, 0, -this.basepix_};
            this.stroke_ = new BasicStroke(1.0f, 1, 1);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim > 0;
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad, ypad);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            Rectangle box = new Rectangle();
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                box.add(xoff, yoff);
                Point bp = this.getBaseVertex(xoff, yoff);
                box.add(bp.x, bp.y);
                box.add(-bp.x, -bp.y);
                ++box.width;
                ++box.height;
            }
            box.x = x;
            box.y = y;
            return box;
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            Drawing drawing = new Drawing(clip);
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                Point bp = this.getBaseVertex(xoff, yoff);
                int x1 = x + xoff;
                int y1 = y + yoff;
                int x2 = x + bp.x;
                int y2 = y + bp.y;
                int x3 = x - bp.x;
                int y3 = y - bp.y;
                if (this.isFill_) {
                    drawing.fill(new Polygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3));
                    continue;
                }
                drawing.drawLine(x1, y1, x2, y2);
                drawing.drawLine(x2, y2, x3, y3);
                drawing.drawLine(x3, y3, x1, y1);
            }
            return drawing;
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            Rectangle clip = g.getClipBounds();
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke0 = g2.getStroke();
            g2.setStroke(this.stroke_);
            Dimension size = ErrorRenderer.getApproxGraphicsSize(g2);
            double dmax = Math.max(size.width, size.height);
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                double dx = xoffs[ip];
                double dy = yoffs[ip];
                if (dx == 0.0 && dy == 0.0) continue;
                double dleng = Math.min(Math.hypot(dx, dy), dmax);
                AffineTransform trans0 = g2.getTransform();
                g2.translate(x, y);
                g2.rotate(Math.atan2(dy, dx));
                int[] xs = new int[]{0, (int)Math.round(dleng), 0};
                if (this.isFill_) {
                    g2.fillPolygon(xs, this.vys_, 3);
                } else {
                    g2.drawPolygon(xs, this.vys_, 3);
                }
                g2.setTransform(trans0);
            }
            g2.setStroke(stroke0);
        }

        private Point getBaseVertex(int xoff, int yoff) {
            double dx = xoff;
            double dy = yoff;
            double dscale = 1.0 / Math.hypot(dx, dy);
            return new Point(-((int)Math.round((double)this.basepix_ * dy * dscale)), (int)Math.round((double)this.basepix_ * dx * dscale));
        }
    }

    private static class CappedLine
    extends ErrorRenderer {
        private final boolean lines_;
        private final Capper capper_;
        private final Icon legend_;

        CappedLine(String name, boolean lines, Capper capper) {
            super(name);
            this.lines_ = lines;
            this.capper_ = capper;
            this.legend_ = new ErrorRendererIcon(this, 2);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim > 0;
        }

        @Override
        public Icon getLegendIcon() {
            return this.legend_;
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return new ErrorRendererIcon(this, modes, width, height, xpad, ypad);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return modes != null && ErrorMode.allBlank(modes);
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            CappedLine.drawErrors(g, x, y, xoffs, yoffs, this.lines_, this.capper_, false);
        }

        public static void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs, boolean lines, Capper capper, boolean willCover) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(capper != null || willCover ? CAP_BUTT : CAP_ROUND);
            Dimension size = ErrorRenderer.getApproxGraphicsSize(g2);
            int xmax = size.width;
            int ymax = size.height;
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                boolean clipped;
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                boolean xlo = xoff < -xmax;
                boolean xhi = xoff > xmax;
                boolean ylo = yoff < -ymax;
                boolean yhi = yoff > ymax;
                boolean bl = clipped = xlo || xhi || ylo || yhi;
                if (clipped) {
                    if (xlo && yoff == 0) {
                        xoff = -xmax;
                    } else if (xhi && yoff == 0) {
                        xoff = xmax;
                    } else if (ylo && xoff == 0) {
                        yoff = -ymax;
                    } else if (yhi && xoff == 0) {
                        yoff = ymax;
                    } else {
                        double s2 = (double)(xmax * xmax + ymax * ymax) / (double)(xoff * xoff + yoff * yoff);
                        double shrink = Math.sqrt(s2);
                        xoff = (int)Math.ceil(shrink * (double)xoff);
                        yoff = (int)Math.ceil(shrink * (double)yoff);
                    }
                }
                if (lines) {
                    g.drawLine(x, y, x + xoff, y + yoff);
                }
                if (capper == null || clipped) continue;
                g2.setStroke(CAP_ROUND);
                if (xoff == 0) {
                    capper.drawCapY(g2, x, y, yoff);
                    continue;
                }
                if (yoff == 0) {
                    capper.drawCapX(g2, x, y, xoff);
                    continue;
                }
                AffineTransform oldTransform = g2.getTransform();
                g2.translate(x, y);
                g2.rotate(Math.atan2(yoff, xoff));
                double l2 = xoff * xoff + yoff * yoff;
                int leng = (int)Math.round(Math.sqrt(l2));
                capper.drawCapX(g2, 0, 0, leng);
                g2.setTransform(oldTransform);
            }
            g2.setStroke(oldStroke);
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            Drawing drawing = new Drawing(clip);
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                if (this.lines_) {
                    drawing.drawLine(x, y, x + xoff, y + yoff);
                }
                if (this.capper_ == null) continue;
                this.capper_.drawCap(drawing, x, y, xoff, yoff);
            }
            return drawing;
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            boolean xmin = false;
            boolean xmax = false;
            boolean ymin = false;
            boolean ymax = false;
            int np = xoffs.length;
            boolean empty = true;
            Rectangle box = new Rectangle();
            for (int ip = 0; ip < np; ++ip) {
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                empty = false;
                box.add(xoff, yoff);
                if (this.capper_ == null) continue;
                this.capper_.extendBounds(box, xoff, yoff);
            }
            if (!empty) {
                ++box.width;
                ++box.height;
            }
            box.x = x;
            box.y = y;
            return box;
        }
    }

    private static class ErrorRendererIcon
    implements Icon {
        private final ErrorRenderer renderer_;
        private final int width_;
        private final int height_;
        private final int[] xoffs_;
        private final int[] yoffs_;

        public ErrorRendererIcon(ErrorRenderer renderer, int ndim) {
            this(renderer, ErrorRendererIcon.fillModeArray(ndim, ErrorMode.SYMMETRIC), 40, 16, 5, 1);
        }

        public ErrorRendererIcon(ErrorRenderer renderer, ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            ErrorMode zmode;
            ErrorMode ymode;
            ErrorMode xmode;
            this.renderer_ = renderer;
            this.width_ = width;
            this.height_ = height;
            int w2 = width / 2 - xpad;
            int h2 = height / 2 - ypad;
            int ndim = modes.length;
            ArrayList<Point> offList = new ArrayList<Point>(ndim);
            if (ndim > 0 && !ErrorMode.NONE.equals(xmode = modes[0])) {
                float xlo = (float)xmode.getExampleLower();
                float xhi = (float)xmode.getExampleUpper();
                offList.add(new Point(Math.round(-xlo * (float)w2), 0));
                offList.add(new Point(Math.round(xhi * (float)w2), 0));
            }
            if (ndim > 1 && !ErrorMode.NONE.equals(ymode = modes[1])) {
                float ylo = (float)ymode.getExampleLower();
                float yhi = (float)ymode.getExampleUpper();
                offList.add(new Point(0, Math.round(ylo * (float)h2)));
                offList.add(new Point(0, Math.round(-yhi * (float)h2)));
            }
            if (ndim > 2 && !ErrorMode.NONE.equals(zmode = modes[2])) {
                float zlo = (float)zmode.getExampleLower();
                float zhi = (float)zmode.getExampleUpper();
                float theta = (float)Math.toRadians(40.0);
                float slant = 0.8f;
                float c = (float)Math.cos(theta) * slant;
                float s = (float)Math.sin(theta) * slant;
                offList.add(new Point(Math.round(-c * zlo * (float)w2), Math.round(s * zlo * (float)h2)));
                offList.add(new Point(Math.round(c * zhi * (float)w2), Math.round(-s * zhi * (float)h2)));
            }
            int np = offList.size();
            this.xoffs_ = new int[np];
            this.yoffs_ = new int[np];
            for (int ip = 0; ip < np; ++ip) {
                Point point = (Point)offList.get(ip);
                this.xoffs_[ip] = point.x;
                this.yoffs_[ip] = point.y;
            }
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderer_.drawErrors(g2, x + this.width_ / 2, y + this.height_ / 2, this.xoffs_, this.yoffs_);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }

        private static ErrorMode[] fillModeArray(int leng, ErrorMode mode) {
            Object[] modes = new ErrorMode[leng];
            Arrays.fill(modes, mode);
            return modes;
        }
    }

    private static class Wrapper
    extends ErrorRenderer {
        private final ErrorRenderer base_;

        public Wrapper(ErrorRenderer base) {
            super(base.getName());
            this.base_ = base;
        }

        @Override
        public Icon getLegendIcon() {
            return this.base_.getLegendIcon();
        }

        @Override
        public Icon getLegendIcon(ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            return this.base_.getLegendIcon(modes, width, height, xpad, ypad);
        }

        @Override
        public Rectangle getBounds(int x, int y, int[] xoffs, int[] yoffs) {
            return this.base_.getBounds(x, y, xoffs, yoffs);
        }

        @Override
        public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
            this.base_.drawErrors(g, x, y, xoffs, yoffs);
        }

        @Override
        public Pixellator getPixels(Rectangle clip, int x, int y, int[] xoffs, int[] yoffs) {
            return this.base_.getPixels(clip, x, y, xoffs, yoffs);
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return this.base_.supportsDimensionality(ndim);
        }

        @Override
        public boolean isBlank(ErrorMode[] modes) {
            return this.base_.isBlank(modes);
        }
    }
}

