/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Pixellator;

public class GraphicsBitmap {
    private final int width_;
    private final int height_;
    private final BufferedImage image_;
    private final DataBuffer dbuffer_;
    private final SampleModel sampler_;

    public GraphicsBitmap(int width, int height) {
        this.width_ = width;
        this.height_ = height;
        this.image_ = new BufferedImage(width, height, 10);
        this.dbuffer_ = this.image_.getRaster().getDataBuffer();
        assert (this.dbuffer_ instanceof DataBufferByte);
        this.sampler_ = this.image_.getSampleModel();
    }

    public Graphics2D createGraphics() {
        Graphics2D g2 = this.image_.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        return g2;
    }

    public void clear() {
        if (this.dbuffer_ instanceof DataBufferByte) {
            Arrays.fill(((DataBufferByte)this.dbuffer_).getData(), (byte)0);
        } else {
            assert (false);
            for (int iy = 0; iy < this.height_; ++iy) {
                for (int ix = 0; ix < this.width_; ++ix) {
                    this.sampler_.setSample(ix, iy, 0, 0, this.dbuffer_);
                }
            }
        }
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public Pixellator createPixellator() {
        return this.createPixellator(null);
    }

    public Pixellator createPixellator(Rectangle bounds) {
        return (bounds == null || bounds.contains(new Rectangle(0, 0, this.width_, this.height_))) && this.sampler_.getSampleSize(0) == 8 ? new TotalPixellator() : new PartialPixellator(bounds);
    }

    private class PartialPixellator
    implements Pixellator {
        private final Rectangle bounds_;
        private int ix_;
        private int iy_;

        PartialPixellator(Rectangle bounds) {
            if (bounds.x < 0 || bounds.y < 0 || bounds.width > GraphicsBitmap.this.width_ || bounds.height > GraphicsBitmap.this.height_) {
                throw new IllegalArgumentException("Bounds bigger than bitmap");
            }
            this.bounds_ = bounds;
            this.ix_ = this.bounds_.x + this.bounds_.width;
            this.iy_ = this.bounds_.y + this.bounds_.height;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(this.bounds_);
        }

        @Override
        public void start() {
            this.ix_ = this.bounds_.x;
            this.iy_ = this.bounds_.y;
        }

        @Override
        public boolean next() {
            boolean done = false;
            do {
                if (++this.ix_ < this.bounds_.x + this.bounds_.width) continue;
                this.ix_ = 0;
                if (++this.iy_ < this.bounds_.y + this.bounds_.height) continue;
                done = true;
            } while (!done && GraphicsBitmap.this.sampler_.getSample(this.ix_, this.iy_, 0, GraphicsBitmap.this.dbuffer_) == 0);
            return !done;
        }

        @Override
        public int getX() {
            return this.ix_;
        }

        @Override
        public int getY() {
            return this.iy_;
        }
    }

    private class TotalPixellator
    implements Pixellator {
        private final byte[] bytes_;
        private final int npix_;
        private int ipix_;

        TotalPixellator() {
            this.bytes_ = ((DataBufferByte)GraphicsBitmap.this.dbuffer_).getData();
            this.ipix_ = this.npix_ = GraphicsBitmap.this.width_ * GraphicsBitmap.this.height_;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, GraphicsBitmap.this.width_, GraphicsBitmap.this.height_);
        }

        @Override
        public void start() {
            this.ipix_ = -1;
        }

        @Override
        public boolean next() {
            while (++this.ipix_ < this.npix_ && this.bytes_[this.ipix_] == 0) {
            }
            return this.ipix_ < this.npix_;
        }

        @Override
        public int getX() {
            return this.ipix_ % GraphicsBitmap.this.width_;
        }

        @Override
        public int getY() {
            return this.ipix_ / GraphicsBitmap.this.width_;
        }
    }
}

