/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot.BinnedData;

public class MapBinnedData<K extends Comparable<K>>
implements BinnedData {
    private final SortedMap<K, double[]> map_;
    private final int nset_;
    private final BinMapper<K> mapper_;
    private boolean isFloat_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");

    public MapBinnedData(int nset, BinMapper<K> mapper) {
        this.nset_ = nset;
        this.mapper_ = mapper;
        this.map_ = new TreeMap<K, double[]>();
    }

    @Override
    public void submitDatum(double value, double weight, boolean[] setFlags) {
        if (Double.isNaN(value) || Double.isNaN(weight) || weight == 0.0) {
            return;
        }
        this.isFloat_ = this.isFloat_ || weight != (double)((int)weight);
        K key = this.mapper_.getKey(value);
        if (key != null) {
            double[] counts = (double[])this.map_.get(key);
            if (counts == null) {
                counts = new double[this.nset_];
                this.map_.put(key, counts);
            }
            for (int is = 0; is < this.nset_; ++is) {
                if (!setFlags[is]) continue;
                int n = is;
                counts[n] = counts[n] + weight;
            }
        }
    }

    @Override
    public Iterator<BinnedData.Bin> getBinIterator(boolean includeEmpty) {
        final Iterator<K> keyIt = includeEmpty && !this.map_.isEmpty() ? this.mapper_.keyIterator((Comparable)this.map_.firstKey(), (Comparable)this.map_.lastKey()) : this.map_.keySet().iterator();
        return new Iterator<BinnedData.Bin>(){
            final double[] EMPTY_SUMS;
            {
                this.EMPTY_SUMS = new double[MapBinnedData.this.nset_];
            }

            @Override
            public boolean hasNext() {
                return keyIt.hasNext();
            }

            @Override
            public BinnedData.Bin next() {
                Comparable key = (Comparable)keyIt.next();
                final double[] sums = MapBinnedData.this.map_.containsKey(key) ? (double[])MapBinnedData.this.map_.get(key) : this.EMPTY_SUMS;
                final double[] bounds = MapBinnedData.this.mapper_.getBounds(key);
                return new BinnedData.Bin(){

                    @Override
                    public double getLowBound() {
                        return bounds[0];
                    }

                    @Override
                    public double getHighBound() {
                        return bounds[1];
                    }

                    @Override
                    public double getWeightedCount(int iset) {
                        return sums[iset];
                    }
                };
            }

            @Override
            public void remove() {
                keyIt.remove();
            }
        };
    }

    @Override
    public int getSetCount() {
        return this.nset_;
    }

    @Override
    public boolean isInteger() {
        return !this.isFloat_;
    }

    public BinMapper<K> getMapper() {
        return this.mapper_;
    }

    public static BinMapper<Long> createBinMapper(boolean logFlag, double binWidth, double binBase) {
        return logFlag ? new LogBinMapper(binWidth, binBase) : new LinearBinMapper(binWidth, binBase);
    }

    private static class LogBinMapper
    implements BinMapper<Long> {
        final double factor_;
        final double base_;
        final double logFactor_;

        LogBinMapper(double factor, double base) {
            this.factor_ = factor;
            this.base_ = base > 0.0 ? base : 1.0;
            this.logFactor_ = Math.log(factor);
        }

        @Override
        public Long getKey(double value) {
            return value > 0.0 ? Long.valueOf((long)Math.floor(Math.log(value / this.base_) / this.logFactor_)) : null;
        }

        @Override
        public double[] getBounds(Long key) {
            double lo = Math.pow(this.factor_, key.doubleValue()) * this.base_;
            return new double[]{lo, lo * this.factor_};
        }

        @Override
        public Iterator<Long> keyIterator(final Long loKey, final Long hiKey) {
            return new Iterator<Long>(){
                final long hiVal_;
                long val_;
                {
                    this.hiVal_ = hiKey;
                    this.val_ = loKey;
                }

                @Override
                public boolean hasNext() {
                    return this.val_ <= this.hiVal_;
                }

                @Override
                public Long next() {
                    return this.val_++;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public MapBinnedData<Long> createBinnedData(int nset) {
            return new MapBinnedData<Long>(nset, this);
        }
    }

    private static class LinearBinMapper
    implements BinMapper<Long> {
        final double width_;
        final double base_;

        LinearBinMapper(double binWidth, double binBase) {
            if (binWidth <= 0.0 || Double.isNaN(binWidth)) {
                throw new IllegalArgumentException("Bad width " + binWidth);
            }
            this.width_ = binWidth;
            this.base_ = binBase;
        }

        @Override
        public Long getKey(double value) {
            return (long)Math.floor((value - this.base_) / this.width_);
        }

        @Override
        public double[] getBounds(Long key) {
            long keyval = key;
            double bottom = (double)keyval * this.width_ + this.base_;
            if (Double.isNaN(bottom) && !Double.isNaN(bottom)) {
                logger_.warning("Monstrous Java 1.4.1 JVM bug");
            }
            return new double[]{bottom, bottom + this.width_};
        }

        @Override
        public Iterator<Long> keyIterator(final Long loKey, final Long hiKey) {
            return new Iterator<Long>(){
                final long hiVal_;
                long val_;
                {
                    this.hiVal_ = hiKey;
                    this.val_ = loKey;
                }

                @Override
                public boolean hasNext() {
                    return this.val_ <= this.hiVal_;
                }

                @Override
                public Long next() {
                    return this.val_++;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public MapBinnedData<Long> createBinnedData(int nset) {
            return new MapBinnedData<Long>(nset, this);
        }
    }

    public static interface BinMapper<K extends Comparable<K>> {
        public K getKey(double var1);

        public double[] getBounds(K var1);

        public Iterator<K> keyIterator(K var1, K var2);

        public MapBinnedData<K> createBinnedData(int var1);
    }
}

