/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

public class Matrices {
    public static double[] adj(double[] m) {
        return new double[]{m[4] * m[8] - m[5] * m[7], -m[1] * m[8] + m[2] * m[7], m[1] * m[5] - m[2] * m[4], -m[3] * m[8] + m[5] * m[6], m[0] * m[8] - m[2] * m[6], -m[0] * m[5] + m[2] * m[3], m[3] * m[7] - m[4] * m[6], -m[0] * m[7] + m[1] * m[6], m[0] * m[4] - m[1] * m[3]};
    }

    public static double det(double[] m) {
        return m[0] * (m[4] * m[8] - m[5] * m[7]) - m[1] * (m[3] * m[8] - m[5] * m[6]) + m[2] * (m[3] * m[7] - m[4] * m[6]);
    }

    public static double[] invert(double[] m) {
        return Matrices.mult(Matrices.adj(m), 1.0 / Matrices.det(m));
    }

    public static double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static double[] cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], -(a[0] * b[2] - a[2] * b[0]), a[0] * b[1] - a[1] * b[0]};
    }

    public static double[] transpose(double[] a) {
        return new double[]{a[0], a[3], a[6], a[1], a[4], a[7], a[2], a[5], a[8]};
    }

    public static double[] unit(int iaxis) {
        double[] unit = new double[3];
        unit[iaxis] = 1.0;
        return unit;
    }

    public static double mod(double[] v) {
        double m2 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            m2 += v[i] * v[i];
        }
        return Math.sqrt(m2);
    }

    public static double[] normalise(double[] v) {
        return Matrices.mult(v, 1.0 / Matrices.mod(v));
    }

    public static double[] mult(double[] v, double c) {
        double[] r = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = v[i] * c;
        }
        return r;
    }

    public static double[] mvMult(double[] m, double[] v) {
        return new double[]{m[0] * v[0] + m[1] * v[1] + m[2] * v[2], m[3] * v[0] + m[4] * v[1] + m[5] * v[2], m[6] * v[0] + m[7] * v[1] + m[8] * v[2]};
    }

    public static double[] mmMult(double[] a, double[] b) {
        double[] r = new double[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    int n = 3 * i + j;
                    r[n] = r[n] + a[3 * i + k] * b[j + 3 * k];
                }
            }
        }
        return r;
    }

    public static String toString(double[] a) {
        StringBuffer sbuf = new StringBuffer("(");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sbuf.append(',');
            }
            sbuf.append(' ');
            sbuf.append((float)a[i]);
        }
        sbuf.append(" )");
        return sbuf.toString();
    }

    public static double[] fromPal(double[][] m) {
        return new double[]{m[0][0], m[0][1], m[0][2], m[1][0], m[1][1], m[1][2], m[2][0], m[2][1], m[2][2]};
    }

    public static double[][] toPal(double[] m) {
        return new double[][]{{m[0], m[1], m[2]}, {m[3], m[4], m[5]}, {m[6], m[7], m[8]}};
    }
}

