/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.PlotBox;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;

public class PtPlotSurface
extends PlotBox
implements PlotSurface {
    private PlotState state_;
    private static final int padPixels_ = 0;

    public PtPlotSurface() {
        this.setColor(false);
        this._setPadding(0.0);
        this._expThreshold = 3;
        this._topPadding = 0;
        this._uly = this._topPadding + 5;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._labelFont = font;
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
        double superScale = 0.75;
        this._superscriptFont = font.deriveFont(AffineTransform.getScaleInstance(superScale, superScale));
        this._superscriptFontMetrics = this.getFontMetrics(this._superscriptFont);
    }

    @Override
    public void setState(PlotState state) {
        this.state_ = state;
        if (this.state_ != null && state.getValid()) {
            this.configure(this.state_);
        } else {
            this.setXLabel("");
            this.setYLabel("");
            this.setXLog(false);
            this.setYLog(false);
            this.setXFlip(false);
            this.setYFlip(false);
            this.setGrid(false);
            this.checkInvariants();
        }
    }

    @Override
    public void setDataRange(double xlo, double ylo, double xhi, double yhi) {
        if (!Double.isNaN(xlo) && !Double.isNaN(xhi)) {
            if (this._xlog) {
                xlo = xlo > 0.0 ? Math.log(xlo) * _LOG10SCALE : 0.0;
                double d = xhi = xhi > 0.0 ? Math.log(xhi) * _LOG10SCALE : 1.0;
            }
            if (this._xflip) {
                double xl = -xhi;
                double xh = -xlo;
                xlo = xl;
                xhi = xh;
            }
            int width = this._lrx - this._ulx;
            double xpad = (xhi - xlo) * 0.0 / (double)width;
            this.setXRange(xlo - xpad, xhi + xpad);
        }
        if (!Double.isNaN(ylo) && !Double.isNaN(yhi)) {
            if (this._ylog) {
                ylo = ylo > 0.0 ? Math.log(ylo) * _LOG10SCALE : 0.0;
                double d = yhi = yhi > 0.0 ? Math.log(yhi) * _LOG10SCALE : 1.0;
            }
            if (this._yflip) {
                double yl = -yhi;
                double yh = -ylo;
                ylo = yl;
                yhi = yh;
            }
            int height = this._lry - this._uly;
            double ypad = (yhi - ylo) * 0.0 / (double)height;
            this.setYRange(ylo - ypad, yhi + ypad);
        }
        this.checkInvariants();
    }

    @Override
    public Point dataToGraphics(double dx, double dy, boolean insideOnly) {
        if (Double.isNaN(dx) || Double.isNaN(dy)) {
            return null;
        }
        if (this._xlog) {
            if (dx > 0.0) {
                dx = Math.log(dx) * _LOG10SCALE;
            } else {
                if (insideOnly) {
                    return null;
                }
                dx = Double.NEGATIVE_INFINITY;
            }
        }
        if (this._ylog) {
            if (dy > 0.0) {
                dy = Math.log(dy) * _LOG10SCALE;
            } else {
                if (insideOnly) {
                    return null;
                }
                dy = Double.NEGATIVE_INFINITY;
            }
        }
        if (this._xflip) {
            dx = -dx;
        }
        if (this._yflip) {
            dy = -dy;
        }
        if (!insideOnly || dx >= this._xMin && dx <= this._xMax && dy >= this._yMin && dy <= this._yMax) {
            int ipx;
            double px = (double)this._ulx + (dx - this._xMin) * this._xscale;
            double py = (double)this._lry - (dy - this._yMin) * this._yscale;
            int n = px > 1.073741823E9 ? 0x3FFFFFFF : (ipx = px < -1.073741823E9 ? -1073741823 : (int)px);
            int ipy = py > 1.073741823E9 ? 0x3FFFFFFF : (py < -1.073741823E9 ? -1073741823 : (int)py);
            return new Point(ipx, ipy);
        }
        return null;
    }

    @Override
    public double[] graphicsToData(int px, int py, boolean insideOnly) {
        if (insideOnly && (px < this._ulx || px > this._lrx || py < this._uly || py > this._lry)) {
            return null;
        }
        double dx = this._xMin + (double)(px - this._ulx) / this._xscale;
        double dy = this._yMin - (double)(py - this._lry) / this._yscale;
        if (this._xflip) {
            dx = -dx;
        }
        if (this._yflip) {
            dy = -dy;
        }
        if (this._xlog) {
            dx = Math.pow(10.0, dx);
        }
        if (this._ylog) {
            dy = Math.pow(10.0, dy);
        }
        return new double[]{dx, dy};
    }

    @Override
    public Shape getClip() {
        int width = this._lrx - this._ulx - 1;
        int height = this._lry - this._uly - 1;
        return new Rectangle(this._ulx + 1, this._uly + 1, width, height);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintSurface(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    protected void _zoom(int x, int y) {
        double oldXMin = this._xMin;
        double oldXMax = this._xMax;
        double oldYMin = this._yMin;
        double oldYMax = this._yMax;
        super._zoom(x, y);
        if (this._xMin != oldXMin || this._xMax != oldXMax || this._yMin != oldYMin || this._yMax != oldYMax) {
            this.checkInvariants();
        }
    }

    private void checkInvariants() {
        this._drawPlot(null, true);
    }

    private void configure(PlotState state) {
        this.setXLabel(state.getAxisLabels()[0]);
        this.setYLabel(state.getAxisLabels()[1]);
        this.setXLog(state.getLogFlags()[0]);
        this.setYLog(state.getLogFlags()[1]);
        this.setXFlip(state.getFlipFlags()[0]);
        this.setYFlip(state.getFlipFlags()[1]);
        this.setGrid(state.getGrid());
        this.checkInvariants();
    }
}

