/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.util.Arrays;

public class Range {
    private double lo_ = Double.NaN;
    private double hi_ = Double.NaN;
    private double loPos_ = Double.NaN;
    private double hiPos_ = Double.NaN;

    public Range() {
    }

    public Range(double lo, double hi) {
        this();
        this.setBounds(lo, hi);
    }

    public Range(double[] bounds) {
        this(bounds[0], bounds[1]);
    }

    public Range(Range range) {
        this.lo_ = range.lo_;
        this.hi_ = range.hi_;
        this.loPos_ = range.loPos_;
        this.hiPos_ = range.hiPos_;
    }

    public void submit(double datum) {
        if (Range.isFinite(datum)) {
            if (!(this.lo_ <= datum)) {
                this.lo_ = datum;
            }
            if (!(this.hi_ >= datum)) {
                this.hi_ = datum;
            }
            if (datum > 0.0) {
                if (!(this.loPos_ <= datum)) {
                    this.loPos_ = datum;
                }
                if (!(this.hiPos_ >= datum)) {
                    this.hiPos_ = datum;
                }
            }
        }
    }

    public void setBounds(double[] bounds) {
        this.setBounds(bounds[0], bounds[1]);
    }

    public void setBounds(double lo, double hi) {
        if (lo > hi) {
            throw new IllegalArgumentException("Bad range: " + lo + " .. " + hi);
        }
        this.clear();
        if (!Double.isInfinite(lo)) {
            this.lo_ = lo;
            if (!(lo <= 0.0)) {
                this.loPos_ = lo;
            }
        }
        if (!Double.isInfinite(hi)) {
            this.hi_ = hi;
            if (!(hi <= 0.0)) {
                this.hiPos_ = hi;
            }
        }
    }

    public double[] getBounds() {
        return new double[]{this.lo_, this.hi_};
    }

    public double[] getFiniteBounds(boolean positive) {
        if (positive) {
            if (this.loPos_ < this.hiPos_) {
                return new double[]{this.loPos_, this.hiPos_};
            }
            if (this.loPos_ == this.hiPos_) {
                return new double[]{this.hiPos_ * 0.9, this.hiPos_ * 1.1};
            }
            if (this.hiPos_ > 1.0) {
                return new double[]{0.1, this.hiPos_};
            }
            if (this.hiPos_ > 0.0) {
                return new double[]{this.hiPos_ * 0.001, this.hiPos_};
            }
            return new double[]{1.0, 10.0};
        }
        if (this.lo_ < this.hi_) {
            return new double[]{this.lo_, this.hi_};
        }
        if (this.lo_ == this.hi_) {
            double d0 = 1.0;
            double d1 = this.hi_ - d0 < this.hi_ + d0 ? d0 : 0.01 * Math.abs(this.hi_);
            return new double[]{this.hi_ - d1, this.hi_ + d1};
        }
        return new double[]{0.0, 1.0};
    }

    public boolean isClear() {
        return Double.isNaN(this.lo_) && Double.isNaN(this.hi_);
    }

    public boolean isFinite() {
        return !Double.isNaN(this.lo_) && !Double.isNaN(this.hi_);
    }

    public void pad(double ratio) {
        if (this.lo_ < this.hi_) {
            this.lo_ -= (this.hi_ - this.lo_) * ratio;
            this.hi_ += (this.hi_ - this.lo_) * ratio;
        }
        if (this.loPos_ < this.hiPos_) {
            this.loPos_ /= Math.exp(Math.log(this.hiPos_ / this.loPos_) * ratio);
            this.hiPos_ *= Math.exp(Math.log(this.hiPos_ / this.loPos_) * ratio);
        }
    }

    public void clear() {
        this.lo_ = Double.NaN;
        this.hi_ = Double.NaN;
        this.loPos_ = Double.NaN;
        this.hiPos_ = Double.NaN;
    }

    public void limit(double lo, double hi) {
        if (lo > hi) {
            throw new IllegalArgumentException("Bad range: " + lo + " .. " + hi);
        }
        if (Range.isFinite(lo)) {
            this.lo_ = lo;
            if (!(lo <= 0.0)) {
                this.loPos_ = lo;
            }
            if (this.hi_ < this.lo_) {
                this.hi_ = this.lo_;
                this.hiPos_ = this.loPos_;
            }
        }
        if (Range.isFinite(hi) && !(hi < this.lo_)) {
            this.hi_ = hi;
            if (!(hi <= 0.0)) {
                this.hiPos_ = hi;
            }
            if (this.lo_ > this.hi_) {
                this.lo_ = this.hi_;
                this.loPos_ = this.hiPos_;
            }
        }
    }

    public void limit(double[] bounds) {
        if (bounds != null) {
            this.limit(bounds[0], bounds[1]);
        }
    }

    public void limit(Range boundRange) {
        this.limit(boundRange.getBounds());
    }

    public void extend(Range other) {
        if (Range.isFinite(other.lo_) && !(this.lo_ < other.lo_)) {
            this.lo_ = other.lo_;
        }
        if (Range.isFinite(other.hi_) && !(this.hi_ > other.hi_)) {
            this.hi_ = other.hi_;
        }
        if (Range.isFinite(other.loPos_) && !(this.loPos_ < other.loPos_)) {
            this.loPos_ = other.loPos_;
        }
        if (Range.isFinite(other.hiPos_) && !(this.hiPos_ > other.hiPos_)) {
            this.hiPos_ = other.hiPos_;
        }
    }

    public boolean equals(Object o) {
        return o instanceof Range && Arrays.equals(this.stateArray(), ((Range)o).stateArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.stateArray());
    }

    public String toString() {
        return "[" + this.lo_ + " .. " + this.hi_ + "]";
    }

    private double[] stateArray() {
        return new double[]{this.lo_, this.hi_, this.loPos_, this.hiPos_};
    }

    private static boolean isFinite(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }
}

