/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Scalings;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.util.Bi;
import uk.ac.starlink.util.Util;

public class AuxScale {
    private final String name_;
    public static AuxScale COLOR = new AuxScale("Aux");

    public AuxScale(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static List<Bi<Surface, PlotLayer>> pairSurfaceLayers(Surface surf, PlotLayer[] layers) {
        return Arrays.stream(layers).map(layer -> new Bi((Object)surf, layer)).collect(Collectors.toList());
    }

    public static AuxScale[] getAuxScales(PlotLayer[] layers) {
        HashSet<AuxScale> scaleSet = new HashSet<AuxScale>();
        for (int il = 0; il < layers.length; ++il) {
            scaleSet.addAll(layers[il].getAuxRangers().keySet());
        }
        return scaleSet.toArray(new AuxScale[0]);
    }

    public static Map<AuxScale, Span> calculateAuxSpans(AuxScale[] scales, List<Bi<Surface, PlotLayer>> surfLayers, Object[] knownPlans, DataStore dataStore) {
        HashMap<AuxScale, Span> spanMap = new HashMap<AuxScale, Span>();
        for (int is = 0; is < scales.length; ++is) {
            AuxScale scale = scales[is];
            spanMap.put(scale, AuxScale.calculateSpan(scale, surfLayers, knownPlans, dataStore));
        }
        return spanMap;
    }

    @Slow
    public static Span calculateSpan(AuxScale scale, List<Bi<Surface, PlotLayer>> surfLayers, Object[] knownPlans, DataStore dataStore) {
        Scaling[] scalings = (Scaling[])surfLayers.stream().map(sl -> (AuxReader)Util.get(((PlotLayer)sl.getItem2()).getAuxRangers(), (Object)scale)).filter(rdr -> rdr != null).map(AuxReader::getScaling).distinct().toArray(Scaling[]::new);
        Ranger ranger = Scalings.createRanger(scalings);
        for (Bi<Surface, PlotLayer> surfLayer : surfLayers) {
            Surface surface = (Surface)surfLayer.getItem1();
            PlotLayer layer = (PlotLayer)surfLayer.getItem2();
            AuxReader rdr2 = layer.getAuxRangers().get(scale);
            if (rdr2 == null) continue;
            rdr2.adjustAuxRange(surface, layer.getDataSpec(), dataStore, knownPlans, ranger);
        }
        return ranger.createSpan();
    }

    public static Span clipSpan(Span dataSpan, Span fixSpan, Subrange subrange, boolean isLog) {
        Span span;
        Span span2 = span = dataSpan == null ? PlotUtil.EMPTY_SPAN : dataSpan;
        if (fixSpan != null) {
            span = span.limit(fixSpan.getLow(), fixSpan.getHigh());
        }
        if (subrange == null) {
            return span;
        }
        double[] bounds = span.getFiniteBounds(isLog);
        bounds = PlotUtil.scaleRange(bounds[0], bounds[1], subrange, isLog ? Scale.LOG : Scale.LINEAR);
        return span.limit(bounds[0], bounds[1]);
    }

    public static Set<AuxScale> getMissingScales(PlotLayer[] layers, Map<AuxScale, Span> dataSpans, Map<AuxScale, Span> fixSpans) {
        HashMap reqMap = new HashMap();
        for (PlotLayer layer : layers) {
            Map<AuxScale, AuxReader> auxRangers = layer.getAuxRangers();
            for (Map.Entry<AuxScale, AuxReader> entry : layer.getAuxRangers().entrySet()) {
                AuxScale scale = entry.getKey();
                Scaling scaling = entry.getValue().getScaling();
                if (!reqMap.containsKey(scale)) {
                    reqMap.put(scale, new HashSet());
                }
                ((Collection)reqMap.get(scale)).add(scaling);
            }
        }
        HashSet<AuxScale> missingScales = new HashSet<AuxScale>();
        for (Map.Entry entry : reqMap.entrySet()) {
            AuxScale scale = (AuxScale)entry.getKey();
            Scaling[] scalings = ((Collection)entry.getValue()).toArray(new Scaling[0]);
            if (Scalings.canScale(scalings, dataSpans.get(scale), fixSpans.get(scale))) continue;
            missingScales.add(scale);
        }
        return missingScales;
    }
}

