/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickLook;

@Equality
public class Axis {
    private final int glo_;
    private final int ghi_;
    private final double dlo_;
    private final double dhi_;
    private final Scale scale_;
    private final boolean flip_;
    private final double slo_;
    private final double shi_;
    private final double a_;
    private final double a1_;
    private final double b_;

    public Axis(int glo, int ghi, double dlo, double dhi, Scale scale, boolean flip) {
        if (glo >= ghi) {
            throw new IllegalArgumentException("Bad graphics bounds");
        }
        if (!(dlo < dhi)) {
            throw new IllegalArgumentException("Bad data bounds");
        }
        this.glo_ = glo;
        this.ghi_ = ghi;
        this.dlo_ = dlo;
        this.dhi_ = dhi;
        this.scale_ = scale;
        this.flip_ = flip;
        this.slo_ = this.scale_.dataToScale(this.dlo_);
        this.shi_ = this.scale_.dataToScale(this.dhi_);
        this.a_ = (flip ? -1.0 : 1.0) * (double)(ghi - glo) / (this.shi_ - this.slo_);
        this.a1_ = 1.0 / this.a_;
        this.b_ = (double)(flip ? ghi : glo) - this.a_ * this.slo_;
    }

    public double dataToGraphics(double d) {
        return this.b_ + this.a_ * this.scale_.dataToScale(d);
    }

    public double graphicsToData(double g) {
        return this.scale_.scaleToData((g - this.b_) * this.a1_);
    }

    public double[] dataZoom(double d0, double factor) {
        double[] dArray;
        double f1 = 1.0 / factor;
        double s0 = this.scale_.dataToScale(d0);
        double zlo = this.scale_.scaleToData(s0 + (this.slo_ - s0) * f1);
        double zhi = this.scale_.scaleToData(s0 + (this.shi_ - s0) * f1);
        double d = this.scale_.isPositiveDefinite() ? Double.MIN_VALUE : -1.7976931348623157E308;
        if (zlo > d && zhi < Double.MAX_VALUE) {
            double[] dArray2 = new double[2];
            dArray2[0] = zlo;
            dArray = dArray2;
            dArray2[1] = zhi;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = this.dlo_;
            dArray = dArray3;
            dArray3[1] = this.dhi_;
        }
        return dArray;
    }

    public double[] dataPan(double d0, double d1) {
        double[] dArray;
        double s0 = this.scale_.dataToScale(d0);
        double s1 = this.scale_.dataToScale(d1);
        double s10 = s1 - s0;
        double plo = this.scale_.scaleToData(this.slo_ - s10);
        double phi = this.scale_.scaleToData(this.shi_ - s10);
        double d = this.scale_.isPositiveDefinite() ? Double.MIN_VALUE : -1.7976931348623157E308;
        if (plo > d && phi < Double.MAX_VALUE) {
            double[] dArray2 = new double[2];
            dArray2[0] = plo;
            dArray = dArray2;
            dArray2[1] = phi;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = this.dlo_;
            dArray = dArray3;
            dArray3[1] = this.dhi_;
        }
        return dArray;
    }

    public int[] getGraphicsLimits() {
        return new int[]{this.glo_, this.ghi_};
    }

    public double[] getDataLimits() {
        return new double[]{this.dlo_, this.dhi_};
    }

    public Scale getScale() {
        return this.scale_;
    }

    public boolean isFlip() {
        return this.flip_;
    }

    public void drawLabels(Tick[] ticks, String title, Captioner captioner, TickLook tickLook, Orientation orient, boolean invert, Graphics g) {
        this.calculateLabels(ticks, title, captioner, tickLook, orient, invert, g);
    }

    public Rectangle getLabelBounds(Tick[] ticks, String title, Captioner captioner, Orientation orient, boolean invert) {
        return this.calculateLabels(ticks, title, captioner, TickLook.NONE, orient, invert, null);
    }

    public int hashCode() {
        int code = 22985;
        code = 23 * code + this.glo_;
        code = 23 * code + this.ghi_;
        code = 23 * code + Float.floatToIntBits((float)this.dlo_);
        code = 23 * code + Float.floatToIntBits((float)this.dhi_);
        code = 23 * code + this.scale_.hashCode();
        code = 23 * code + (this.flip_ ? 11 : 17);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof Axis) {
            Axis other = (Axis)o;
            return this.glo_ == other.glo_ && this.ghi_ == other.ghi_ && this.dlo_ == other.dlo_ && this.dhi_ == other.dhi_ && this.scale_.equals(other.scale_) && this.flip_ == other.flip_;
        }
        return false;
    }

    private Rectangle calculateLabels(Tick[] ticks, String title, Captioner captioner, TickLook tickLook, Orientation orient, boolean invert, Graphics g) {
        double det0;
        boolean hasGraphics = g != null;
        Graphics2D g2 = hasGraphics ? (Graphics2D)g : null;
        AffineTransform trans0 = hasGraphics ? g2.getTransform() : null;
        double d = det0 = trans0 == null ? 0.0 : trans0.getDeterminant();
        if (Double.isNaN(det0) || det0 == 0.0) {
            hasGraphics = false;
            trans0 = null;
        }
        int cpad = captioner.getPad();
        Rectangle textBounds = null;
        Rectangle tickBounds = new Rectangle();
        AffineTransform upTrans = AffineTransform.getScaleInstance(1.0, orient.isDown() ? -1.0 : 1.0);
        for (int it = 0; it < ticks.length; ++it) {
            AffineTransform oTrans;
            Tick tick = ticks[it];
            Caption label = tick.getLabel();
            boolean hasText = label != null && label.toText().trim().length() > 0;
            int gx = (int)this.dataToGraphics(tick.getValue());
            double tx = invert ? (double)(this.ghi_ - gx) : (double)(gx - this.glo_);
            AffineTransform tTrans = AffineTransform.getTranslateInstance(tx, 0.0);
            Rectangle cbounds = hasText ? captioner.getCaptionBounds(label) : null;
            AffineTransform affineTransform = oTrans = hasText ? orient.captionTransform(cbounds, cpad) : null;
            if (hasText) {
                Rectangle box = Axis.combineTrans(tTrans, oTrans).createTransformedShape(cbounds).getBounds();
                tickBounds.add(box);
            }
            if (!hasGraphics) continue;
            g2.setTransform(Axis.combineTrans(trans0, tTrans, upTrans));
            if (label != null) {
                tickLook.drawMajor(g2);
                if (hasText) {
                    g2.setTransform(Axis.combineTrans(trans0, tTrans, oTrans));
                    captioner.drawCaption(label, g2);
                }
            } else {
                tickLook.drawMinor(g2);
            }
            g2.setTransform(trans0);
        }
        if (hasGraphics) {
            g2.setTransform(trans0);
        }
        textBounds = Axis.combineRect(textBounds, tickBounds);
        if (title != null && title.length() > 0) {
            Caption titleCap = Caption.createCaption(title);
            Rectangle cbounds = captioner.getCaptionBounds(titleCap);
            int tx = (this.ghi_ - this.glo_) / 2 - cbounds.width / 2;
            int ty = orient.isDown() ? tickBounds.height + cpad - cbounds.y : -tickBounds.height - cpad - cbounds.height - cbounds.y;
            AffineTransform tTrans = AffineTransform.getTranslateInstance(tx, ty);
            if (hasGraphics) {
                g2.setTransform(Axis.combineTrans(trans0, tTrans));
                captioner.drawCaption(titleCap, g2);
                g2.setTransform(trans0);
            }
            Rectangle titleBounds = Axis.combineTrans(tTrans).createTransformedShape(cbounds).getBounds();
            textBounds = Axis.combineRect(textBounds, titleBounds);
        }
        return textBounds;
    }

    private static AffineTransform combineTrans(AffineTransform ... transforms) {
        AffineTransform trans = new AffineTransform();
        for (int i = 0; i < transforms.length; ++i) {
            trans.concatenate(transforms[i]);
        }
        return trans;
    }

    private static Rectangle combineRect(Rectangle r1, Rectangle r2) {
        if (r1 == null) {
            return r2;
        }
        Rectangle rect = new Rectangle(r1);
        if (r2 != null) {
            rect.add(r2);
        }
        return rect;
    }
}

