/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.function.UnaryOperator;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.PlotUtil;

@Equality
public abstract class Caption {
    private final String txt_;

    protected Caption(String txt) {
        this.txt_ = txt;
    }

    public String toText() {
        return this.txt_;
    }

    public abstract String toLatex();

    public Caption append(final Caption other) {
        final Caption first = this;
        return new Caption(first.txt_ + other.txt_){

            @Override
            public String toLatex() {
                return first.toLatex() + other.toLatex();
            }
        };
    }

    public int hashCode() {
        return PlotUtil.hashCode(this.txt_);
    }

    public boolean equals(Object o) {
        if (o instanceof Caption) {
            Caption other = (Caption)o;
            return PlotUtil.equals(this.txt_, other.txt_);
        }
        return false;
    }

    public static Caption createCaption(String txt) {
        return Caption.createCaption(txt, txt);
    }

    public static Caption createCaption(String txt, final String latex) {
        return new Caption(txt){

            @Override
            public String toLatex() {
                return latex;
            }
        };
    }

    public static Caption createCaption(final String txt, final UnaryOperator<String> toLatexFunc) {
        return new Caption(txt){

            @Override
            public String toLatex() {
                return (String)toLatexFunc.apply(txt);
            }
        };
    }
}

