/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

public class DataPosSequence
implements CoordSequence {
    private final int ndim_;
    private final PositionCloud[] clouds_;
    private final DataStore dataStore_;
    private final double[] dpos_;
    private int ic_;
    private int icHi_;
    private DataGeom geom_;
    private int iPosCoord_;
    private TupleSequence tseq_;

    public DataPosSequence(int ndim, PositionCloud[] clouds, DataStore dataStore) {
        this(ndim, clouds, dataStore, 0, clouds.length, null);
    }

    private DataPosSequence(int ndim, PositionCloud[] clouds, DataStore dataStore, int ic, int icHi, TupleSequence tseq) {
        this.ndim_ = ndim;
        this.clouds_ = clouds;
        this.dataStore_ = dataStore;
        this.dpos_ = new double[ndim];
        this.icHi_ = icHi;
        this.setCloudIndex(ic, tseq);
        assert (this.tseq_ != null);
    }

    @Override
    public double[] getCoords() {
        return this.dpos_;
    }

    @Override
    public boolean next() {
        while (this.tseq_.next()) {
            if (!this.geom_.readDataPos(this.tseq_, this.iPosCoord_, this.dpos_)) continue;
            return true;
        }
        if (this.ic_ + 1 < this.icHi_) {
            this.setCloudIndex(this.ic_ + 1, null);
            return this.next();
        }
        return false;
    }

    public DataPosSequence split() {
        int ncloud = this.icHi_ - this.ic_;
        if (ncloud >= 2) {
            int lo = this.ic_;
            int mid = (this.ic_ + this.icHi_) / 2;
            this.setCloudIndex(mid, null);
            return new DataPosSequence(this.ndim_, this.clouds_, this.dataStore_, lo, mid, null);
        }
        if (ncloud == 1) {
            TupleSequence tseq1 = (TupleSequence)this.tseq_.split();
            return tseq1 == null ? null : new DataPosSequence(this.ndim_, this.clouds_, this.dataStore_, this.ic_, this.icHi_, tseq1);
        }
        return null;
    }

    public long splittableSize() {
        long count = this.tseq_.splittableSize();
        for (int i = this.ic_ + 1; i < this.icHi_; ++i) {
            long nrow = this.clouds_[i].getTupleCount();
            if (nrow < 0L) {
                return -1L;
            }
            count += nrow;
        }
        return count;
    }

    private void setCloudIndex(int ic, TupleSequence tseq) {
        this.ic_ = ic;
        if (ic < this.icHi_) {
            PositionCloud cloud = this.clouds_[ic];
            this.geom_ = cloud.getDataGeom();
            this.iPosCoord_ = cloud.getPosCoordIndex();
            this.tseq_ = tseq == null ? cloud.createTupleSequence(this.dataStore_) : tseq;
        } else {
            this.tseq_ = PlotUtil.EMPTY_TUPLE_SEQUENCE;
        }
    }

    public static interface PositionCloud {
        public int getPosCoordIndex();

        public DataGeom getDataGeom();

        public TupleSequence createTupleSequence(DataStore var1);

        public long getTupleCount();
    }
}

