/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import uk.ac.starlink.ttools.plot2.BasicRanger;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;

public class HistoRanger
implements Ranger {
    private final int nStore_;
    private final int nQuantile_;
    private final double[] samples_;
    private final Distributor distributor_;

    public HistoRanger(int nStore, int nQuantile) {
        this.nStore_ = nStore;
        this.nQuantile_ = nQuantile;
        this.samples_ = new double[this.nStore_];
        this.distributor_ = HistoRanger.createDistributor(this.samples_);
    }

    @Override
    public void submitDatum(double d) {
        if (PlotUtil.isFinite(d)) {
            this.distributor_.submit(d);
        }
    }

    @Override
    public void add(Ranger other) {
        this.distributor_.add(((HistoRanger)other).distributor_);
    }

    @Override
    public Ranger createCompatibleRanger() {
        return new HistoRanger(this.nStore_, this.nQuantile_);
    }

    @Override
    public Span createSpan() {
        int nSamp = this.distributor_.getSampleCount();
        Arrays.sort(this.samples_, 0, nSamp);
        double[] sortedQuantiles = HistoRanger.getSortedQuantiles(this.samples_, nSamp, this.nQuantile_);
        int nq = sortedQuantiles.length;
        if (nq > 2 && sortedQuantiles[nq - 1] > sortedQuantiles[0]) {
            return new HistoSpan(sortedQuantiles);
        }
        BasicRanger ranger = new BasicRanger(true);
        for (int i = 0; i < nSamp; ++i) {
            ranger.submitDatum(this.samples_[i]);
        }
        return ranger.createSpan();
    }

    public static boolean canScaleHistograms(Span span) {
        return span instanceof HistoSpan;
    }

    private static double[] getSortedQuantiles(double[] sortedSamples, int nSample, int nQuantile) {
        int step = Math.max(1, nSample / nQuantile);
        int nq = (nSample + step - 1) / step;
        double[] quantiles = new double[nq];
        for (int iq = 0; iq < nq; ++iq) {
            quantiles[iq] = sortedSamples[iq * step];
        }
        return quantiles;
    }

    private static int getArrayIndex(double[] sortedArray, double point) {
        int ix = Arrays.binarySearch(sortedArray, point);
        return ix >= 0 ? ix : Math.min(-ix - 1, sortedArray.length - 1);
    }

    static Distributor createDistributor(double[] array) {
        return new DefaultDistributor(array);
    }

    private static boolean[] createRandomMask(int nf, double p) {
        ArrayList<Integer> ilist = new ArrayList<Integer>();
        for (int i = 0; i < nf; ++i) {
            ilist.add(i);
        }
        Collections.shuffle(ilist, new Random(Double.doubleToLongBits(p)));
        boolean[] mask = new boolean[nf];
        int i = 0;
        while ((double)i < p * (double)nf) {
            mask[i] = true;
            ++i;
        }
        return mask;
    }

    private static class HistoScaler
    implements Scaler {
        final int ilo_;
        final int ihi_;
        final double lo_;
        final double hi_;
        final double[] sortedQuantiles_;
        final int dataHash_;
        final boolean isLogLike_;
        final double nq1_;
        final double loval_;
        final double hival_;

        HistoScaler(int ilo, int ihi, double lo, double hi, double[] sortedQuantiles, int dataHash, boolean isLogLike) {
            this.ilo_ = ilo;
            this.ihi_ = ihi;
            this.lo_ = lo;
            this.hi_ = hi;
            this.sortedQuantiles_ = sortedQuantiles;
            this.dataHash_ = dataHash;
            this.isLogLike_ = isLogLike;
            this.nq1_ = 1.0 / (double)(this.ihi_ - this.ilo_);
            this.loval_ = Math.max(this.lo_, sortedQuantiles[0]);
            this.hival_ = Math.min(this.hi_, sortedQuantiles[sortedQuantiles.length - 1]);
        }

        @Override
        public double getLow() {
            return this.lo_;
        }

        @Override
        public double getHigh() {
            return this.hi_;
        }

        @Override
        public boolean isLogLike() {
            return this.isLogLike_;
        }

        @Override
        public double scaleValue(double val) {
            if (val <= this.loval_) {
                return 0.0;
            }
            if (val >= this.hival_) {
                return 1.0;
            }
            if (Double.isNaN(val)) {
                return Double.NaN;
            }
            int j = Arrays.binarySearch(this.sortedQuantiles_, this.ilo_, this.ihi_, val);
            if (j >= 0) {
                assert (j >= this.ilo_ && j <= this.ihi_);
                return (double)(j - this.ilo_) * this.nq1_;
            }
            int jb = -j - 1;
            int ja = jb - 1;
            double va = this.sortedQuantiles_[ja];
            double vb = this.sortedQuantiles_[jb];
            double v = ((double)ja + (val - va) / (vb - va) - (double)this.ilo_) * this.nq1_;
            return Math.max(0.0, Math.min(1.0, v));
        }

        public int hashCode() {
            int code = 44223;
            code = 23 * code + this.ilo_;
            code = 23 * code + this.ihi_;
            code = 23 * code + Float.floatToIntBits((float)this.lo_);
            code = 23 * code + Float.floatToIntBits((float)this.hi_);
            code = 23 * code + this.dataHash_;
            code = 23 * code + (this.isLogLike_ ? 99 : 101);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof HistoScaler) {
                HistoScaler other = (HistoScaler)o;
                return this.ilo_ == other.ilo_ && this.ihi_ == other.ihi_ && this.lo_ == other.lo_ && this.hi_ == other.hi_ && this.dataHash_ == other.dataHash_ && this.isLogLike_ == other.isLogLike_ && Arrays.equals(this.sortedQuantiles_, other.sortedQuantiles_);
            }
            return false;
        }
    }

    private static class HistoSpan
    implements Span {
        private final double[] sortedQuantiles_;
        private final int dataHash_;
        private final double lo_;
        private final double hi_;
        private final int ilo_;
        private final int ihi_;

        HistoSpan(double[] sortedQuantiles) {
            this(sortedQuantiles, Arrays.hashCode(sortedQuantiles), sortedQuantiles[0], sortedQuantiles[sortedQuantiles.length - 1]);
        }

        HistoSpan(double[] sortedQuantiles, int dataHash, double lo, double hi) {
            this.sortedQuantiles_ = sortedQuantiles;
            this.dataHash_ = dataHash;
            this.lo_ = lo;
            this.hi_ = hi;
            int nq = this.sortedQuantiles_.length;
            this.ilo_ = HistoRanger.getArrayIndex(this.sortedQuantiles_, lo);
            this.ihi_ = HistoRanger.getArrayIndex(this.sortedQuantiles_, hi);
        }

        @Override
        public double getLow() {
            return this.lo_;
        }

        @Override
        public double getHigh() {
            return this.hi_;
        }

        @Override
        public double[] getFiniteBounds(boolean isPositive) {
            int jlo;
            double lo = isPositive && this.lo_ <= 0.0 ? ((jlo = Arrays.binarySearch(this.sortedQuantiles_, this.ilo_, this.ihi_, Double.MIN_VALUE)) == -this.sortedQuantiles_.length - 1 ? Double.NaN : (jlo < 0 ? this.sortedQuantiles_[-jlo - 1] : this.sortedQuantiles_[jlo])) : this.lo_;
            return BasicRanger.calculateFiniteBounds(lo, this.hi_, isPositive);
        }

        @Override
        public HistoSpan limit(double lo, double hi) {
            return new HistoSpan(this.sortedQuantiles_, this.dataHash_, Double.isNaN(lo) ? this.lo_ : lo, Double.isNaN(hi) ? this.hi_ : hi);
        }

        @Override
        public Scaler createScaler(Scaling scaling, Subrange dataclip) {
            if (scaling instanceof Scaling.HistogramScaling) {
                HistoSpan clipspan;
                boolean isLog = scaling.isLogLike();
                if (Subrange.isIdentity(dataclip)) {
                    clipspan = this;
                } else {
                    double[] cliprange = PlotUtil.scaleRange(this.lo_, this.hi_, dataclip, isLog ? Scale.LOG : Scale.LINEAR);
                    clipspan = this.limit(cliprange[0], cliprange[1]);
                }
                double[] clipbounds = clipspan.getFiniteBounds(isLog);
                double lo = clipbounds[0];
                double hi = clipbounds[1];
                int ilo = HistoRanger.getArrayIndex(this.sortedQuantiles_, lo);
                int ihi = HistoRanger.getArrayIndex(this.sortedQuantiles_, hi);
                if (ihi - ilo > 2) {
                    return new HistoScaler(ilo, ihi, lo, hi, this.sortedQuantiles_, this.dataHash_, isLog);
                }
                return (isLog ? Scaling.LOG : Scaling.LINEAR).createScaler(lo, hi);
            }
            if (scaling instanceof Scaling.RangeScaling) {
                return BasicRanger.createRangeScaler((Scaling.RangeScaling)scaling, dataclip, this);
            }
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int code = 887267;
            code = 23 * code + this.dataHash_;
            code = 23 * code + Float.floatToIntBits((float)this.lo_);
            code = 23 * code + Float.floatToIntBits((float)this.hi_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof HistoSpan) {
                HistoSpan other = (HistoSpan)o;
                return this == other || this.lo_ == other.lo_ && this.hi_ == other.hi_ && this.dataHash_ == other.dataHash_ && Arrays.equals(this.sortedQuantiles_, other.sortedQuantiles_);
            }
            return false;
        }
    }

    private static class DefaultDistributor
    implements Distributor {
        private final double[] array_;
        private final int nStore_;
        private long iData_;
        private int iStore_;
        private int iStep_;
        private static final int NF = 100;

        DefaultDistributor(double[] array) {
            this.array_ = array;
            this.nStore_ = array.length;
            this.iStep_ = 1;
        }

        @Override
        public void submit(double val) {
            if (this.iData_++ % (long)this.iStep_ == 0L) {
                if (this.iStore_ < this.nStore_) {
                    this.array_[this.iStore_] = val;
                    this.iStore_ += this.iStep_;
                } else {
                    ++this.iStep_;
                    this.iStore_ = this.iStep_ / 2;
                }
            }
        }

        @Override
        public int getSampleCount() {
            return this.iData_ < (long)this.nStore_ ? (int)this.iData_ : this.nStore_;
        }

        @Override
        public void add(Distributor otherDist) {
            DefaultDistributor other = (DefaultDistributor)otherDist;
            if (other.nStore_ != this.nStore_) {
                throw new IllegalArgumentException("Incompatible");
            }
            long nd0 = this.iData_;
            long nd1 = other.iData_;
            if (nd1 == 0L) {
                return;
            }
            if (nd0 == 0L) {
                this.iData_ = other.iData_;
                this.iStore_ = other.iStore_;
                this.iStep_ = other.iStep_;
                System.arraycopy(other.array_, 0, this.array_, 0, other.getSampleCount());
                return;
            }
            if (nd0 + nd1 < (long)this.nStore_) {
                assert (this.iStep_ == 1 && other.iStep_ == 1);
                System.arraycopy(other.array_, 0, this.array_, this.iStore_, other.iStore_);
                this.iStore_ += other.iStore_;
                this.iData_ += other.iData_;
                return;
            }
            int nf = 100;
            double frac1 = (double)nd1 / (double)(nd0 + nd1);
            if ((double)nf * frac1 < 1.0) {
                return;
            }
            boolean[] mask = HistoRanger.createRandomMask(nf, frac1);
            if (frac1 * (double)nd1 < (double)((long)this.nStore_ - nd0)) {
                int ns = other.getSampleCount();
                for (int i = 0; i < ns && this.iStore_ < this.nStore_; ++i) {
                    if (!mask[i % nf]) continue;
                    this.array_[this.iStore_++] = other.array_[i];
                }
            } else {
                int ns = Math.min(this.getSampleCount(), other.getSampleCount());
                for (int i = 0; i < ns; ++i) {
                    if (!mask[i % nf]) continue;
                    this.array_[i] = other.array_[i];
                }
            }
        }
    }

    static interface Distributor {
        public void submit(double var1);

        public void add(Distributor var1);

        public int getSampleCount();
    }
}

