/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class LabelledLine {
    private final Point2D[] gps_;
    private final String label_;

    public LabelledLine(Point2D gp0, Point2D gp1, String label) {
        this(new Point2D[]{gp0, gp1}, label);
    }

    public LabelledLine(Point2D[] gps, String label) {
        if (gps.length < 2) {
            throw new IllegalArgumentException("Not enough points");
        }
        this.gps_ = gps;
        this.label_ = label;
    }

    public Point2D[] getPoints() {
        return this.gps_;
    }

    public String getLabel() {
        return this.label_;
    }

    public void drawLine(Graphics2D g2) {
        g2.draw(this.getPath());
    }

    public Path2D getPath() {
        int np = this.gps_.length;
        Path2D.Double path = new Path2D.Double(1, np);
        boolean brk = true;
        for (Point2D gp : this.gps_) {
            if (gp != null) {
                double gx = gp.getX();
                double gy = gp.getY();
                if (brk) {
                    path.moveTo(gx, gy);
                } else {
                    path.lineTo(gx, gy);
                }
            }
            brk = gp == null;
        }
        return path;
    }

    public void drawLabel(Graphics2D g2, Color bg) {
        if (this.label_ == null) {
            return;
        }
        int np = this.gps_.length;
        if (np == 2) {
            this.drawLabel(g2, bg, this.gps_[0], this.gps_[1], 0.5);
        } else {
            double[] dists = new double[np];
            for (int ip = 1; ip < np; ++ip) {
                Point2D gpA = this.gps_[ip - 1];
                Point2D gpB = this.gps_[ip - 0];
                double d = gpA == null || gpB == null ? 0.0 : Math.hypot(gpB.getX() - gpA.getX(), gpB.getY() - gpA.getY());
                dists[ip] = dists[ip - 1] + d;
            }
            double half = 0.5 * dists[np - 1];
            for (int ip = 1; ip < np; ++ip) {
                if (!(dists[ip] >= half)) continue;
                this.drawLabel(g2, bg, this.gps_[ip - 1], this.gps_[ip], (half - dists[ip - 1]) / (dists[ip] - dists[ip - 1]));
                return;
            }
            assert (false);
        }
    }

    private void drawLabel(Graphics2D g2, Color bg, Point2D gp0, Point2D gp1, double frac) {
        g2 = (Graphics2D)g2.create();
        double gx0 = gp0.getX();
        double gy0 = gp0.getY();
        double gx1 = gp1.getX();
        double gy1 = gp1.getY();
        boolean flip = gx0 == gx1 ? gy0 > gy1 : gx0 > gx1;
        double gxA = flip ? gx1 : gx0;
        double gyA = flip ? gy1 : gy0;
        double gxB = flip ? gx0 : gx1;
        double gyB = flip ? gy0 : gy1;
        g2.translate(PlotUtil.scaleValue(gx0, gx1, frac), PlotUtil.scaleValue(gy0, gy1, frac));
        g2.rotate(Math.atan2(gyB - gyA, gxB - gxA));
        FontMetrics fm = g2.getFontMetrics();
        g2.translate(-fm.stringWidth(this.label_) / 2, -3);
        if (bg != null) {
            Color color0 = g2.getColor();
            g2.setColor(bg);
            g2.fill(fm.getStringBounds(this.label_, g2).getBounds());
            g2.setColor(color0);
        }
        g2.drawString(this.label_, 0, 0);
    }

    public String toString() {
        return this.label_ + ": " + this.gps_[0] + "->" + this.gps_[this.gps_.length - 1];
    }
}

