/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.IndicatedRow;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotCaching;
import uk.ac.starlink.ttools.plot2.PlotFrame;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.ShadeAxisKit;
import uk.ac.starlink.ttools.plot2.SingleGangerFactory;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.util.Bi;
import uk.ac.starlink.util.Util;

public class PlotScene<P, A> {
    private final Ganger<P, A> ganger_;
    private final SurfaceFactory<P, A> surfFact_;
    private final int nz_;
    private final PaperTypeSelector ptSel_;
    private final Compositor compositor_;
    private final boolean surfaceAuxRanging_;
    private final boolean cacheImage_;
    private final Zone<P, A>[] zones_;
    private final Trimming globalTrimming_;
    private final ShadeAxisKit globalShadeKit_;
    private final Set<Object> plans_;
    private Span globalShadeSpan_;
    private ShadeAxis globalShadeAxis_;
    private Gang gang_;
    private static final boolean WITH_SCROLL = true;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.task");

    public PlotScene(Ganger<P, A> ganger, SurfaceFactory<P, A> surfFact, ZoneContent<P, A>[] zoneContents, Trimming[] trimmings, ShadeAxisKit[] shadeKits, PaperTypeSelector ptSel, Compositor compositor, PlotCaching caching) {
        this.ganger_ = ganger;
        this.surfFact_ = surfFact;
        this.nz_ = ganger.getZoneCount();
        boolean isTrimGlobal = ganger.isTrimmingGlobal();
        boolean isShadeGlobal = ganger.isShadingGlobal();
        if (zoneContents.length != this.nz_) {
            throw new IllegalArgumentException("zone count mismatch");
        }
        if (trimmings.length != (isTrimGlobal ? 1 : this.nz_)) {
            throw new IllegalArgumentException("trimmings count mismatch");
        }
        if (shadeKits.length != (isShadeGlobal ? 1 : this.nz_)) {
            throw new IllegalArgumentException("shadings count mismatch");
        }
        this.globalTrimming_ = isTrimGlobal ? trimmings[0] : null;
        this.globalShadeKit_ = isShadeGlobal ? shadeKits[0] : null;
        Zone[] zs = new Zone[this.nz_];
        this.zones_ = zs;
        P[] initialProfiles = PlotUtil.createProfileArray(surfFact, this.nz_);
        A[] initialAspects = PlotUtil.createAspectArray(surfFact, this.nz_);
        for (int iz = 0; iz < this.nz_; ++iz) {
            ZoneContent<P, A> content = zoneContents[iz];
            initialProfiles[iz] = content.getProfile();
            initialAspects[iz] = content.getAspect();
        }
        P[] okProfiles = ganger.adjustProfiles(initialProfiles);
        A[] okAspects = ganger.adjustAspects(initialAspects, -1);
        for (int iz = 0; iz < this.nz_; ++iz) {
            this.zones_[iz] = new Zone<P, A>(zoneContents[iz].getLayers(), okProfiles[iz], isTrimGlobal ? null : trimmings[iz], isShadeGlobal ? null : shadeKits[iz], okAspects[iz]);
        }
        this.ptSel_ = ptSel;
        this.compositor_ = compositor;
        this.surfaceAuxRanging_ = !caching.getReuseRanges();
        this.cacheImage_ = caching.getCacheImage();
        this.plans_ = caching.getUsePlans() ? new HashSet() : null;
    }

    public PlotScene(SurfaceFactory<P, A> surfFact, ZoneContent<P, A> content, Trimming trimming, ShadeAxisKit shadeKit, PaperTypeSelector ptSel, Compositor compositor, Padding padding, PlotCaching caching) {
        this(SingleGangerFactory.createGanger(padding), surfFact, PlotUtil.singletonArray(content), new Trimming[]{trimming}, new ShadeAxisKit[]{shadeKit}, ptSel, compositor, caching);
    }

    public Ganger<P, A> getGanger() {
        return this.ganger_;
    }

    public Gang getGang() {
        return this.gang_;
    }

    public PlotLayer[] getLayers(int iz) {
        return this.zones_[iz].layers_;
    }

    public void clearPlot() {
        for (Zone<P, A> zone : this.zones_) {
            zone.surface_ = null;
            zone.icon_ = null;
        }
    }

    @Slow
    public void prepareScene(Rectangle extBounds, DataStore dataStore) {
        Zone<P, A>[] zone;
        int iz;
        Rectangle[] dataBoxes = new Rectangle[this.nz_];
        boolean gotSurfs = true;
        for (int iz2 = 0; iz2 < this.nz_ && gotSurfs; ++iz2) {
            Surface surf = this.zones_[iz2].surface_;
            if (surf != null) {
                dataBoxes[iz2] = surf.getPlotBounds();
                continue;
            }
            this.zones_[iz2].icon_ = null;
            gotSurfs = false;
        }
        Gang gang = gotSurfs ? this.ganger_.createGang(dataBoxes) : null;
        Gang approxGang = gang != null ? gang : this.createGang(extBounds);
        long rangeStart = System.currentTimeMillis();
        boolean surfChanged = false;
        Object[] plans = this.plans_ == null ? null : this.plans_.toArray();
        for (iz = 0; iz < this.nz_; ++iz) {
            zone = this.zones_[iz];
            if (zone.surface_ != null) continue;
            Surface oldApproxSurf = zone.approxSurf_;
            zone.approxSurf_ = this.surfFact_.createSurface(approxGang.getZonePlotBounds(iz), zone.profile_, zone.aspect_);
            boolean zoneSurfChanged = !zone.approxSurf_.equals(oldApproxSurf);
            boolean bl = surfChanged = surfChanged || zoneSurfChanged;
            if (zone.auxSpans_ != null && (!this.surfaceAuxRanging_ || !zoneSurfChanged)) continue;
            zone.auxSpans_ = PlotScene.calculateNonShadeSpans(zone.layers_, zone.approxSurf_, plans, dataStore);
            ShadeAxisKit shadeKit = zone.shadeKit_;
            if (shadeKit == null) continue;
            ShadeAxisFactory shadeFact = shadeKit.getAxisFactory();
            List<Bi<Surface, PlotLayer>> surfLayers = AuxScale.pairSurfaceLayers(zone.approxSurf_, zone.layers_);
            Span shadeSpan = PlotScene.calculateShadeSpan(surfLayers, shadeKit, plans, dataStore);
            if (shadeSpan != null) {
                zone.auxSpans_.put(AuxScale.COLOR, shadeSpan);
            }
            zone.shadeAxis_ = shadeSpan != null && shadeFact != null ? shadeFact.createShadeAxis(shadeSpan) : null;
        }
        if (this.globalShadeKit_ != null && (this.globalShadeSpan_ == null || this.surfaceAuxRanging_ && surfChanged)) {
            List<Bi<Surface, PlotLayer>> surfLayers = Arrays.stream(this.zones_).flatMap(z -> AuxScale.pairSurfaceLayers(z.approxSurf_, z.layers_).stream()).collect(Collectors.toList());
            this.globalShadeSpan_ = PlotScene.calculateShadeSpan(surfLayers, this.globalShadeKit_, plans, dataStore);
            if (this.globalShadeSpan_ != null) {
                for (Zone<P, A> zone2 : this.zones_) {
                    zone2.auxSpans_.put(AuxScale.COLOR, this.globalShadeSpan_);
                }
            }
            ShadeAxisFactory shadeFact = this.globalShadeKit_.getAxisFactory();
            this.globalShadeAxis_ = this.globalShadeSpan_ != null && shadeFact != null ? shadeFact.createShadeAxis(this.globalShadeSpan_) : null;
        }
        PlotUtil.logTimeFromStart(logger_, "Range", rangeStart);
        if (gang == null) {
            gang = this.createGang(extBounds);
        }
        this.gang_ = gang;
        for (iz = 0; iz < this.nz_; ++iz) {
            zone = this.zones_[iz];
            if (zone.surface_ != null) continue;
            zone.surface_ = this.surfFact_.createSurface(gang.getZonePlotBounds(iz), zone.profile_, zone.aspect_);
        }
    }

    @Slow
    public void paintScene(Graphics g, Rectangle extBounds, DataStore dataStore) {
        this.prepareScene(extBounds, dataStore);
        long planStart = System.currentTimeMillis();
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            if (zone.icon_ != null) continue;
            PlotLayer[] layers = zone.layers_;
            PlotFrame frame = PlotFrame.createPlotFrame(zone.surface_, true);
            Decoration[] decs = PlotPlacement.createPlotDecorations(frame, zone.trimming_, zone.shadeAxis_);
            PlotPlacement placer = new PlotPlacement(extBounds, zone.surface_, decs);
            LayerOpt[] opts = PaperTypeSelector.getOpts(layers);
            PaperType paperType = this.ptSel_.getPixelPaperType(opts, this.compositor_);
            zone.icon_ = PlotUtil.createPlotIcon(placer, layers, zone.auxSpans_, dataStore, paperType, this.cacheImage_, this.plans_);
        }
        PlotUtil.logTimeFromStart(logger_, "Plan", planStart);
        Component component = null;
        long paintStart = System.currentTimeMillis();
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            zone.icon_.paintIcon(component, g, extBounds.x, extBounds.y);
            if (this.cacheImage_) continue;
            zone.icon_ = null;
        }
        if (this.globalTrimming_ != null || this.globalShadeAxis_ != null) {
            Decoration[] decs;
            Surface[] surfs = (Surface[])Arrays.stream(this.zones_).map(z -> z.surface_).toArray(Surface[]::new);
            PlotFrame extFrame = PlotFrame.createPlotFrame(surfs, true, extBounds);
            for (Decoration dec : decs = PlotPlacement.createPlotDecorations(extFrame, this.globalTrimming_, this.globalShadeAxis_)) {
                dec.paintDecoration(g);
            }
        }
        PlotUtil.logTimeFromStart(logger_, "Paint", paintStart);
    }

    public boolean setAspects(A[] aspects) {
        Object[] oldAspects = (Object[])aspects.clone();
        Arrays.fill(oldAspects, null);
        boolean changed = false;
        for (int iz = 0; iz < this.nz_; ++iz) {
            Zone<P, A> zone = this.zones_[iz];
            oldAspects[iz] = zone.aspect_;
            A aspect = aspects[iz];
            if (aspect == null || aspect.equals(zone.aspect_)) continue;
            zone.aspect_ = aspect;
            zone.surface_ = null;
            zone.icon_ = null;
            changed = true;
        }
        return changed;
    }

    public A[] getAspects() {
        A[] aspects = PlotUtil.createAspectArray(this.surfFact_, this.nz_);
        for (int iz = 0; iz < this.nz_; ++iz) {
            aspects[iz] = this.zones_[iz].aspect_;
        }
        return aspects;
    }

    public Surface[] getSurfaces() {
        Surface[] surfs = new Surface[this.nz_];
        for (int iz = 0; iz < this.nz_; ++iz) {
            surfs[iz] = this.zones_[iz].surface_;
        }
        return surfs;
    }

    public int getZoneIndex(Point pos) {
        for (int iz = 0; iz < this.nz_; ++iz) {
            Surface surf = this.zones_[iz].surface_;
            if (surf == null || !surf.getPlotBounds().contains(pos)) continue;
            return iz;
        }
        return -1;
    }

    private Gang createGang(Rectangle extBounds) {
        ShadeAxis[] shadeAxisArray;
        Trimming[] trimmings;
        Trimming[] trimmingArray;
        ZoneContent[] contents = (ZoneContent[])Arrays.stream(this.zones_).map(z -> new ZoneContent(z.profile_, z.aspect_, z.layers_)).toArray(n -> PlotUtil.createZoneContentArray(this.surfFact_, n));
        if (this.ganger_.isTrimmingGlobal()) {
            Trimming[] trimmingArray2 = new Trimming[1];
            trimmingArray = trimmingArray2;
            trimmingArray2[0] = this.globalTrimming_;
        } else {
            trimmingArray = trimmings = (Trimming[])Arrays.stream(this.zones_).map(z -> z.trimming_).toArray(Trimming[]::new);
        }
        if (this.ganger_.isShadingGlobal()) {
            ShadeAxis[] shadeAxisArray2 = new ShadeAxis[1];
            shadeAxisArray = shadeAxisArray2;
            shadeAxisArray2[0] = this.globalShadeAxis_;
        } else {
            shadeAxisArray = (ShadeAxis[])Arrays.stream(this.zones_).map(z -> z.shadeAxis_).toArray(ShadeAxis[]::new);
        }
        ShadeAxis[] shadeAxes = shadeAxisArray;
        return this.ganger_.createGang(extBounds, this.surfFact_, contents, trimmings, shadeAxes, true);
    }

    @Slow
    public IndicatedRow[] findClosestRows(Surface surface, PlotLayer[] layers, Point point, DataStore dataStore) {
        int nl = layers.length;
        SubCloud[][] layerClouds = new SubCloud[nl][];
        LinkedHashMap<SubCloud, IndicatedRow> cloudMap = new LinkedHashMap<SubCloud, IndicatedRow>();
        for (int il = 0; il < nl; ++il) {
            SubCloud[] clouds = SubCloud.createSubClouds(new PlotLayer[]{layers[il]}, true);
            layerClouds[il] = clouds;
            for (SubCloud cloud : clouds) {
                cloudMap.put(cloud, null);
            }
        }
        for (SubCloud cloud : cloudMap.keySet()) {
            DataGeom geom = cloud.getDataGeom();
            int iPosCoord = cloud.getPosCoordIndex();
            Supplier<TupleSequence> tupleSupplier = () -> dataStore.getTupleSequence(cloud.getDataSpec());
            cloudMap.put(cloud, PlotUtil.getClosestRow(surface, geom, iPosCoord, tupleSupplier, dataStore.getTupleRunner(), point));
        }
        IndicatedRow[] closestRows = new IndicatedRow[nl];
        for (int il = 0; il < nl; ++il) {
            IndicatedRow bestRow = null;
            for (SubCloud cloud : layerClouds[il]) {
                double dist;
                IndicatedRow row = (IndicatedRow)cloudMap.get(cloud);
                if (row == null || !((dist = row.getDistance()) <= 4.0) || bestRow != null && !(dist < bestRow.getDistance())) continue;
                bestRow = row;
            }
            closestRows[il] = bestRow;
        }
        return Thread.currentThread().isInterrupted() ? null : closestRows;
    }

    @Slow
    public static <P, A> PlotScene<P, A> createGangScene(Ganger<P, A> ganger, SurfaceFactory<P, A> surfFact, PlotLayer[][] layerArrays, P[] profiles, ConfigMap[] aspectConfigs, Trimming[] trimmings, ShadeAxisKit[] shadeKits, PaperTypeSelector ptSel, Compositor compositor, DataStore dataStore, PlotCaching caching) {
        int nz = ganger.getZoneCount();
        long t0 = System.currentTimeMillis();
        A[] initialAspects = PlotUtil.createAspectArray(surfFact, nz);
        for (int iz = 0; iz < nz; ++iz) {
            PlotLayer[] layers = layerArrays[iz];
            P profile = profiles[iz];
            ConfigMap config = aspectConfigs[iz];
            Range[] ranges = surfFact.useRanges(profile, config) ? surfFact.readRanges(profile, layers, dataStore) : null;
            initialAspects[iz] = surfFact.createAspect(profile, config, ranges);
        }
        PlotUtil.logTimeFromStart(logger_, "Range", t0);
        A[] aspects = ganger.adjustAspects(initialAspects, -1);
        ZoneContent<P, A>[] contents = PlotUtil.createZoneContentArray(surfFact, nz);
        for (int iz = 0; iz < nz; ++iz) {
            contents[iz] = new ZoneContent<P, A>(profiles[iz], aspects[iz], layerArrays[iz]);
        }
        return new PlotScene<P, A>(ganger, surfFact, contents, trimmings, shadeKits, ptSel, compositor, caching);
    }

    @Slow
    public static Map<AuxScale, Span> calculateNonShadeSpans(PlotLayer[] layers, Surface surface, Object[] plans, DataStore dataStore) {
        AuxScale[] scales = (AuxScale[])Arrays.stream(AuxScale.getAuxScales(layers)).filter(s -> !Util.equals((Object)s, (Object)AuxScale.COLOR)).toArray(AuxScale[]::new);
        plans = plans == null ? new Object[]{} : plans;
        long start = System.currentTimeMillis();
        List<Bi<Surface, PlotLayer>> surfLayers = AuxScale.pairSurfaceLayers(surface, layers);
        return AuxScale.calculateAuxSpans(scales, surfLayers, plans, dataStore);
    }

    @Slow
    public static Span calculateShadeSpan(List<Bi<Surface, PlotLayer>> surfLayers, ShadeAxisKit shadeKit, Object[] plans, DataStore dataStore) {
        boolean requireColor;
        Span shadeFixSpan;
        PlotLayer[] layers = (PlotLayer[])surfLayers.stream().map(Bi::getItem2).toArray(PlotLayer[]::new);
        Map<AuxScale, Span> dataSpans = Collections.emptyMap();
        HashMap<AuxScale, Span> auxFixSpans = new HashMap<AuxScale, Span>();
        Span span = shadeFixSpan = shadeKit == null ? null : shadeKit.getFixSpan();
        if (shadeFixSpan != null) {
            auxFixSpans.put(AuxScale.COLOR, shadeFixSpan);
        }
        if (requireColor = AuxScale.getMissingScales(layers, dataSpans, auxFixSpans).contains(AuxScale.COLOR)) {
            long start = System.currentTimeMillis();
            plans = plans == null ? new Object[]{} : plans;
            Span shadeDataSpan = AuxScale.calculateAuxSpans(new AuxScale[]{AuxScale.COLOR}, surfLayers, plans, dataStore).get(AuxScale.COLOR);
            ShadeAxisFactory shadeFact = shadeKit == null ? null : shadeKit.getAxisFactory();
            Subrange shadeSubrange = shadeKit == null ? null : shadeKit.getSubrange();
            boolean shadeLog = shadeFact != null && shadeFact.isLog();
            PlotUtil.logTimeFromStart(logger_, "AuxRange.COLOR", start);
            return AuxScale.clipSpan(shadeDataSpan, shadeFixSpan, shadeSubrange, shadeLog);
        }
        return shadeFixSpan;
    }

    private static class Zone<P, A> {
        final PlotLayer[] layers_;
        final P profile_;
        final Trimming trimming_;
        final ShadeAxisKit shadeKit_;
        A aspect_;
        Map<AuxScale, Span> auxSpans_;
        Surface approxSurf_;
        ShadeAxis shadeAxis_;
        Surface surface_;
        Icon icon_;

        Zone(PlotLayer[] layers, P profile, Trimming trimming, ShadeAxisKit shadeKit, A initialAspect) {
            this.layers_ = layers;
            this.profile_ = profile;
            this.trimming_ = trimming;
            this.shadeKit_ = shadeKit;
            this.aspect_ = initialAspect;
        }
    }
}

