/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.DataPosSequence;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

@Equality
public class PointCloud {
    private final int ndim_;
    private final SubCloud[] subClouds_;

    public PointCloud(SubCloud[] subClouds) {
        this.subClouds_ = subClouds;
        this.ndim_ = subClouds.length > 0 ? subClouds[0].getDataGeom().getDataDimCount() : 0;
    }

    public PointCloud(SubCloud subCloud) {
        this(new SubCloud[]{subCloud});
    }

    public Supplier<CoordSequence> createDataPosSupplier(DataStore dataStore) {
        int nc = this.subClouds_.length;
        DataPosSequence.PositionCloud[] pclouds = new DataPosSequence.PositionCloud[nc];
        for (int ic = 0; ic < nc; ++ic) {
            final SubCloud subCloud = this.subClouds_[ic];
            final DataSpec dataSpec = subCloud.getDataSpec();
            pclouds[ic] = new DataPosSequence.PositionCloud(){

                @Override
                public int getPosCoordIndex() {
                    return subCloud.getPosCoordIndex();
                }

                @Override
                public DataGeom getDataGeom() {
                    return subCloud.getDataGeom();
                }

                @Override
                public TupleSequence createTupleSequence(DataStore dstore) {
                    return dstore.getTupleSequence(dataSpec);
                }

                @Override
                public long getTupleCount() {
                    return dataSpec.getSourceTable().getRowCount();
                }
            };
        }
        return () -> new DataPosSequence(this.ndim_, pclouds, dataStore);
    }

    public SubCloud[] getSubClouds() {
        return this.subClouds_;
    }

    public int hashCode() {
        int code = 74433;
        code = 23 * code + PointCloud.unorderedHashCode(this.subClouds_);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof PointCloud) {
            PointCloud other = (PointCloud)o;
            assert (PointCloud.unorderedEquals(this.subClouds_, other.subClouds_) == PointCloud.unorderedEquals(other.subClouds_, this.subClouds_));
            return PointCloud.unorderedEquals(this.subClouds_, other.subClouds_);
        }
        return false;
    }

    private static int unorderedHashCode(Object[] array) {
        int code = 0;
        for (int i = 0; i < array.length; ++i) {
            code += array[i].hashCode();
        }
        return code;
    }

    private static boolean unorderedEquals(Object[] array1, Object[] array2) {
        if (Arrays.equals(array1, array2)) {
            return true;
        }
        if (array1.length != array2.length) {
            return false;
        }
        ArrayList<Object> l2 = new ArrayList<Object>(Arrays.asList(array2));
        for (Object item : array1) {
            if (l2.remove(item)) continue;
            return false;
        }
        assert (l2.isEmpty());
        assert (PointCloud.unorderedHashCode(array1) == PointCloud.unorderedHashCode(array2));
        return true;
    }
}

