/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.ArrayList;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickRun;
import uk.ac.starlink.ttools.plot2.Ticker;
import uk.ac.starlink.util.Bi;

public abstract class PrefixTicker
implements Ticker {
    private final Scale scale_;
    private final BasicTicker basicTicker_;

    public PrefixTicker(Scale scale) {
        this.scale_ = scale;
        this.basicTicker_ = new BasicTicker(scale){

            @Override
            public BasicTicker.Rule createRule(double dlo, double dhi, double approxMajorCount, int adjust) {
                return PrefixTicker.this.createRule(dlo, dhi, approxMajorCount, adjust);
            }
        };
    }

    public abstract Rule createRule(double var1, double var3, double var5, int var7);

    @Override
    public TickRun getTicks(double dlo, double dhi, boolean withMinor, Captioner captioner, Orientation[] orients, int npix, double crowding) {
        Bi<Rule, Orientation> orule = this.getRule(dlo, dhi, captioner, orients, npix, crowding);
        Rule rule = (Rule)orule.getItem1();
        Orientation orient = (Orientation)orule.getItem2();
        Tick[] majors = this.getMajorTicks(rule, dlo, dhi);
        Tick[] ticks = withMinor ? PlotUtil.arrayConcat(majors, BasicTicker.getMinorTicks(rule, dlo, dhi)) : majors;
        return new TickRun(ticks, orient);
    }

    private Bi<Rule, Orientation> getRule(double dlo, double dhi, Captioner captioner, Orientation[] orients, int npix, double crowding) {
        if (dhi <= dlo) {
            throw new IllegalArgumentException("Bad range: " + dlo + " .. " + dhi);
        }
        double approxMajorCount = (double)Math.max(1, npix / 80) * crowding;
        Axis axis = new Axis(0, npix, dlo, dhi, this.scale_, false);
        int maxAdjust = -5;
        for (int adjust = 0; adjust > maxAdjust; --adjust) {
            Rule rule = this.createRule(dlo, dhi, approxMajorCount, adjust);
            Tick[] majors = this.getMajorTicks(rule, dlo, dhi);
            for (Orientation orient : orients) {
                if (BasicTicker.overlaps(majors, axis, captioner, orient)) continue;
                return new Bi((Object)rule, (Object)orient);
            }
        }
        Rule rule = this.createRule(dlo, dhi, approxMajorCount, maxAdjust);
        return new Bi((Object)rule, (Object)orients[0]);
    }

    private Tick[] getMajorTicks(Rule rule, double dlo, double dhi) {
        Caption noPrefix;
        ArrayList<Tick> list = new ArrayList<Tick>();
        Caption lastPrefix = noPrefix = Caption.createCaption("");
        boolean usedPrefix = false;
        long index = rule.floorIndex(dlo) - 1L;
        while (rule.indexToValue(index) <= dhi) {
            double major = rule.indexToValue(index);
            Caption prefix = rule.indexToPrefix(index);
            Caption caption = prefix = prefix == null ? noPrefix : prefix;
            if (major >= dlo && major <= dhi) {
                Caption suffix = rule.indexToSuffix(index);
                boolean pre = !prefix.equals(lastPrefix);
                usedPrefix = usedPrefix || pre;
                Caption caption2 = pre ? prefix.append(suffix) : suffix;
                list.add(new Tick(major, caption2));
            }
            lastPrefix = prefix;
            ++index;
        }
        Tick[] ticks = list.toArray(new Tick[0]);
        if (lastPrefix != noPrefix && !usedPrefix && ticks.length > 0) {
            int imid = 0;
            Tick tick = ticks[imid];
            ticks[imid] = new Tick(tick.getValue(), lastPrefix.append(tick.getLabel()));
        }
        return ticks;
    }

    public static interface Rule
    extends BasicTicker.Rule {
        public Caption indexToPrefix(long var1);

        public Caption indexToSuffix(long var1);
    }
}

