/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.plot2.ReportMeta;

public abstract class ReportKey<T> {
    private final ReportMeta meta_;
    private final Class<T> clazz_;
    private final boolean isGeneralInterest_;

    public ReportKey(ReportMeta meta, Class<T> clazz, boolean isGeneralInterest) {
        this.meta_ = meta;
        this.clazz_ = clazz;
        this.isGeneralInterest_ = isGeneralInterest;
    }

    public ReportMeta getMeta() {
        return this.meta_;
    }

    public Class<T> getValueClass() {
        return this.clazz_;
    }

    public boolean isGeneralInterest() {
        return this.isGeneralInterest_;
    }

    public abstract String toText(T var1);

    public static ReportKey<String> createStringKey(ReportMeta meta, boolean isGeneralInterest) {
        return new ReportKey<String>(meta, String.class, isGeneralInterest){

            @Override
            public String toText(String value) {
                return value;
            }
        };
    }

    public static ReportKey<Double> createDoubleKey(ReportMeta meta, boolean isGeneralInterest) {
        return new ReportKey<Double>(meta, Double.class, isGeneralInterest){

            @Override
            public String toText(Double value) {
                if (value == null) {
                    return null;
                }
                double dval = value;
                return Math.abs(dval) < 3.4028234663852886E38 && Math.abs(dval) > 1.1754943508222875E-38 ? Float.toString((float)dval) : Double.toString(dval);
            }
        };
    }

    public static ReportKey<Integer> createIntegerKey(ReportMeta meta, boolean isGeneralInterest) {
        return new ReportKey<Integer>(meta, Integer.class, isGeneralInterest){

            @Override
            public String toText(Integer value) {
                return value == null ? null : value.toString();
            }
        };
    }

    public static <T> ReportKey<T> createObjectKey(ReportMeta meta, Class<T> clazz, boolean isGeneralInterest) {
        return new ReportKey<T>(meta, (Class)clazz, isGeneralInterest){

            @Override
            public String toText(T value) {
                return value == null ? null : value.toString();
            }
        };
    }

    public static ReportKey<StarTable> createTableKey(ReportMeta meta, boolean isGeneralInterest) {
        return new ReportKey<StarTable>(meta, StarTable.class, isGeneralInterest){

            @Override
            public String toText(StarTable table) {
                return table == null ? "null" : "table " + table.getColumnCount() + " x " + table.getRowCount();
            }
        };
    }

    public static <T> ReportKey<T> createUnprintableKey(ReportMeta meta, Class<T> clazz) {
        return new ReportKey<T>(meta, (Class)clazz, false){

            @Override
            public String toText(T value) {
                return "[unprintable]";
            }
        };
    }
}

