/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Insets;
import java.awt.Rectangle;

public class Surround {
    public Block top;
    public Block left;
    public Block bottom;
    public Block right;

    public Surround() {
        this(new Block(), new Block(), new Block(), new Block());
    }

    public Surround(Surround other) {
        this(new Block(other.top), new Block(other.left), new Block(other.bottom), new Block(other.right));
    }

    public Surround(Block top, Block left, Block bottom, Block right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Insets toInsets() {
        int itop = Surround.max3(this.top.extent, this.left.under, this.right.under);
        int ileft = Surround.max3(this.left.extent, this.top.under, this.bottom.under);
        int ibottom = Surround.max3(this.bottom.extent, this.left.over, this.right.over);
        int iright = Surround.max3(this.right.extent, this.top.over, this.bottom.over);
        return new Insets(itop, ileft, ibottom, iright);
    }

    public Insets toExtentInsets() {
        return new Insets(this.top.extent, this.left.extent, this.bottom.extent, this.right.extent);
    }

    public Rectangle[] getRegions(Rectangle inner) {
        int x = inner.x;
        int y = inner.y;
        int w = inner.width;
        int h = inner.height;
        Rectangle topRect = new Rectangle(x - this.top.under, y - this.top.extent, w + this.top.under + this.top.over, this.top.extent);
        Rectangle leftRect = new Rectangle(x - this.left.extent, y - this.left.under, this.left.extent, h + this.left.under + this.left.over);
        Rectangle bottomRect = new Rectangle(x - this.bottom.under, y + h, w + this.bottom.under + this.bottom.over, this.bottom.extent);
        Rectangle rightRect = new Rectangle(x + w, y - this.right.under, this.right.extent, h + this.right.under + this.right.over);
        return new Rectangle[]{topRect, leftRect, bottomRect, rightRect};
    }

    public boolean addExternalRectangle(Rectangle inner, Rectangle addBox) {
        int ixlo = inner.x;
        int ixhi = inner.x + inner.width;
        int iylo = inner.y;
        int iyhi = inner.y + inner.height;
        int axlo = addBox.x;
        int axhi = addBox.x + addBox.width;
        int aylo = addBox.y;
        int ayhi = addBox.y + addBox.height;
        int extLeft = Math.max(0, ixlo - axlo);
        int extRight = Math.max(0, axhi - ixhi);
        int extTop = Math.max(0, iylo - aylo);
        int extBottom = Math.max(0, ayhi - iyhi);
        boolean isOverlapX = axhi > ixlo && axlo < ixhi;
        boolean isOverlapY = ayhi > iylo && aylo < iyhi;
        int nedge = 0;
        if (axhi <= ixlo && isOverlapY) {
            this.left = this.left.union(new Block(extLeft, extTop, extBottom));
            ++nedge;
        }
        if (axlo >= ixhi && isOverlapY) {
            this.right = this.right.union(new Block(extRight, extTop, extBottom));
            ++nedge;
        }
        if (ayhi <= iylo && isOverlapX) {
            this.top = this.top.union(new Block(extTop, extLeft, extRight));
            ++nedge;
        }
        if (aylo >= iyhi && isOverlapX) {
            this.bottom = this.bottom.union(new Block(extBottom, extLeft, extRight));
            ++nedge;
        }
        assert (nedge <= 1);
        return nedge > 0;
    }

    public String toString() {
        return this.top + ", " + this.left + ", " + this.bottom + ", " + this.right;
    }

    public Surround add(Surround other) {
        return new Surround(this.top.add(other.top), this.left.add(other.left), this.bottom.add(other.bottom), this.right.add(other.right));
    }

    public Surround union(Surround other) {
        return new Surround(this.top.union(other.top), this.left.union(other.left), this.bottom.union(other.bottom), this.right.union(other.right));
    }

    public static Surround fromInsets(Insets insets) {
        return new Surround(new Block(insets.top), new Block(insets.left), new Block(insets.bottom), new Block(insets.right));
    }

    private static int max3(int i1, int i2, int i3) {
        return Math.max(i1, Math.max(i2, i3));
    }

    public static class Block {
        public int extent;
        public int under;
        public int over;

        public Block() {
            this(0, 0, 0);
        }

        public Block(Block other) {
            this(other.extent, other.under, other.over);
        }

        public Block(int extent) {
            this(extent, 0, 0);
        }

        public Block(int extent, int under, int over) {
            this.extent = extent;
            this.under = under;
            this.over = over;
        }

        public Block add(Block other) {
            return new Block(this.extent + other.extent, Math.max(this.under, other.under), Math.max(this.over, other.over));
        }

        public Block union(Block other) {
            return new Block(Math.max(this.extent, other.extent), Math.max(this.under, other.under), Math.max(this.over, other.over));
        }

        public String toString() {
            return this.under + "-" + this.extent + "-" + this.over;
        }
    }
}

