/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class BooleanConfigKey
extends ConfigKey<Boolean> {
    private static final Set<String> TRUE_STRINGS = new HashSet<String>(Arrays.asList("true", "t", "yes", "y", "1"));
    private static final Set<String> FALSE_STRINGS = new HashSet<String>(Arrays.asList("false", "f", "no", "n", "0"));

    public BooleanConfigKey(ConfigMeta meta, boolean dflt) {
        super(meta, Boolean.class, dflt);
        if (meta.getStringUsage() == null) {
            meta.setStringUsage("true|false");
        }
    }

    public BooleanConfigKey(ConfigMeta meta) {
        this(meta, false);
    }

    @Override
    public Boolean stringToValue(String txt) throws ConfigException {
        if (BooleanConfigKey.isTrue(txt)) {
            return Boolean.TRUE;
        }
        if (BooleanConfigKey.isFalse(txt)) {
            return Boolean.FALSE;
        }
        throw new ConfigException(this, "\"" + txt + "\" not boolean");
    }

    @Override
    public String valueToString(Boolean value) {
        return value.toString();
    }

    @Override
    public Specifier<Boolean> createSpecifier() {
        return new SpecifierPanel<Boolean>(false){
            final JCheckBox checkBox_;
            {
                this.checkBox_ = new JCheckBox();
                this.checkBox_.setSelected(Boolean.TRUE.equals(BooleanConfigKey.this.getDefaultValue()));
                this.checkBox_.addActionListener(this.getActionForwarder());
            }

            @Override
            public JComponent createComponent() {
                return this.checkBox_;
            }

            @Override
            public Boolean getSpecifiedValue() {
                return this.checkBox_.isSelected();
            }

            @Override
            public void setSpecifiedValue(Boolean v) {
                this.checkBox_.setSelected(Boolean.TRUE.equals(v));
                this.fireAction();
            }

            @Override
            public void submitReport(ReportMap report) {
            }
        };
    }

    public static boolean isTrue(String txt) {
        return txt != null && TRUE_STRINGS.contains(txt.toLowerCase());
    }

    public static boolean isFalse(String txt) {
        return txt != null && FALSE_STRINGS.contains(txt.toLowerCase());
    }
}

