/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.ttools.plot2.config.ToggleSpecifier;

public class CombinationConfigKey
extends ConfigKey<boolean[]> {
    private final int nopt_;
    private final String[] optNames_;
    private final String nullLabel_;
    private final boolean nullPermitted_;

    public CombinationConfigKey(ConfigMeta meta, boolean[] dflt, String[] optNames, String nullLabel) {
        super(meta, boolean[].class, dflt);
        this.optNames_ = optNames;
        this.nullLabel_ = nullLabel;
        this.nullPermitted_ = nullLabel != null;
        this.nopt_ = optNames.length;
        if (dflt == null) {
            if (!this.nullPermitted_) {
                throw new NullPointerException();
            }
        } else if (dflt.length != this.nopt_) {
            throw new IllegalArgumentException("Array length mismatch");
        }
    }

    public CombinationConfigKey(ConfigMeta meta, String[] optNames) {
        this(meta, CombinationConfigKey.createTrueArray(optNames.length), optNames, null);
    }

    @Override
    public boolean[] stringToValue(String txt) throws ConfigException {
        if (this.nullPermitted_ && (txt == null || txt.trim().length() == 0)) {
            return null;
        }
        boolean[] value = new boolean[this.nopt_];
        for (int ic = 0; ic < txt.length(); ++ic) {
            value[this.optCharToIndex((char)txt.charAt((int)ic))] = true;
        }
        return value;
    }

    @Override
    public String valueToString(boolean[] opts) {
        StringBuffer sbuf = new StringBuffer();
        if (opts != null) {
            for (int io = 0; io < this.nopt_; ++io) {
                if (!opts[io]) continue;
                sbuf.append(this.optIndexToChar(io));
            }
        }
        return sbuf.toString();
    }

    @Override
    public Specifier<boolean[]> createSpecifier() {
        CheckBoxesSpecifier basicSpecifier = new CheckBoxesSpecifier();
        return this.nullLabel_ == null ? basicSpecifier : new ToggleSpecifier<Object>(basicSpecifier, null, this.nullLabel_);
    }

    public int optCharToIndex(char c) throws ConfigException {
        char lc = Character.toLowerCase(c);
        for (int io = 0; io < this.nopt_; ++io) {
            if (lc != this.optIndexToChar(io)) continue;
            return io;
        }
        StringBuffer sbuf = new StringBuffer().append("Unknown option letter '").append(c).append("'; expecting one of ");
        for (int io = 0; io < this.nopt_; ++io) {
            if (io > 0) {
                sbuf.append(", ");
            }
            sbuf.append("'").append(this.optIndexToChar(io)).append("'");
        }
        throw new ConfigException(this, sbuf.toString());
    }

    public char optIndexToChar(int io) {
        return Character.toLowerCase(this.optNames_[io].charAt(0));
    }

    private static boolean[] createTrueArray(int n) {
        boolean[] a = new boolean[n];
        Arrays.fill(a, true);
        return a;
    }

    private class CheckBoxesSpecifier
    extends SpecifierPanel<boolean[]> {
        private final JCheckBox[] checkBoxes_;

        CheckBoxesSpecifier() {
            super(false);
            this.checkBoxes_ = new JCheckBox[CombinationConfigKey.this.nopt_];
            boolean[] dflt = (boolean[])CombinationConfigKey.this.getDefaultValue();
            for (int io = 0; io < CombinationConfigKey.this.nopt_; ++io) {
                JCheckBox checkBox = new JCheckBox(CombinationConfigKey.this.optNames_[io], dflt == null ? true : dflt[io]);
                checkBox.addActionListener(this.getActionForwarder());
                this.checkBoxes_[io] = checkBox;
            }
        }

        @Override
        public JComponent createComponent() {
            Box box = new Box(0){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    for (int io = 0; io < CombinationConfigKey.this.nopt_; ++io) {
                        CheckBoxesSpecifier.this.checkBoxes_[io].setEnabled(enabled);
                    }
                }
            };
            for (int io = 0; io < CombinationConfigKey.this.nopt_; ++io) {
                if (io > 0) {
                    box.add(Box.createHorizontalStrut(10));
                }
                box.add(this.checkBoxes_[io]);
            }
            return box;
        }

        @Override
        public boolean[] getSpecifiedValue() {
            boolean[] flags = new boolean[CombinationConfigKey.this.nopt_];
            for (int io = 0; io < CombinationConfigKey.this.nopt_; ++io) {
                flags[io] = this.checkBoxes_[io].isSelected();
            }
            return flags;
        }

        @Override
        public void setSpecifiedValue(boolean[] flags) {
            boolean change = false;
            for (int io = 0; io < CombinationConfigKey.this.nopt_; ++io) {
                JCheckBox checkBox = this.checkBoxes_[io];
                change = change || flags[io] ^ checkBox.isSelected();
                checkBox.setSelected(flags[io]);
            }
            if (change) {
                this.fireAction();
            }
        }

        @Override
        public void submitReport(ReportMap report) {
        }
    }
}

