/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.util.gui.ComboBoxBumper;
import uk.ac.starlink.util.gui.CustomComboBoxRenderer;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class ComboBoxSpecifier<V>
extends SpecifierPanel<V> {
    private final Class<V> clazz_;
    private final JComboBox<V> comboBox_;
    private final boolean allowAny_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.config");

    public ComboBoxSpecifier(Class<V> clazz, JComboBox<V> comboBox, boolean customStringify, boolean allowAny) {
        super(comboBox.isEditable());
        this.clazz_ = clazz;
        this.comboBox_ = comboBox;
        this.allowAny_ = allowAny;
        if (customStringify) {
            this.comboBox_.setRenderer((ListCellRenderer<V>)new CustomComboBoxRenderer<V>(this.stringify(null)){

                protected String mapValue(V value) {
                    return ComboBoxSpecifier.this.stringify(value);
                }
            });
        }
    }

    public ComboBoxSpecifier(Class<V> clazz, JComboBox<V> comboBox) {
        this(clazz, comboBox, false, true);
    }

    public ComboBoxSpecifier(Class<V> clazz, Collection<V> options) {
        this(clazz, new JComboBox<V>(new Vector<V>(options)), true, true);
        if (options.size() > this.comboBox_.getMaximumRowCount() && options.size() < 10) {
            this.comboBox_.setMaximumRowCount(10);
        }
        this.comboBox_.setSelectedIndex(0);
    }

    public ComboBoxSpecifier(V[] options) {
        this(options.getClass().getComponentType(), Arrays.asList(options));
    }

    public String stringify(V value) {
        return value == null ? null : value.toString();
    }

    @Override
    protected JComponent createComponent() {
        final Box line = Box.createHorizontalBox();
        line.add((Component)new ShrinkWrapper(this.comboBox_));
        line.add(Box.createHorizontalStrut(5));
        line.add((Component)new ComboBoxBumper(this.comboBox_));
        this.comboBox_.addActionListener(this.getActionForwarder());
        line.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ComboBoxSpecifier.this.comboBox_.setEnabled(line.isEnabled());
                }
            }
        });
        return line;
    }

    @Override
    public V getSpecifiedValue() {
        Object selObj = this.comboBox_.getSelectedItem();
        V selValue = this.clazz_.isInstance(selObj) ? (V)this.clazz_.cast(selObj) : null;
        return selValue;
    }

    @Override
    public void setSpecifiedValue(V value) {
        boolean tmpEditable;
        boolean bl = tmpEditable = this.allowAny_ && !this.comboBox_.isEditable();
        if (tmpEditable) {
            this.comboBox_.setEditable(true);
        }
        this.comboBox_.setSelectedItem(value);
        if (tmpEditable) {
            this.comboBox_.setEditable(false);
        }
        if (!PlotUtil.equals(this.comboBox_.getSelectedItem(), value)) {
            assert (!this.allowAny_);
            logger_.warning("Attempt to set unlisted value " + value + " failed");
        }
    }

    @Override
    public void submitReport(ReportMap report) {
    }

    public JComboBox<V> getComboBox() {
        return this.comboBox_;
    }
}

