/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;

public class LoggingConfigMap
extends ConfigMap {
    private final ConfigMap base_;
    private final Level level_;
    private final Logger logger_;
    private final Set<ConfigKey<?>> logged_;

    public LoggingConfigMap(ConfigMap base, Level level) {
        this.base_ = base;
        this.level_ = level;
        this.logger_ = Logger.getLogger(this.getClass().getName());
        this.logged_ = new HashSet();
    }

    @Override
    public <T> T get(ConfigKey<T> key) {
        T value = super.get(key);
        if (this.logger_.isLoggable(this.level_) && this.logged_.add(key)) {
            this.logger_.log(this.level_, new StringBuffer().append("Config: ").append(key.getMeta().getShortName()).append("=").append(value).toString());
        }
        return value;
    }
}

