/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class MultiSpecifierPanel<T>
extends SpecifierPanel<T> {
    private final List<Specifier<T>> specifiers_;

    public MultiSpecifierPanel(boolean isXFill, T dflt, List<Specifier<T>> specifiers) {
        super(isXFill);
        this.specifiers_ = specifiers;
        this.setSpecifiedValue(dflt);
    }

    @Override
    protected JComponent createComponent() {
        Box box = new Box(0){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Specifier s : MultiSpecifierPanel.this.specifiers_) {
                    s.getComponent().setEnabled(enabled);
                }
            }
        };
        final ActionListener forwarder = this.getActionForwarder();
        boolean start = true;
        for (Specifier<T> s : this.specifiers_) {
            if (!start) {
                box.add(Box.createHorizontalStrut(10));
            }
            start = false;
            box.add(s.getComponent());
            final Specifier<T> s0 = s;
            s0.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Object value = s0.getSpecifiedValue();
                    for (Specifier s1 : MultiSpecifierPanel.this.specifiers_) {
                        if (s1 == s0) continue;
                        s1.setSpecifiedValue(value);
                    }
                    forwarder.actionPerformed(evt);
                }
            });
        }
        return box;
    }

    @Override
    public void setSpecifiedValue(T value) {
        for (Specifier<T> s : this.specifiers_) {
            s.setSpecifiedValue(value);
        }
    }

    @Override
    public T getSpecifiedValue() {
        return this.specifiers_.get(0).getSpecifiedValue();
    }

    @Override
    public void submitReport(ReportMap report) {
        for (Specifier<T> s : this.specifiers_) {
            s.submitReport(report);
        }
    }
}

